package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReceiverBuilder extends ReceiverFluentImpl<ReceiverBuilder> implements VisitableBuilder<Receiver,ReceiverBuilder>{
  public ReceiverBuilder() {
    this(false);
  }
  public ReceiverBuilder(Boolean validationEnabled) {
    this(new Receiver(), validationEnabled);
  }
  public ReceiverBuilder(ReceiverFluent<?> fluent) {
    this(fluent, false);
  }
  public ReceiverBuilder(ReceiverFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Receiver(), validationEnabled);
  }
  public ReceiverBuilder(ReceiverFluent<?> fluent,Receiver instance) {
    this(fluent, instance, false);
  }
  public ReceiverBuilder(ReceiverFluent<?> fluent,Receiver instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEmailConfigs(instance.getEmailConfigs());
      fluent.withName(instance.getName());
      fluent.withOpsgenieConfigs(instance.getOpsgenieConfigs());
      fluent.withPagerdutyConfigs(instance.getPagerdutyConfigs());
      fluent.withPushoverConfigs(instance.getPushoverConfigs());
      fluent.withSlackConfigs(instance.getSlackConfigs());
      fluent.withVictoropsConfigs(instance.getVictoropsConfigs());
      fluent.withWebhookConfigs(instance.getWebhookConfigs());
      fluent.withWechatConfigs(instance.getWechatConfigs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReceiverBuilder(Receiver instance) {
    this(instance,false);
  }
  public ReceiverBuilder(Receiver instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEmailConfigs(instance.getEmailConfigs());
      this.withName(instance.getName());
      this.withOpsgenieConfigs(instance.getOpsgenieConfigs());
      this.withPagerdutyConfigs(instance.getPagerdutyConfigs());
      this.withPushoverConfigs(instance.getPushoverConfigs());
      this.withSlackConfigs(instance.getSlackConfigs());
      this.withVictoropsConfigs(instance.getVictoropsConfigs());
      this.withWebhookConfigs(instance.getWebhookConfigs());
      this.withWechatConfigs(instance.getWechatConfigs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReceiverFluent<?> fluent;
  Boolean validationEnabled;
  public Receiver build() {
    Receiver buildable = new Receiver(fluent.getEmailConfigs(),fluent.getName(),fluent.getOpsgenieConfigs(),fluent.getPagerdutyConfigs(),fluent.getPushoverConfigs(),fluent.getSlackConfigs(),fluent.getVictoropsConfigs(),fluent.getWebhookConfigs(),fluent.getWechatConfigs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}