package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ThanosRulerSpecFluentImpl<A extends ThanosRulerSpecFluent<A>> extends BaseFluent<A> implements ThanosRulerSpecFluent<A>{
  public ThanosRulerSpecFluentImpl() {
  }
  public ThanosRulerSpecFluentImpl(ThanosRulerSpec instance) {
    if (instance != null) {
      this.withAffinity(instance.getAffinity());
      this.withAlertDropLabels(instance.getAlertDropLabels());
      this.withAlertQueryUrl(instance.getAlertQueryUrl());
      this.withAlertRelabelConfigFile(instance.getAlertRelabelConfigFile());
      this.withAlertRelabelConfigs(instance.getAlertRelabelConfigs());
      this.withAlertmanagersConfig(instance.getAlertmanagersConfig());
      this.withAlertmanagersUrl(instance.getAlertmanagersUrl());
      this.withContainers(instance.getContainers());
      this.withEnforcedNamespaceLabel(instance.getEnforcedNamespaceLabel());
      this.withEvaluationInterval(instance.getEvaluationInterval());
      this.withExternalPrefix(instance.getExternalPrefix());
      this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig());
      this.withImage(instance.getImage());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withInitContainers(instance.getInitContainers());
      this.withLabels(instance.getLabels());
      this.withListenLocal(instance.getListenLocal());
      this.withLogFormat(instance.getLogFormat());
      this.withLogLevel(instance.getLogLevel());
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withNodeSelector(instance.getNodeSelector());
      this.withObjectStorageConfig(instance.getObjectStorageConfig());
      this.withObjectStorageConfigFile(instance.getObjectStorageConfigFile());
      this.withPaused(instance.getPaused());
      this.withPodMetadata(instance.getPodMetadata());
      this.withPortName(instance.getPortName());
      this.withPriorityClassName(instance.getPriorityClassName());
      this.withPrometheusRulesExcludedFromEnforce(instance.getPrometheusRulesExcludedFromEnforce());
      this.withQueryConfig(instance.getQueryConfig());
      this.withQueryEndpoints(instance.getQueryEndpoints());
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
      this.withRetention(instance.getRetention());
      this.withRoutePrefix(instance.getRoutePrefix());
      this.withRuleNamespaceSelector(instance.getRuleNamespaceSelector());
      this.withRuleSelector(instance.getRuleSelector());
      this.withSecurityContext(instance.getSecurityContext());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withStorage(instance.getStorage());
      this.withTolerations(instance.getTolerations());
      this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      this.withTracingConfig(instance.getTracingConfig());
      this.withVolumes(instance.getVolumes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Affinity affinity;
  private List<String> alertDropLabels = new ArrayList<String>();
  private String alertQueryUrl;
  private String alertRelabelConfigFile;
  private SecretKeySelector alertRelabelConfigs;
  private SecretKeySelector alertmanagersConfig;
  private List<String> alertmanagersUrl = new ArrayList<String>();
  private ArrayList<ContainerBuilder> containers = new ArrayList<ContainerBuilder>();
  private String enforcedNamespaceLabel;
  private String evaluationInterval;
  private String externalPrefix;
  private TLSConfigBuilder grpcServerTlsConfig;
  private String image;
  private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
  private ArrayList<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
  private Map<String,String> labels;
  private Boolean listenLocal;
  private String logFormat;
  private String logLevel;
  private Integer minReadySeconds;
  private Map<String,String> nodeSelector;
  private SecretKeySelector objectStorageConfig;
  private String objectStorageConfigFile;
  private Boolean paused;
  private EmbeddedObjectMetadataBuilder podMetadata;
  private String portName;
  private String priorityClassName;
  private ArrayList<PrometheusRuleExcludeConfigBuilder> prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();
  private SecretKeySelector queryConfig;
  private List<String> queryEndpoints = new ArrayList<String>();
  private Integer replicas;
  private ResourceRequirementsBuilder resources;
  private String retention;
  private String routePrefix;
  private LabelSelectorBuilder ruleNamespaceSelector;
  private LabelSelectorBuilder ruleSelector;
  private PodSecurityContext securityContext;
  private String serviceAccountName;
  private StorageSpecBuilder storage;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
  private SecretKeySelector tracingConfig;
  private List<Volume> volumes = new ArrayList<Volume>();
  private Map<String,Object> additionalProperties;
  public Affinity getAffinity() {
    return this.affinity;
  }
  public A withAffinity(Affinity affinity) {
    this.affinity=affinity; return (A) this;
  }
  public Boolean hasAffinity() {
    return this.affinity != null;
  }
  public A addToAlertDropLabels(int index,String item) {
    if (this.alertDropLabels == null) {this.alertDropLabels = new ArrayList<String>();}
    this.alertDropLabels.add(index, item);
    return (A)this;
  }
  public A setToAlertDropLabels(int index,String item) {
    if (this.alertDropLabels == null) {this.alertDropLabels = new ArrayList<String>();}
    this.alertDropLabels.set(index, item); return (A)this;
  }
  public A addToAlertDropLabels(java.lang.String... items) {
    if (this.alertDropLabels == null) {this.alertDropLabels = new ArrayList<String>();}
    for (String item : items) {this.alertDropLabels.add(item);} return (A)this;
  }
  public A addAllToAlertDropLabels(Collection<String> items) {
    if (this.alertDropLabels == null) {this.alertDropLabels = new ArrayList<String>();}
    for (String item : items) {this.alertDropLabels.add(item);} return (A)this;
  }
  public A removeFromAlertDropLabels(java.lang.String... items) {
    for (String item : items) {if (this.alertDropLabels!= null){ this.alertDropLabels.remove(item);}} return (A)this;
  }
  public A removeAllFromAlertDropLabels(Collection<String> items) {
    for (String item : items) {if (this.alertDropLabels!= null){ this.alertDropLabels.remove(item);}} return (A)this;
  }
  public List<String> getAlertDropLabels() {
    return this.alertDropLabels;
  }
  public String getAlertDropLabel(int index) {
    return this.alertDropLabels.get(index);
  }
  public String getFirstAlertDropLabel() {
    return this.alertDropLabels.get(0);
  }
  public String getLastAlertDropLabel() {
    return this.alertDropLabels.get(alertDropLabels.size() - 1);
  }
  public String getMatchingAlertDropLabel(Predicate<String> predicate) {
    for (String item: alertDropLabels) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAlertDropLabel(Predicate<String> predicate) {
    for (String item: alertDropLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAlertDropLabels(List<String> alertDropLabels) {
    if (alertDropLabels != null) {this.alertDropLabels = new ArrayList(); for (String item : alertDropLabels){this.addToAlertDropLabels(item);}} else { this.alertDropLabels = null;} return (A) this;
  }
  public A withAlertDropLabels(java.lang.String... alertDropLabels) {
    if (this.alertDropLabels != null) {this.alertDropLabels.clear(); _visitables.remove("alertDropLabels"); }
    if (alertDropLabels != null) {for (String item :alertDropLabels){ this.addToAlertDropLabels(item);}} return (A) this;
  }
  public Boolean hasAlertDropLabels() {
    return alertDropLabels != null && !alertDropLabels.isEmpty();
  }
  public String getAlertQueryUrl() {
    return this.alertQueryUrl;
  }
  public A withAlertQueryUrl(String alertQueryUrl) {
    this.alertQueryUrl=alertQueryUrl; return (A) this;
  }
  public Boolean hasAlertQueryUrl() {
    return this.alertQueryUrl != null;
  }
  public String getAlertRelabelConfigFile() {
    return this.alertRelabelConfigFile;
  }
  public A withAlertRelabelConfigFile(String alertRelabelConfigFile) {
    this.alertRelabelConfigFile=alertRelabelConfigFile; return (A) this;
  }
  public Boolean hasAlertRelabelConfigFile() {
    return this.alertRelabelConfigFile != null;
  }
  public SecretKeySelector getAlertRelabelConfigs() {
    return this.alertRelabelConfigs;
  }
  public A withAlertRelabelConfigs(SecretKeySelector alertRelabelConfigs) {
    this.alertRelabelConfigs=alertRelabelConfigs; return (A) this;
  }
  public Boolean hasAlertRelabelConfigs() {
    return this.alertRelabelConfigs != null;
  }
  public A withNewAlertRelabelConfigs(String key,String name,Boolean optional) {
    return (A)withAlertRelabelConfigs(new SecretKeySelector(key, name, optional));
  }
  public SecretKeySelector getAlertmanagersConfig() {
    return this.alertmanagersConfig;
  }
  public A withAlertmanagersConfig(SecretKeySelector alertmanagersConfig) {
    this.alertmanagersConfig=alertmanagersConfig; return (A) this;
  }
  public Boolean hasAlertmanagersConfig() {
    return this.alertmanagersConfig != null;
  }
  public A withNewAlertmanagersConfig(String key,String name,Boolean optional) {
    return (A)withAlertmanagersConfig(new SecretKeySelector(key, name, optional));
  }
  public A addToAlertmanagersUrl(int index,String item) {
    if (this.alertmanagersUrl == null) {this.alertmanagersUrl = new ArrayList<String>();}
    this.alertmanagersUrl.add(index, item);
    return (A)this;
  }
  public A setToAlertmanagersUrl(int index,String item) {
    if (this.alertmanagersUrl == null) {this.alertmanagersUrl = new ArrayList<String>();}
    this.alertmanagersUrl.set(index, item); return (A)this;
  }
  public A addToAlertmanagersUrl(java.lang.String... items) {
    if (this.alertmanagersUrl == null) {this.alertmanagersUrl = new ArrayList<String>();}
    for (String item : items) {this.alertmanagersUrl.add(item);} return (A)this;
  }
  public A addAllToAlertmanagersUrl(Collection<String> items) {
    if (this.alertmanagersUrl == null) {this.alertmanagersUrl = new ArrayList<String>();}
    for (String item : items) {this.alertmanagersUrl.add(item);} return (A)this;
  }
  public A removeFromAlertmanagersUrl(java.lang.String... items) {
    for (String item : items) {if (this.alertmanagersUrl!= null){ this.alertmanagersUrl.remove(item);}} return (A)this;
  }
  public A removeAllFromAlertmanagersUrl(Collection<String> items) {
    for (String item : items) {if (this.alertmanagersUrl!= null){ this.alertmanagersUrl.remove(item);}} return (A)this;
  }
  public List<String> getAlertmanagersUrl() {
    return this.alertmanagersUrl;
  }
  public String getAlertmanagersUrl(int index) {
    return this.alertmanagersUrl.get(index);
  }
  public String getFirstAlertmanagersUrl() {
    return this.alertmanagersUrl.get(0);
  }
  public String getLastAlertmanagersUrl() {
    return this.alertmanagersUrl.get(alertmanagersUrl.size() - 1);
  }
  public String getMatchingAlertmanagersUrl(Predicate<String> predicate) {
    for (String item: alertmanagersUrl) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAlertmanagersUrl(Predicate<String> predicate) {
    for (String item: alertmanagersUrl) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAlertmanagersUrl(List<String> alertmanagersUrl) {
    if (alertmanagersUrl != null) {this.alertmanagersUrl = new ArrayList(); for (String item : alertmanagersUrl){this.addToAlertmanagersUrl(item);}} else { this.alertmanagersUrl = null;} return (A) this;
  }
  public A withAlertmanagersUrl(java.lang.String... alertmanagersUrl) {
    if (this.alertmanagersUrl != null) {this.alertmanagersUrl.clear(); _visitables.remove("alertmanagersUrl"); }
    if (alertmanagersUrl != null) {for (String item :alertmanagersUrl){ this.addToAlertmanagersUrl(item);}} return (A) this;
  }
  public Boolean hasAlertmanagersUrl() {
    return alertmanagersUrl != null && !alertmanagersUrl.isEmpty();
  }
  public A addToContainers(int index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= containers.size()) { _visitables.get("containers").add(builder); containers.add(builder); } else { _visitables.get("containers").add(index, builder); containers.add(index, builder);}
    return (A)this;
  }
  public A setToContainers(int index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= containers.size()) { _visitables.get("containers").add(builder); containers.add(builder); } else { _visitables.get("containers").set(index, builder); containers.set(index, builder);}
    return (A)this;
  }
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A addAllToContainers(Collection<Container> items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
    if (containers == null) return (A) this;
    final Iterator<ContainerBuilder> each = containers.iterator();
    final List visitables = _visitables.get("containers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getContainers() {
    return containers != null ? build(containers) : null;
  }
  public List<Container> buildContainers() {
    return containers != null ? build(containers) : null;
  }
  public Container buildContainer(int index) {
    return this.containers.get(index).build();
  }
  public Container buildFirstContainer() {
    return this.containers.get(0).build();
  }
  public Container buildLastContainer() {
    return this.containers.get(containers.size() - 1).build();
  }
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: containers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: containers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainers(List<Container> containers) {
    if (this.containers != null) { _visitables.get("containers").clear();}
    if (containers != null) {this.containers = new ArrayList(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
  }
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers) {
    if (this.containers != null) {this.containers.clear(); _visitables.remove("containers"); }
    if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
  }
  public Boolean hasContainers() {
    return containers != null && !containers.isEmpty();
  }
  public ThanosRulerSpecFluentImpl.ContainersNested<A> addNewContainer() {
    return new ThanosRulerSpecFluentImpl.ContainersNestedImpl();
  }
  public ThanosRulerSpecFluentImpl.ContainersNested<A> addNewContainerLike(Container item) {
    return new ThanosRulerSpecFluentImpl.ContainersNestedImpl(-1, item);
  }
  public ThanosRulerSpecFluentImpl.ContainersNested<A> setNewContainerLike(int index,Container item) {
    return new ThanosRulerSpecFluentImpl.ContainersNestedImpl(index, item);
  }
  public ThanosRulerSpecFluentImpl.ContainersNested<A> editContainer(int index) {
    if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public ThanosRulerSpecFluentImpl.ContainersNested<A> editFirstContainer() {
    if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
    return setNewContainerLike(0, buildContainer(0));
  }
  public ThanosRulerSpecFluentImpl.ContainersNested<A> editLastContainer() {
    int index = containers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public ThanosRulerSpecFluentImpl.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containers.size();i++) { 
    if (predicate.test(containers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public String getEnforcedNamespaceLabel() {
    return this.enforcedNamespaceLabel;
  }
  public A withEnforcedNamespaceLabel(String enforcedNamespaceLabel) {
    this.enforcedNamespaceLabel=enforcedNamespaceLabel; return (A) this;
  }
  public Boolean hasEnforcedNamespaceLabel() {
    return this.enforcedNamespaceLabel != null;
  }
  public String getEvaluationInterval() {
    return this.evaluationInterval;
  }
  public A withEvaluationInterval(String evaluationInterval) {
    this.evaluationInterval=evaluationInterval; return (A) this;
  }
  public Boolean hasEvaluationInterval() {
    return this.evaluationInterval != null;
  }
  public String getExternalPrefix() {
    return this.externalPrefix;
  }
  public A withExternalPrefix(String externalPrefix) {
    this.externalPrefix=externalPrefix; return (A) this;
  }
  public Boolean hasExternalPrefix() {
    return this.externalPrefix != null;
  }
  
  /**
   * This method has been deprecated, please use method buildGrpcServerTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSConfig getGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig!=null ?this.grpcServerTlsConfig.build():null;
  }
  public TLSConfig buildGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig!=null ?this.grpcServerTlsConfig.build():null;
  }
  public A withGrpcServerTlsConfig(TLSConfig grpcServerTlsConfig) {
    _visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig);
    if (grpcServerTlsConfig!=null){ this.grpcServerTlsConfig= new TLSConfigBuilder(grpcServerTlsConfig); _visitables.get("grpcServerTlsConfig").add(this.grpcServerTlsConfig);} else { this.grpcServerTlsConfig = null; _visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig); } return (A) this;
  }
  public Boolean hasGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig != null;
  }
  public ThanosRulerSpecFluentImpl.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig() {
    return new ThanosRulerSpecFluentImpl.GrpcServerTlsConfigNestedImpl();
  }
  public ThanosRulerSpecFluentImpl.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(TLSConfig item) {
    return new ThanosRulerSpecFluentImpl.GrpcServerTlsConfigNestedImpl(item);
  }
  public ThanosRulerSpecFluentImpl.GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig() {
    return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig());
  }
  public ThanosRulerSpecFluentImpl.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig() {
    return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig() != null ? getGrpcServerTlsConfig(): new TLSConfigBuilder().build());
  }
  public ThanosRulerSpecFluentImpl.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(TLSConfig item) {
    return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig() != null ? getGrpcServerTlsConfig(): item);
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public A addToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) { _visitables.get("imagePullSecrets").add(builder); imagePullSecrets.add(builder); } else { _visitables.get("imagePullSecrets").add(index, builder); imagePullSecrets.add(index, builder);}
    return (A)this;
  }
  public A setToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) { _visitables.get("imagePullSecrets").add(builder); imagePullSecrets.add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder); imagePullSecrets.set(index, builder);}
    return (A)this;
  }
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (imagePullSecrets == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
    final List visitables = _visitables.get("imagePullSecrets");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public List<LocalObjectReference> buildImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public LocalObjectReference buildImagePullSecret(int index) {
    return this.imagePullSecrets.get(index).build();
  }
  public LocalObjectReference buildFirstImagePullSecret() {
    return this.imagePullSecrets.get(0).build();
  }
  public LocalObjectReference buildLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
  }
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
    if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").clear();}
    if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
  }
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
    if (this.imagePullSecrets != null) {this.imagePullSecrets.clear(); _visitables.remove("imagePullSecrets"); }
    if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
  }
  public Boolean hasImagePullSecrets() {
    return imagePullSecrets != null && !imagePullSecrets.isEmpty();
  }
  public A addNewImagePullSecret(String name) {
    return (A)addToImagePullSecrets(new LocalObjectReference(name));
  }
  public ThanosRulerSpecFluentImpl.ImagePullSecretsNested<A> addNewImagePullSecret() {
    return new ThanosRulerSpecFluentImpl.ImagePullSecretsNestedImpl();
  }
  public ThanosRulerSpecFluentImpl.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
    return new ThanosRulerSpecFluentImpl.ImagePullSecretsNestedImpl(-1, item);
  }
  public ThanosRulerSpecFluentImpl.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item) {
    return new ThanosRulerSpecFluentImpl.ImagePullSecretsNestedImpl(index, item);
  }
  public ThanosRulerSpecFluentImpl.ImagePullSecretsNested<A> editImagePullSecret(int index) {
    if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public ThanosRulerSpecFluentImpl.ImagePullSecretsNested<A> editFirstImagePullSecret() {
    if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(0, buildImagePullSecret(0));
  }
  public ThanosRulerSpecFluentImpl.ImagePullSecretsNested<A> editLastImagePullSecret() {
    int index = imagePullSecrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public ThanosRulerSpecFluentImpl.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imagePullSecrets.size();i++) { 
    if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public A addToInitContainers(int index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= initContainers.size()) { _visitables.get("initContainers").add(builder); initContainers.add(builder); } else { _visitables.get("initContainers").add(index, builder); initContainers.add(index, builder);}
    return (A)this;
  }
  public A setToInitContainers(int index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= initContainers.size()) { _visitables.get("initContainers").add(builder); initContainers.add(builder); } else { _visitables.get("initContainers").set(index, builder); initContainers.set(index, builder);}
    return (A)this;
  }
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A addAllToInitContainers(Collection<Container> items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public List<Container> buildInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public Container buildInitContainer(int index) {
    return this.initContainers.get(index).build();
  }
  public Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  public Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInitContainers(List<Container> initContainers) {
    if (this.initContainers != null) { _visitables.get("initContainers").clear();}
    if (initContainers != null) {this.initContainers = new ArrayList(); for (Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
  }
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers) {
    if (this.initContainers != null) {this.initContainers.clear(); _visitables.remove("initContainers"); }
    if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
  }
  public Boolean hasInitContainers() {
    return initContainers != null && !initContainers.isEmpty();
  }
  public ThanosRulerSpecFluentImpl.InitContainersNested<A> addNewInitContainer() {
    return new ThanosRulerSpecFluentImpl.InitContainersNestedImpl();
  }
  public ThanosRulerSpecFluentImpl.InitContainersNested<A> addNewInitContainerLike(Container item) {
    return new ThanosRulerSpecFluentImpl.InitContainersNestedImpl(-1, item);
  }
  public ThanosRulerSpecFluentImpl.InitContainersNested<A> setNewInitContainerLike(int index,Container item) {
    return new ThanosRulerSpecFluentImpl.InitContainersNestedImpl(index, item);
  }
  public ThanosRulerSpecFluentImpl.InitContainersNested<A> editInitContainer(int index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public ThanosRulerSpecFluentImpl.InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  public ThanosRulerSpecFluentImpl.InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public ThanosRulerSpecFluentImpl.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public Boolean hasLabels() {
    return this.labels != null;
  }
  public Boolean getListenLocal() {
    return this.listenLocal;
  }
  public A withListenLocal(Boolean listenLocal) {
    this.listenLocal=listenLocal; return (A) this;
  }
  public Boolean hasListenLocal() {
    return this.listenLocal != null;
  }
  public String getLogFormat() {
    return this.logFormat;
  }
  public A withLogFormat(String logFormat) {
    this.logFormat=logFormat; return (A) this;
  }
  public Boolean hasLogFormat() {
    return this.logFormat != null;
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  public A withMinReadySeconds(Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  public Boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public SecretKeySelector getObjectStorageConfig() {
    return this.objectStorageConfig;
  }
  public A withObjectStorageConfig(SecretKeySelector objectStorageConfig) {
    this.objectStorageConfig=objectStorageConfig; return (A) this;
  }
  public Boolean hasObjectStorageConfig() {
    return this.objectStorageConfig != null;
  }
  public A withNewObjectStorageConfig(String key,String name,Boolean optional) {
    return (A)withObjectStorageConfig(new SecretKeySelector(key, name, optional));
  }
  public String getObjectStorageConfigFile() {
    return this.objectStorageConfigFile;
  }
  public A withObjectStorageConfigFile(String objectStorageConfigFile) {
    this.objectStorageConfigFile=objectStorageConfigFile; return (A) this;
  }
  public Boolean hasObjectStorageConfigFile() {
    return this.objectStorageConfigFile != null;
  }
  public Boolean getPaused() {
    return this.paused;
  }
  public A withPaused(Boolean paused) {
    this.paused=paused; return (A) this;
  }
  public Boolean hasPaused() {
    return this.paused != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPodMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public EmbeddedObjectMetadata getPodMetadata() {
    return this.podMetadata!=null ?this.podMetadata.build():null;
  }
  public EmbeddedObjectMetadata buildPodMetadata() {
    return this.podMetadata!=null ?this.podMetadata.build():null;
  }
  public A withPodMetadata(EmbeddedObjectMetadata podMetadata) {
    _visitables.get("podMetadata").remove(this.podMetadata);
    if (podMetadata!=null){ this.podMetadata= new EmbeddedObjectMetadataBuilder(podMetadata); _visitables.get("podMetadata").add(this.podMetadata);} else { this.podMetadata = null; _visitables.get("podMetadata").remove(this.podMetadata); } return (A) this;
  }
  public Boolean hasPodMetadata() {
    return this.podMetadata != null;
  }
  public ThanosRulerSpecFluentImpl.PodMetadataNested<A> withNewPodMetadata() {
    return new ThanosRulerSpecFluentImpl.PodMetadataNestedImpl();
  }
  public ThanosRulerSpecFluentImpl.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item) {
    return new ThanosRulerSpecFluentImpl.PodMetadataNestedImpl(item);
  }
  public ThanosRulerSpecFluentImpl.PodMetadataNested<A> editPodMetadata() {
    return withNewPodMetadataLike(getPodMetadata());
  }
  public ThanosRulerSpecFluentImpl.PodMetadataNested<A> editOrNewPodMetadata() {
    return withNewPodMetadataLike(getPodMetadata() != null ? getPodMetadata(): new EmbeddedObjectMetadataBuilder().build());
  }
  public ThanosRulerSpecFluentImpl.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item) {
    return withNewPodMetadataLike(getPodMetadata() != null ? getPodMetadata(): item);
  }
  public String getPortName() {
    return this.portName;
  }
  public A withPortName(String portName) {
    this.portName=portName; return (A) this;
  }
  public Boolean hasPortName() {
    return this.portName != null;
  }
  public String getPriorityClassName() {
    return this.priorityClassName;
  }
  public A withPriorityClassName(String priorityClassName) {
    this.priorityClassName=priorityClassName; return (A) this;
  }
  public Boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  public A addToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);
    if (index < 0 || index >= prometheusRulesExcludedFromEnforce.size()) { _visitables.get("prometheusRulesExcludedFromEnforce").add(builder); prometheusRulesExcludedFromEnforce.add(builder); } else { _visitables.get("prometheusRulesExcludedFromEnforce").add(index, builder); prometheusRulesExcludedFromEnforce.add(index, builder);}
    return (A)this;
  }
  public A setToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);
    if (index < 0 || index >= prometheusRulesExcludedFromEnforce.size()) { _visitables.get("prometheusRulesExcludedFromEnforce").add(builder); prometheusRulesExcludedFromEnforce.add(builder); } else { _visitables.get("prometheusRulesExcludedFromEnforce").set(index, builder); prometheusRulesExcludedFromEnforce.set(index, builder);}
    return (A)this;
  }
  public A addToPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... items) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").add(builder);this.prometheusRulesExcludedFromEnforce.add(builder);} return (A)this;
  }
  public A addAllToPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").add(builder);this.prometheusRulesExcludedFromEnforce.add(builder);} return (A)this;
  }
  public A removeFromPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... items) {
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").remove(builder);if (this.prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce.remove(builder);}} return (A)this;
  }
  public A removeAllFromPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items) {
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").remove(builder);if (this.prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
    if (prometheusRulesExcludedFromEnforce == null) return (A) this;
    final Iterator<PrometheusRuleExcludeConfigBuilder> each = prometheusRulesExcludedFromEnforce.iterator();
    final List visitables = _visitables.get("prometheusRulesExcludedFromEnforce");
    while (each.hasNext()) {
      PrometheusRuleExcludeConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPrometheusRulesExcludedFromEnforce instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PrometheusRuleExcludeConfig> getPrometheusRulesExcludedFromEnforce() {
    return prometheusRulesExcludedFromEnforce != null ? build(prometheusRulesExcludedFromEnforce) : null;
  }
  public List<PrometheusRuleExcludeConfig> buildPrometheusRulesExcludedFromEnforce() {
    return prometheusRulesExcludedFromEnforce != null ? build(prometheusRulesExcludedFromEnforce) : null;
  }
  public PrometheusRuleExcludeConfig buildPrometheusRulesExcludedFromEnforce(int index) {
    return this.prometheusRulesExcludedFromEnforce.get(index).build();
  }
  public PrometheusRuleExcludeConfig buildFirstPrometheusRulesExcludedFromEnforce() {
    return this.prometheusRulesExcludedFromEnforce.get(0).build();
  }
  public PrometheusRuleExcludeConfig buildLastPrometheusRulesExcludedFromEnforce() {
    return this.prometheusRulesExcludedFromEnforce.get(prometheusRulesExcludedFromEnforce.size() - 1).build();
  }
  public PrometheusRuleExcludeConfig buildMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
    for (PrometheusRuleExcludeConfigBuilder item: prometheusRulesExcludedFromEnforce) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
    for (PrometheusRuleExcludeConfigBuilder item: prometheusRulesExcludedFromEnforce) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPrometheusRulesExcludedFromEnforce(List<PrometheusRuleExcludeConfig> prometheusRulesExcludedFromEnforce) {
    if (this.prometheusRulesExcludedFromEnforce != null) { _visitables.get("prometheusRulesExcludedFromEnforce").clear();}
    if (prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce = new ArrayList(); for (PrometheusRuleExcludeConfig item : prometheusRulesExcludedFromEnforce){this.addToPrometheusRulesExcludedFromEnforce(item);}} else { this.prometheusRulesExcludedFromEnforce = null;} return (A) this;
  }
  public A withPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... prometheusRulesExcludedFromEnforce) {
    if (this.prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce.clear(); _visitables.remove("prometheusRulesExcludedFromEnforce"); }
    if (prometheusRulesExcludedFromEnforce != null) {for (PrometheusRuleExcludeConfig item :prometheusRulesExcludedFromEnforce){ this.addToPrometheusRulesExcludedFromEnforce(item);}} return (A) this;
  }
  public Boolean hasPrometheusRulesExcludedFromEnforce() {
    return prometheusRulesExcludedFromEnforce != null && !prometheusRulesExcludedFromEnforce.isEmpty();
  }
  public A addNewPrometheusRulesExcludedFromEnforce(String ruleName,String ruleNamespace) {
    return (A)addToPrometheusRulesExcludedFromEnforce(new PrometheusRuleExcludeConfig(ruleName, ruleNamespace));
  }
  public ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforce() {
    return new ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNestedImpl();
  }
  public ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforceLike(PrometheusRuleExcludeConfig item) {
    return new ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNestedImpl(-1, item);
  }
  public ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> setNewPrometheusRulesExcludedFromEnforceLike(int index,PrometheusRuleExcludeConfig item) {
    return new ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNestedImpl(index, item);
  }
  public ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> editPrometheusRulesExcludedFromEnforce(int index) {
    if (prometheusRulesExcludedFromEnforce.size() <= index) throw new RuntimeException("Can't edit prometheusRulesExcludedFromEnforce. Index exceeds size.");
    return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
  }
  public ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> editFirstPrometheusRulesExcludedFromEnforce() {
    if (prometheusRulesExcludedFromEnforce.size() == 0) throw new RuntimeException("Can't edit first prometheusRulesExcludedFromEnforce. The list is empty.");
    return setNewPrometheusRulesExcludedFromEnforceLike(0, buildPrometheusRulesExcludedFromEnforce(0));
  }
  public ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> editLastPrometheusRulesExcludedFromEnforce() {
    int index = prometheusRulesExcludedFromEnforce.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last prometheusRulesExcludedFromEnforce. The list is empty.");
    return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
  }
  public ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> editMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<prometheusRulesExcludedFromEnforce.size();i++) { 
    if (predicate.test(prometheusRulesExcludedFromEnforce.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching prometheusRulesExcludedFromEnforce. No match found.");
    return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
  }
  public SecretKeySelector getQueryConfig() {
    return this.queryConfig;
  }
  public A withQueryConfig(SecretKeySelector queryConfig) {
    this.queryConfig=queryConfig; return (A) this;
  }
  public Boolean hasQueryConfig() {
    return this.queryConfig != null;
  }
  public A withNewQueryConfig(String key,String name,Boolean optional) {
    return (A)withQueryConfig(new SecretKeySelector(key, name, optional));
  }
  public A addToQueryEndpoints(int index,String item) {
    if (this.queryEndpoints == null) {this.queryEndpoints = new ArrayList<String>();}
    this.queryEndpoints.add(index, item);
    return (A)this;
  }
  public A setToQueryEndpoints(int index,String item) {
    if (this.queryEndpoints == null) {this.queryEndpoints = new ArrayList<String>();}
    this.queryEndpoints.set(index, item); return (A)this;
  }
  public A addToQueryEndpoints(java.lang.String... items) {
    if (this.queryEndpoints == null) {this.queryEndpoints = new ArrayList<String>();}
    for (String item : items) {this.queryEndpoints.add(item);} return (A)this;
  }
  public A addAllToQueryEndpoints(Collection<String> items) {
    if (this.queryEndpoints == null) {this.queryEndpoints = new ArrayList<String>();}
    for (String item : items) {this.queryEndpoints.add(item);} return (A)this;
  }
  public A removeFromQueryEndpoints(java.lang.String... items) {
    for (String item : items) {if (this.queryEndpoints!= null){ this.queryEndpoints.remove(item);}} return (A)this;
  }
  public A removeAllFromQueryEndpoints(Collection<String> items) {
    for (String item : items) {if (this.queryEndpoints!= null){ this.queryEndpoints.remove(item);}} return (A)this;
  }
  public List<String> getQueryEndpoints() {
    return this.queryEndpoints;
  }
  public String getQueryEndpoint(int index) {
    return this.queryEndpoints.get(index);
  }
  public String getFirstQueryEndpoint() {
    return this.queryEndpoints.get(0);
  }
  public String getLastQueryEndpoint() {
    return this.queryEndpoints.get(queryEndpoints.size() - 1);
  }
  public String getMatchingQueryEndpoint(Predicate<String> predicate) {
    for (String item: queryEndpoints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingQueryEndpoint(Predicate<String> predicate) {
    for (String item: queryEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withQueryEndpoints(List<String> queryEndpoints) {
    if (queryEndpoints != null) {this.queryEndpoints = new ArrayList(); for (String item : queryEndpoints){this.addToQueryEndpoints(item);}} else { this.queryEndpoints = null;} return (A) this;
  }
  public A withQueryEndpoints(java.lang.String... queryEndpoints) {
    if (this.queryEndpoints != null) {this.queryEndpoints.clear(); _visitables.remove("queryEndpoints"); }
    if (queryEndpoints != null) {for (String item :queryEndpoints){ this.addToQueryEndpoints(item);}} return (A) this;
  }
  public Boolean hasQueryEndpoints() {
    return queryEndpoints != null && !queryEndpoints.isEmpty();
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public ThanosRulerSpecFluentImpl.ResourcesNested<A> withNewResources() {
    return new ThanosRulerSpecFluentImpl.ResourcesNestedImpl();
  }
  public ThanosRulerSpecFluentImpl.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ThanosRulerSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public ThanosRulerSpecFluentImpl.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public ThanosRulerSpecFluentImpl.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public ThanosRulerSpecFluentImpl.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public String getRetention() {
    return this.retention;
  }
  public A withRetention(String retention) {
    this.retention=retention; return (A) this;
  }
  public Boolean hasRetention() {
    return this.retention != null;
  }
  public String getRoutePrefix() {
    return this.routePrefix;
  }
  public A withRoutePrefix(String routePrefix) {
    this.routePrefix=routePrefix; return (A) this;
  }
  public Boolean hasRoutePrefix() {
    return this.routePrefix != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRuleNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRuleNamespaceSelector() {
    return this.ruleNamespaceSelector!=null ?this.ruleNamespaceSelector.build():null;
  }
  public LabelSelector buildRuleNamespaceSelector() {
    return this.ruleNamespaceSelector!=null ?this.ruleNamespaceSelector.build():null;
  }
  public A withRuleNamespaceSelector(LabelSelector ruleNamespaceSelector) {
    _visitables.get("ruleNamespaceSelector").remove(this.ruleNamespaceSelector);
    if (ruleNamespaceSelector!=null){ this.ruleNamespaceSelector= new LabelSelectorBuilder(ruleNamespaceSelector); _visitables.get("ruleNamespaceSelector").add(this.ruleNamespaceSelector);} else { this.ruleNamespaceSelector = null; _visitables.get("ruleNamespaceSelector").remove(this.ruleNamespaceSelector); } return (A) this;
  }
  public Boolean hasRuleNamespaceSelector() {
    return this.ruleNamespaceSelector != null;
  }
  public ThanosRulerSpecFluentImpl.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelector() {
    return new ThanosRulerSpecFluentImpl.RuleNamespaceSelectorNestedImpl();
  }
  public ThanosRulerSpecFluentImpl.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelectorLike(LabelSelector item) {
    return new ThanosRulerSpecFluentImpl.RuleNamespaceSelectorNestedImpl(item);
  }
  public ThanosRulerSpecFluentImpl.RuleNamespaceSelectorNested<A> editRuleNamespaceSelector() {
    return withNewRuleNamespaceSelectorLike(getRuleNamespaceSelector());
  }
  public ThanosRulerSpecFluentImpl.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelector() {
    return withNewRuleNamespaceSelectorLike(getRuleNamespaceSelector() != null ? getRuleNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public ThanosRulerSpecFluentImpl.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelectorLike(LabelSelector item) {
    return withNewRuleNamespaceSelectorLike(getRuleNamespaceSelector() != null ? getRuleNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRuleSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRuleSelector() {
    return this.ruleSelector!=null ?this.ruleSelector.build():null;
  }
  public LabelSelector buildRuleSelector() {
    return this.ruleSelector!=null ?this.ruleSelector.build():null;
  }
  public A withRuleSelector(LabelSelector ruleSelector) {
    _visitables.get("ruleSelector").remove(this.ruleSelector);
    if (ruleSelector!=null){ this.ruleSelector= new LabelSelectorBuilder(ruleSelector); _visitables.get("ruleSelector").add(this.ruleSelector);} else { this.ruleSelector = null; _visitables.get("ruleSelector").remove(this.ruleSelector); } return (A) this;
  }
  public Boolean hasRuleSelector() {
    return this.ruleSelector != null;
  }
  public ThanosRulerSpecFluentImpl.RuleSelectorNested<A> withNewRuleSelector() {
    return new ThanosRulerSpecFluentImpl.RuleSelectorNestedImpl();
  }
  public ThanosRulerSpecFluentImpl.RuleSelectorNested<A> withNewRuleSelectorLike(LabelSelector item) {
    return new ThanosRulerSpecFluentImpl.RuleSelectorNestedImpl(item);
  }
  public ThanosRulerSpecFluentImpl.RuleSelectorNested<A> editRuleSelector() {
    return withNewRuleSelectorLike(getRuleSelector());
  }
  public ThanosRulerSpecFluentImpl.RuleSelectorNested<A> editOrNewRuleSelector() {
    return withNewRuleSelectorLike(getRuleSelector() != null ? getRuleSelector(): new LabelSelectorBuilder().build());
  }
  public ThanosRulerSpecFluentImpl.RuleSelectorNested<A> editOrNewRuleSelectorLike(LabelSelector item) {
    return withNewRuleSelectorLike(getRuleSelector() != null ? getRuleSelector(): item);
  }
  public PodSecurityContext getSecurityContext() {
    return this.securityContext;
  }
  public A withSecurityContext(PodSecurityContext securityContext) {
    this.securityContext=securityContext; return (A) this;
  }
  public Boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @Deprecated
  public StorageSpec getStorage() {
    return this.storage!=null ?this.storage.build():null;
  }
  public StorageSpec buildStorage() {
    return this.storage!=null ?this.storage.build():null;
  }
  public A withStorage(StorageSpec storage) {
    _visitables.get("storage").remove(this.storage);
    if (storage!=null){ this.storage= new StorageSpecBuilder(storage); _visitables.get("storage").add(this.storage);} else { this.storage = null; _visitables.get("storage").remove(this.storage); } return (A) this;
  }
  public Boolean hasStorage() {
    return this.storage != null;
  }
  public ThanosRulerSpecFluentImpl.StorageNested<A> withNewStorage() {
    return new ThanosRulerSpecFluentImpl.StorageNestedImpl();
  }
  public ThanosRulerSpecFluentImpl.StorageNested<A> withNewStorageLike(StorageSpec item) {
    return new ThanosRulerSpecFluentImpl.StorageNestedImpl(item);
  }
  public ThanosRulerSpecFluentImpl.StorageNested<A> editStorage() {
    return withNewStorageLike(getStorage());
  }
  public ThanosRulerSpecFluentImpl.StorageNested<A> editOrNewStorage() {
    return withNewStorageLike(getStorage() != null ? getStorage(): new StorageSpecBuilder().build());
  }
  public ThanosRulerSpecFluentImpl.StorageNested<A> editOrNewStorageLike(StorageSpec item) {
    return withNewStorageLike(getStorage() != null ? getStorage(): item);
  }
  public A addToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  public Toleration getToleration(int index) {
    return this.tolerations.get(index);
  }
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear(); _visitables.remove("tolerations"); }
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.add(index, item);
    return (A)this;
  }
  public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.set(index, item); return (A)this;
  }
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
    return this.topologySpreadConstraints;
  }
  public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
    return this.topologySpreadConstraints.get(index);
  }
  public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(0);
  }
  public TopologySpreadConstraint getLastTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
  }
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
    if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new ArrayList(); for (TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
  }
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear(); _visitables.remove("topologySpreadConstraints"); }
    if (topologySpreadConstraints != null) {for (TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
  }
  public Boolean hasTopologySpreadConstraints() {
    return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
  }
  public SecretKeySelector getTracingConfig() {
    return this.tracingConfig;
  }
  public A withTracingConfig(SecretKeySelector tracingConfig) {
    this.tracingConfig=tracingConfig; return (A) this;
  }
  public Boolean hasTracingConfig() {
    return this.tracingConfig != null;
  }
  public A withNewTracingConfig(String key,String name,Boolean optional) {
    return (A)withTracingConfig(new SecretKeySelector(key, name, optional));
  }
  public A addToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    this.volumes.add(index, item);
    return (A)this;
  }
  public A setToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    this.volumes.set(index, item); return (A)this;
  }
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    for (Volume item : items) {this.volumes.add(item);} return (A)this;
  }
  public A addAllToVolumes(Collection<Volume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    for (Volume item : items) {this.volumes.add(item);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<Volume> items) {
    for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public List<Volume> getVolumes() {
    return this.volumes;
  }
  public Volume getVolume(int index) {
    return this.volumes.get(index);
  }
  public Volume getFirstVolume() {
    return this.volumes.get(0);
  }
  public Volume getLastVolume() {
    return this.volumes.get(volumes.size() - 1);
  }
  public Volume getMatchingVolume(Predicate<Volume> predicate) {
    for (Volume item: volumes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
    for (Volume item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<Volume> volumes) {
    if (volumes != null) {this.volumes = new ArrayList(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {this.volumes.clear(); _visitables.remove("volumes"); }
    if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ThanosRulerSpecFluentImpl that = (ThanosRulerSpecFluentImpl) o;
    if (!java.util.Objects.equals(affinity, that.affinity)) return false;

    if (!java.util.Objects.equals(alertDropLabels, that.alertDropLabels)) return false;

    if (!java.util.Objects.equals(alertQueryUrl, that.alertQueryUrl)) return false;

    if (!java.util.Objects.equals(alertRelabelConfigFile, that.alertRelabelConfigFile)) return false;

    if (!java.util.Objects.equals(alertRelabelConfigs, that.alertRelabelConfigs)) return false;

    if (!java.util.Objects.equals(alertmanagersConfig, that.alertmanagersConfig)) return false;

    if (!java.util.Objects.equals(alertmanagersUrl, that.alertmanagersUrl)) return false;

    if (!java.util.Objects.equals(containers, that.containers)) return false;

    if (!java.util.Objects.equals(enforcedNamespaceLabel, that.enforcedNamespaceLabel)) return false;

    if (!java.util.Objects.equals(evaluationInterval, that.evaluationInterval)) return false;

    if (!java.util.Objects.equals(externalPrefix, that.externalPrefix)) return false;

    if (!java.util.Objects.equals(grpcServerTlsConfig, that.grpcServerTlsConfig)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(imagePullSecrets, that.imagePullSecrets)) return false;

    if (!java.util.Objects.equals(initContainers, that.initContainers)) return false;

    if (!java.util.Objects.equals(labels, that.labels)) return false;

    if (!java.util.Objects.equals(listenLocal, that.listenLocal)) return false;

    if (!java.util.Objects.equals(logFormat, that.logFormat)) return false;

    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;

    if (!java.util.Objects.equals(minReadySeconds, that.minReadySeconds)) return false;

    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;

    if (!java.util.Objects.equals(objectStorageConfig, that.objectStorageConfig)) return false;

    if (!java.util.Objects.equals(objectStorageConfigFile, that.objectStorageConfigFile)) return false;

    if (!java.util.Objects.equals(paused, that.paused)) return false;

    if (!java.util.Objects.equals(podMetadata, that.podMetadata)) return false;

    if (!java.util.Objects.equals(portName, that.portName)) return false;

    if (!java.util.Objects.equals(priorityClassName, that.priorityClassName)) return false;

    if (!java.util.Objects.equals(prometheusRulesExcludedFromEnforce, that.prometheusRulesExcludedFromEnforce)) return false;

    if (!java.util.Objects.equals(queryConfig, that.queryConfig)) return false;

    if (!java.util.Objects.equals(queryEndpoints, that.queryEndpoints)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(retention, that.retention)) return false;

    if (!java.util.Objects.equals(routePrefix, that.routePrefix)) return false;

    if (!java.util.Objects.equals(ruleNamespaceSelector, that.ruleNamespaceSelector)) return false;

    if (!java.util.Objects.equals(ruleSelector, that.ruleSelector)) return false;

    if (!java.util.Objects.equals(securityContext, that.securityContext)) return false;

    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;

    if (!java.util.Objects.equals(storage, that.storage)) return false;

    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;

    if (!java.util.Objects.equals(topologySpreadConstraints, that.topologySpreadConstraints)) return false;

    if (!java.util.Objects.equals(tracingConfig, that.tracingConfig)) return false;

    if (!java.util.Objects.equals(volumes, that.volumes)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(affinity,  alertDropLabels,  alertQueryUrl,  alertRelabelConfigFile,  alertRelabelConfigs,  alertmanagersConfig,  alertmanagersUrl,  containers,  enforcedNamespaceLabel,  evaluationInterval,  externalPrefix,  grpcServerTlsConfig,  image,  imagePullSecrets,  initContainers,  labels,  listenLocal,  logFormat,  logLevel,  minReadySeconds,  nodeSelector,  objectStorageConfig,  objectStorageConfigFile,  paused,  podMetadata,  portName,  priorityClassName,  prometheusRulesExcludedFromEnforce,  queryConfig,  queryEndpoints,  replicas,  resources,  retention,  routePrefix,  ruleNamespaceSelector,  ruleSelector,  securityContext,  serviceAccountName,  storage,  tolerations,  topologySpreadConstraints,  tracingConfig,  volumes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (alertDropLabels != null && !alertDropLabels.isEmpty()) { sb.append("alertDropLabels:"); sb.append(alertDropLabels + ","); }
    if (alertQueryUrl != null) { sb.append("alertQueryUrl:"); sb.append(alertQueryUrl + ","); }
    if (alertRelabelConfigFile != null) { sb.append("alertRelabelConfigFile:"); sb.append(alertRelabelConfigFile + ","); }
    if (alertRelabelConfigs != null) { sb.append("alertRelabelConfigs:"); sb.append(alertRelabelConfigs + ","); }
    if (alertmanagersConfig != null) { sb.append("alertmanagersConfig:"); sb.append(alertmanagersConfig + ","); }
    if (alertmanagersUrl != null && !alertmanagersUrl.isEmpty()) { sb.append("alertmanagersUrl:"); sb.append(alertmanagersUrl + ","); }
    if (containers != null && !containers.isEmpty()) { sb.append("containers:"); sb.append(containers + ","); }
    if (enforcedNamespaceLabel != null) { sb.append("enforcedNamespaceLabel:"); sb.append(enforcedNamespaceLabel + ","); }
    if (evaluationInterval != null) { sb.append("evaluationInterval:"); sb.append(evaluationInterval + ","); }
    if (externalPrefix != null) { sb.append("externalPrefix:"); sb.append(externalPrefix + ","); }
    if (grpcServerTlsConfig != null) { sb.append("grpcServerTlsConfig:"); sb.append(grpcServerTlsConfig + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (imagePullSecrets != null && !imagePullSecrets.isEmpty()) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (listenLocal != null) { sb.append("listenLocal:"); sb.append(listenLocal + ","); }
    if (logFormat != null) { sb.append("logFormat:"); sb.append(logFormat + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (objectStorageConfig != null) { sb.append("objectStorageConfig:"); sb.append(objectStorageConfig + ","); }
    if (objectStorageConfigFile != null) { sb.append("objectStorageConfigFile:"); sb.append(objectStorageConfigFile + ","); }
    if (paused != null) { sb.append("paused:"); sb.append(paused + ","); }
    if (podMetadata != null) { sb.append("podMetadata:"); sb.append(podMetadata + ","); }
    if (portName != null) { sb.append("portName:"); sb.append(portName + ","); }
    if (priorityClassName != null) { sb.append("priorityClassName:"); sb.append(priorityClassName + ","); }
    if (prometheusRulesExcludedFromEnforce != null && !prometheusRulesExcludedFromEnforce.isEmpty()) { sb.append("prometheusRulesExcludedFromEnforce:"); sb.append(prometheusRulesExcludedFromEnforce + ","); }
    if (queryConfig != null) { sb.append("queryConfig:"); sb.append(queryConfig + ","); }
    if (queryEndpoints != null && !queryEndpoints.isEmpty()) { sb.append("queryEndpoints:"); sb.append(queryEndpoints + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (retention != null) { sb.append("retention:"); sb.append(retention + ","); }
    if (routePrefix != null) { sb.append("routePrefix:"); sb.append(routePrefix + ","); }
    if (ruleNamespaceSelector != null) { sb.append("ruleNamespaceSelector:"); sb.append(ruleNamespaceSelector + ","); }
    if (ruleSelector != null) { sb.append("ruleSelector:"); sb.append(ruleSelector + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty()) { sb.append("topologySpreadConstraints:"); sb.append(topologySpreadConstraints + ","); }
    if (tracingConfig != null) { sb.append("tracingConfig:"); sb.append(tracingConfig + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withListenLocal() {
    return withListenLocal(true);
  }
  public A withPaused() {
    return withPaused(true);
  }
  class ContainersNestedImpl<N> extends ContainerFluentImpl<ThanosRulerSpecFluentImpl.ContainersNested<N>> implements ThanosRulerSpecFluentImpl.ContainersNested<N>,Nested<N>{
    ContainersNestedImpl(int index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    int index;
    public N and() {
      return (N) ThanosRulerSpecFluentImpl.this.setToContainers(index,builder.build());
    }
    public N endContainer() {
      return and();
    }
    
  }
  class GrpcServerTlsConfigNestedImpl<N> extends TLSConfigFluentImpl<ThanosRulerSpecFluentImpl.GrpcServerTlsConfigNested<N>> implements ThanosRulerSpecFluentImpl.GrpcServerTlsConfigNested<N>,Nested<N>{
    GrpcServerTlsConfigNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    GrpcServerTlsConfigNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) ThanosRulerSpecFluentImpl.this.withGrpcServerTlsConfig(builder.build());
    }
    public N endGrpcServerTlsConfig() {
      return and();
    }
    
  }
  class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<ThanosRulerSpecFluentImpl.ImagePullSecretsNested<N>> implements ThanosRulerSpecFluentImpl.ImagePullSecretsNested<N>,Nested<N>{
    ImagePullSecretsNestedImpl(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ImagePullSecretsNestedImpl() {
      this.index = -1;
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    public N and() {
      return (N) ThanosRulerSpecFluentImpl.this.setToImagePullSecrets(index,builder.build());
    }
    public N endImagePullSecret() {
      return and();
    }
    
  }
  class InitContainersNestedImpl<N> extends ContainerFluentImpl<ThanosRulerSpecFluentImpl.InitContainersNested<N>> implements ThanosRulerSpecFluentImpl.InitContainersNested<N>,Nested<N>{
    InitContainersNestedImpl(int index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    InitContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    int index;
    public N and() {
      return (N) ThanosRulerSpecFluentImpl.this.setToInitContainers(index,builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  class PodMetadataNestedImpl<N> extends EmbeddedObjectMetadataFluentImpl<ThanosRulerSpecFluentImpl.PodMetadataNested<N>> implements ThanosRulerSpecFluentImpl.PodMetadataNested<N>,Nested<N>{
    PodMetadataNestedImpl(EmbeddedObjectMetadata item) {
      this.builder = new EmbeddedObjectMetadataBuilder(this, item);
    }
    PodMetadataNestedImpl() {
      this.builder = new EmbeddedObjectMetadataBuilder(this);
    }
    EmbeddedObjectMetadataBuilder builder;
    public N and() {
      return (N) ThanosRulerSpecFluentImpl.this.withPodMetadata(builder.build());
    }
    public N endPodMetadata() {
      return and();
    }
    
  }
  class PrometheusRulesExcludedFromEnforceNestedImpl<N> extends PrometheusRuleExcludeConfigFluentImpl<ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<N>> implements ThanosRulerSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<N>,Nested<N>{
    PrometheusRulesExcludedFromEnforceNestedImpl(int index,PrometheusRuleExcludeConfig item) {
      this.index = index;
      this.builder = new PrometheusRuleExcludeConfigBuilder(this, item);
    }
    PrometheusRulesExcludedFromEnforceNestedImpl() {
      this.index = -1;
      this.builder = new PrometheusRuleExcludeConfigBuilder(this);
    }
    PrometheusRuleExcludeConfigBuilder builder;
    int index;
    public N and() {
      return (N) ThanosRulerSpecFluentImpl.this.setToPrometheusRulesExcludedFromEnforce(index,builder.build());
    }
    public N endPrometheusRulesExcludedFromEnforce() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ThanosRulerSpecFluentImpl.ResourcesNested<N>> implements ThanosRulerSpecFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) ThanosRulerSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class RuleNamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ThanosRulerSpecFluentImpl.RuleNamespaceSelectorNested<N>> implements ThanosRulerSpecFluentImpl.RuleNamespaceSelectorNested<N>,Nested<N>{
    RuleNamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    RuleNamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ThanosRulerSpecFluentImpl.this.withRuleNamespaceSelector(builder.build());
    }
    public N endRuleNamespaceSelector() {
      return and();
    }
    
  }
  class RuleSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ThanosRulerSpecFluentImpl.RuleSelectorNested<N>> implements ThanosRulerSpecFluentImpl.RuleSelectorNested<N>,Nested<N>{
    RuleSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    RuleSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ThanosRulerSpecFluentImpl.this.withRuleSelector(builder.build());
    }
    public N endRuleSelector() {
      return and();
    }
    
  }
  class StorageNestedImpl<N> extends StorageSpecFluentImpl<ThanosRulerSpecFluentImpl.StorageNested<N>> implements ThanosRulerSpecFluentImpl.StorageNested<N>,Nested<N>{
    StorageNestedImpl(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageNestedImpl() {
      this.builder = new StorageSpecBuilder(this);
    }
    StorageSpecBuilder builder;
    public N and() {
      return (N) ThanosRulerSpecFluentImpl.this.withStorage(builder.build());
    }
    public N endStorage() {
      return and();
    }
    
  }
  
}