package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SafeTLSConfigFluentImpl<A extends SafeTLSConfigFluent<A>> extends BaseFluent<A> implements SafeTLSConfigFluent<A>{
  public SafeTLSConfigFluentImpl() {
  }
  public SafeTLSConfigFluentImpl(SafeTLSConfig instance) {
    if (instance != null) {
      this.withCa(instance.getCa());
      this.withCert(instance.getCert());
      this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      this.withKeySecret(instance.getKeySecret());
      this.withServerName(instance.getServerName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private SecretOrConfigMapBuilder ca;
  private SecretOrConfigMapBuilder cert;
  private Boolean insecureSkipVerify;
  private SecretKeySelector keySecret;
  private String serverName;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretOrConfigMap getCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public SecretOrConfigMap buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(SecretOrConfigMap ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new SecretOrConfigMapBuilder(ca); _visitables.get("ca").add(this.ca);} else { this.ca = null; _visitables.get("ca").remove(this.ca); } return (A) this;
  }
  public Boolean hasCa() {
    return this.ca != null;
  }
  public SafeTLSConfigFluentImpl.CaNested<A> withNewCa() {
    return new SafeTLSConfigFluentImpl.CaNestedImpl();
  }
  public SafeTLSConfigFluentImpl.CaNested<A> withNewCaLike(SecretOrConfigMap item) {
    return new SafeTLSConfigFluentImpl.CaNestedImpl(item);
  }
  public SafeTLSConfigFluentImpl.CaNested<A> editCa() {
    return withNewCaLike(getCa());
  }
  public SafeTLSConfigFluentImpl.CaNested<A> editOrNewCa() {
    return withNewCaLike(getCa() != null ? getCa(): new SecretOrConfigMapBuilder().build());
  }
  public SafeTLSConfigFluentImpl.CaNested<A> editOrNewCaLike(SecretOrConfigMap item) {
    return withNewCaLike(getCa() != null ? getCa(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCert instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretOrConfigMap getCert() {
    return this.cert!=null ?this.cert.build():null;
  }
  public SecretOrConfigMap buildCert() {
    return this.cert!=null ?this.cert.build():null;
  }
  public A withCert(SecretOrConfigMap cert) {
    _visitables.get("cert").remove(this.cert);
    if (cert!=null){ this.cert= new SecretOrConfigMapBuilder(cert); _visitables.get("cert").add(this.cert);} else { this.cert = null; _visitables.get("cert").remove(this.cert); } return (A) this;
  }
  public Boolean hasCert() {
    return this.cert != null;
  }
  public SafeTLSConfigFluentImpl.CertNested<A> withNewCert() {
    return new SafeTLSConfigFluentImpl.CertNestedImpl();
  }
  public SafeTLSConfigFluentImpl.CertNested<A> withNewCertLike(SecretOrConfigMap item) {
    return new SafeTLSConfigFluentImpl.CertNestedImpl(item);
  }
  public SafeTLSConfigFluentImpl.CertNested<A> editCert() {
    return withNewCertLike(getCert());
  }
  public SafeTLSConfigFluentImpl.CertNested<A> editOrNewCert() {
    return withNewCertLike(getCert() != null ? getCert(): new SecretOrConfigMapBuilder().build());
  }
  public SafeTLSConfigFluentImpl.CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
    return withNewCertLike(getCert() != null ? getCert(): item);
  }
  public Boolean getInsecureSkipVerify() {
    return this.insecureSkipVerify;
  }
  public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
    this.insecureSkipVerify=insecureSkipVerify; return (A) this;
  }
  public Boolean hasInsecureSkipVerify() {
    return this.insecureSkipVerify != null;
  }
  public SecretKeySelector getKeySecret() {
    return this.keySecret;
  }
  public A withKeySecret(SecretKeySelector keySecret) {
    this.keySecret=keySecret; return (A) this;
  }
  public Boolean hasKeySecret() {
    return this.keySecret != null;
  }
  public A withNewKeySecret(String key,String name,Boolean optional) {
    return (A)withKeySecret(new SecretKeySelector(key, name, optional));
  }
  public String getServerName() {
    return this.serverName;
  }
  public A withServerName(String serverName) {
    this.serverName=serverName; return (A) this;
  }
  public Boolean hasServerName() {
    return this.serverName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SafeTLSConfigFluentImpl that = (SafeTLSConfigFluentImpl) o;
    if (!java.util.Objects.equals(ca, that.ca)) return false;

    if (!java.util.Objects.equals(cert, that.cert)) return false;

    if (!java.util.Objects.equals(insecureSkipVerify, that.insecureSkipVerify)) return false;

    if (!java.util.Objects.equals(keySecret, that.keySecret)) return false;

    if (!java.util.Objects.equals(serverName, that.serverName)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  cert,  insecureSkipVerify,  keySecret,  serverName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (cert != null) { sb.append("cert:"); sb.append(cert + ","); }
    if (insecureSkipVerify != null) { sb.append("insecureSkipVerify:"); sb.append(insecureSkipVerify + ","); }
    if (keySecret != null) { sb.append("keySecret:"); sb.append(keySecret + ","); }
    if (serverName != null) { sb.append("serverName:"); sb.append(serverName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withInsecureSkipVerify() {
    return withInsecureSkipVerify(true);
  }
  class CaNestedImpl<N> extends SecretOrConfigMapFluentImpl<SafeTLSConfigFluentImpl.CaNested<N>> implements SafeTLSConfigFluentImpl.CaNested<N>,Nested<N>{
    CaNestedImpl(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    CaNestedImpl() {
      this.builder = new SecretOrConfigMapBuilder(this);
    }
    SecretOrConfigMapBuilder builder;
    public N and() {
      return (N) SafeTLSConfigFluentImpl.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  class CertNestedImpl<N> extends SecretOrConfigMapFluentImpl<SafeTLSConfigFluentImpl.CertNested<N>> implements SafeTLSConfigFluentImpl.CertNested<N>,Nested<N>{
    CertNestedImpl(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    CertNestedImpl() {
      this.builder = new SecretOrConfigMapBuilder(this);
    }
    SecretOrConfigMapBuilder builder;
    public N and() {
      return (N) SafeTLSConfigFluentImpl.this.withCert(builder.build());
    }
    public N endCert() {
      return and();
    }
    
  }
  
}