package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusRuleBuilder extends PrometheusRuleFluentImpl<PrometheusRuleBuilder> implements VisitableBuilder<PrometheusRule,PrometheusRuleBuilder>{
  public PrometheusRuleBuilder() {
    this(false);
  }
  public PrometheusRuleBuilder(Boolean validationEnabled) {
    this(new PrometheusRule(), validationEnabled);
  }
  public PrometheusRuleBuilder(PrometheusRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusRuleBuilder(PrometheusRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrometheusRule(), validationEnabled);
  }
  public PrometheusRuleBuilder(PrometheusRuleFluent<?> fluent,PrometheusRule instance) {
    this(fluent, instance, false);
  }
  public PrometheusRuleBuilder(PrometheusRuleFluent<?> fluent,PrometheusRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PrometheusRuleBuilder(PrometheusRule instance) {
    this(instance,false);
  }
  public PrometheusRuleBuilder(PrometheusRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PrometheusRuleFluent<?> fluent;
  Boolean validationEnabled;
  public PrometheusRule build() {
    PrometheusRule buildable = new PrometheusRule(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}