package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProbeTargetIngressFluentImpl<A extends ProbeTargetIngressFluent<A>> extends BaseFluent<A> implements ProbeTargetIngressFluent<A>{
  public ProbeTargetIngressFluentImpl() {
  }
  public ProbeTargetIngressFluentImpl(ProbeTargetIngress instance) {
    if (instance != null) {
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withRelabelingConfigs(instance.getRelabelingConfigs());
      this.withSelector(instance.getSelector());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private NamespaceSelectorBuilder namespaceSelector;
  private ArrayList<RelabelConfigBuilder> relabelingConfigs = new ArrayList<RelabelConfigBuilder>();
  private LabelSelectorBuilder selector;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamespaceSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public NamespaceSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new NamespaceSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public ProbeTargetIngressFluentImpl.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new ProbeTargetIngressFluentImpl.NamespaceSelectorNestedImpl();
  }
  public ProbeTargetIngressFluentImpl.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
    return new ProbeTargetIngressFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public ProbeTargetIngressFluentImpl.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public ProbeTargetIngressFluentImpl.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new NamespaceSelectorBuilder().build());
  }
  public ProbeTargetIngressFluentImpl.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  public A addToRelabelingConfigs(int index,RelabelConfig item) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= relabelingConfigs.size()) { _visitables.get("relabelingConfigs").add(builder); relabelingConfigs.add(builder); } else { _visitables.get("relabelingConfigs").add(index, builder); relabelingConfigs.add(index, builder);}
    return (A)this;
  }
  public A setToRelabelingConfigs(int index,RelabelConfig item) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= relabelingConfigs.size()) { _visitables.get("relabelingConfigs").add(builder); relabelingConfigs.add(builder); } else { _visitables.get("relabelingConfigs").set(index, builder); relabelingConfigs.set(index, builder);}
    return (A)this;
  }
  public A addToRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").add(builder);this.relabelingConfigs.add(builder);} return (A)this;
  }
  public A addAllToRelabelingConfigs(Collection<RelabelConfig> items) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").add(builder);this.relabelingConfigs.add(builder);} return (A)this;
  }
  public A removeFromRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").remove(builder);if (this.relabelingConfigs != null) {this.relabelingConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelabelingConfigs(Collection<RelabelConfig> items) {
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").remove(builder);if (this.relabelingConfigs != null) {this.relabelingConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelabelingConfigs(Predicate<RelabelConfigBuilder> predicate) {
    if (relabelingConfigs == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = relabelingConfigs.iterator();
    final List visitables = _visitables.get("relabelingConfigs");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelabelingConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RelabelConfig> getRelabelingConfigs() {
    return relabelingConfigs != null ? build(relabelingConfigs) : null;
  }
  public List<RelabelConfig> buildRelabelingConfigs() {
    return relabelingConfigs != null ? build(relabelingConfigs) : null;
  }
  public RelabelConfig buildRelabelingConfig(int index) {
    return this.relabelingConfigs.get(index).build();
  }
  public RelabelConfig buildFirstRelabelingConfig() {
    return this.relabelingConfigs.get(0).build();
  }
  public RelabelConfig buildLastRelabelingConfig() {
    return this.relabelingConfigs.get(relabelingConfigs.size() - 1).build();
  }
  public RelabelConfig buildMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: relabelingConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: relabelingConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelabelingConfigs(List<RelabelConfig> relabelingConfigs) {
    if (this.relabelingConfigs != null) { _visitables.get("relabelingConfigs").clear();}
    if (relabelingConfigs != null) {this.relabelingConfigs = new ArrayList(); for (RelabelConfig item : relabelingConfigs){this.addToRelabelingConfigs(item);}} else { this.relabelingConfigs = null;} return (A) this;
  }
  public A withRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... relabelingConfigs) {
    if (this.relabelingConfigs != null) {this.relabelingConfigs.clear(); _visitables.remove("relabelingConfigs"); }
    if (relabelingConfigs != null) {for (RelabelConfig item :relabelingConfigs){ this.addToRelabelingConfigs(item);}} return (A) this;
  }
  public Boolean hasRelabelingConfigs() {
    return relabelingConfigs != null && !relabelingConfigs.isEmpty();
  }
  public ProbeTargetIngressFluentImpl.RelabelingConfigsNested<A> addNewRelabelingConfig() {
    return new ProbeTargetIngressFluentImpl.RelabelingConfigsNestedImpl();
  }
  public ProbeTargetIngressFluentImpl.RelabelingConfigsNested<A> addNewRelabelingConfigLike(RelabelConfig item) {
    return new ProbeTargetIngressFluentImpl.RelabelingConfigsNestedImpl(-1, item);
  }
  public ProbeTargetIngressFluentImpl.RelabelingConfigsNested<A> setNewRelabelingConfigLike(int index,RelabelConfig item) {
    return new ProbeTargetIngressFluentImpl.RelabelingConfigsNestedImpl(index, item);
  }
  public ProbeTargetIngressFluentImpl.RelabelingConfigsNested<A> editRelabelingConfig(int index) {
    if (relabelingConfigs.size() <= index) throw new RuntimeException("Can't edit relabelingConfigs. Index exceeds size.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  public ProbeTargetIngressFluentImpl.RelabelingConfigsNested<A> editFirstRelabelingConfig() {
    if (relabelingConfigs.size() == 0) throw new RuntimeException("Can't edit first relabelingConfigs. The list is empty.");
    return setNewRelabelingConfigLike(0, buildRelabelingConfig(0));
  }
  public ProbeTargetIngressFluentImpl.RelabelingConfigsNested<A> editLastRelabelingConfig() {
    int index = relabelingConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relabelingConfigs. The list is empty.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  public ProbeTargetIngressFluentImpl.RelabelingConfigsNested<A> editMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relabelingConfigs.size();i++) { 
    if (predicate.test(relabelingConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relabelingConfigs. No match found.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public ProbeTargetIngressFluentImpl.SelectorNested<A> withNewSelector() {
    return new ProbeTargetIngressFluentImpl.SelectorNestedImpl();
  }
  public ProbeTargetIngressFluentImpl.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new ProbeTargetIngressFluentImpl.SelectorNestedImpl(item);
  }
  public ProbeTargetIngressFluentImpl.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public ProbeTargetIngressFluentImpl.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public ProbeTargetIngressFluentImpl.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProbeTargetIngressFluentImpl that = (ProbeTargetIngressFluentImpl) o;
    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;

    if (!java.util.Objects.equals(relabelingConfigs, that.relabelingConfigs)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(namespaceSelector,  relabelingConfigs,  selector,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (relabelingConfigs != null && !relabelingConfigs.isEmpty()) { sb.append("relabelingConfigs:"); sb.append(relabelingConfigs + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class NamespaceSelectorNestedImpl<N> extends NamespaceSelectorFluentImpl<ProbeTargetIngressFluentImpl.NamespaceSelectorNested<N>> implements ProbeTargetIngressFluentImpl.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(NamespaceSelector item) {
      this.builder = new NamespaceSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new NamespaceSelectorBuilder(this);
    }
    NamespaceSelectorBuilder builder;
    public N and() {
      return (N) ProbeTargetIngressFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class RelabelingConfigsNestedImpl<N> extends RelabelConfigFluentImpl<ProbeTargetIngressFluentImpl.RelabelingConfigsNested<N>> implements ProbeTargetIngressFluentImpl.RelabelingConfigsNested<N>,Nested<N>{
    RelabelingConfigsNestedImpl(int index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelingConfigsNestedImpl() {
      this.index = -1;
      this.builder = new RelabelConfigBuilder(this);
    }
    RelabelConfigBuilder builder;
    int index;
    public N and() {
      return (N) ProbeTargetIngressFluentImpl.this.setToRelabelingConfigs(index,builder.build());
    }
    public N endRelabelingConfig() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ProbeTargetIngressFluentImpl.SelectorNested<N>> implements ProbeTargetIngressFluentImpl.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ProbeTargetIngressFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}