/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RelabelConfigFluentImpl<A extends RelabelConfigFluent<A>>
extends BaseFluent<A>
implements RelabelConfigFluent<A> {
    private String action;
    private Long modulus;
    private String regex;
    private String replacement;
    private String separator;
    private List<String> sourceLabels = new ArrayList<String>();
    private String targetLabel;
    private Map<String, Object> additionalProperties;

    public RelabelConfigFluentImpl() {
    }

    public RelabelConfigFluentImpl(RelabelConfig instance) {
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withModulus(instance.getModulus());
            this.withRegex(instance.getRegex());
            this.withReplacement(instance.getReplacement());
            this.withSeparator(instance.getSeparator());
            this.withSourceLabels(instance.getSourceLabels());
            this.withTargetLabel(instance.getTargetLabel());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    @Override
    public Boolean hasAction() {
        return this.action != null;
    }

    @Override
    public Long getModulus() {
        return this.modulus;
    }

    @Override
    public A withModulus(Long modulus) {
        this.modulus = modulus;
        return (A)this;
    }

    @Override
    public Boolean hasModulus() {
        return this.modulus != null;
    }

    @Override
    public String getRegex() {
        return this.regex;
    }

    @Override
    public A withRegex(String regex) {
        this.regex = regex;
        return (A)this;
    }

    @Override
    public Boolean hasRegex() {
        return this.regex != null;
    }

    @Override
    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public A withReplacement(String replacement) {
        this.replacement = replacement;
        return (A)this;
    }

    @Override
    public Boolean hasReplacement() {
        return this.replacement != null;
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public A withSeparator(String separator) {
        this.separator = separator;
        return (A)this;
    }

    @Override
    public Boolean hasSeparator() {
        return this.separator != null;
    }

    @Override
    public A addToSourceLabels(int index, String item) {
        if (this.sourceLabels == null) {
            this.sourceLabels = new ArrayList<String>();
        }
        this.sourceLabels.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSourceLabels(int index, String item) {
        if (this.sourceLabels == null) {
            this.sourceLabels = new ArrayList<String>();
        }
        this.sourceLabels.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSourceLabels(String ... items) {
        if (this.sourceLabels == null) {
            this.sourceLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.sourceLabels.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSourceLabels(Collection<String> items) {
        if (this.sourceLabels == null) {
            this.sourceLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.sourceLabels.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSourceLabels(String ... items) {
        for (String item : items) {
            if (this.sourceLabels == null) continue;
            this.sourceLabels.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSourceLabels(Collection<String> items) {
        for (String item : items) {
            if (this.sourceLabels == null) continue;
            this.sourceLabels.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSourceLabels() {
        return this.sourceLabels;
    }

    @Override
    public String getSourceLabel(int index) {
        return this.sourceLabels.get(index);
    }

    @Override
    public String getFirstSourceLabel() {
        return this.sourceLabels.get(0);
    }

    @Override
    public String getLastSourceLabel() {
        return this.sourceLabels.get(this.sourceLabels.size() - 1);
    }

    @Override
    public String getMatchingSourceLabel(Predicate<String> predicate) {
        for (String item : this.sourceLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSourceLabel(Predicate<String> predicate) {
        for (String item : this.sourceLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSourceLabels(List<String> sourceLabels) {
        if (sourceLabels != null) {
            this.sourceLabels = new ArrayList<String>();
            for (String item : sourceLabels) {
                this.addToSourceLabels(item);
            }
        } else {
            this.sourceLabels = null;
        }
        return (A)this;
    }

    @Override
    public A withSourceLabels(String ... sourceLabels) {
        if (this.sourceLabels != null) {
            this.sourceLabels.clear();
            this._visitables.remove((Object)"sourceLabels");
        }
        if (sourceLabels != null) {
            for (String item : sourceLabels) {
                this.addToSourceLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSourceLabels() {
        return this.sourceLabels != null && !this.sourceLabels.isEmpty();
    }

    @Override
    public String getTargetLabel() {
        return this.targetLabel;
    }

    @Override
    public A withTargetLabel(String targetLabel) {
        this.targetLabel = targetLabel;
        return (A)this;
    }

    @Override
    public Boolean hasTargetLabel() {
        return this.targetLabel != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RelabelConfigFluentImpl that = (RelabelConfigFluentImpl)o;
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.modulus, that.modulus)) {
            return false;
        }
        if (!Objects.equals(this.regex, that.regex)) {
            return false;
        }
        if (!Objects.equals(this.replacement, that.replacement)) {
            return false;
        }
        if (!Objects.equals(this.separator, that.separator)) {
            return false;
        }
        if (!Objects.equals(this.sourceLabels, that.sourceLabels)) {
            return false;
        }
        if (!Objects.equals(this.targetLabel, that.targetLabel)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.modulus, this.regex, this.replacement, this.separator, this.sourceLabels, this.targetLabel, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.modulus != null) {
            sb.append("modulus:");
            sb.append(this.modulus + ",");
        }
        if (this.regex != null) {
            sb.append("regex:");
            sb.append(this.regex + ",");
        }
        if (this.replacement != null) {
            sb.append("replacement:");
            sb.append(this.replacement + ",");
        }
        if (this.separator != null) {
            sb.append("separator:");
            sb.append(this.separator + ",");
        }
        if (this.sourceLabels != null && !this.sourceLabels.isEmpty()) {
            sb.append("sourceLabels:");
            sb.append(this.sourceLabels + ",");
        }
        if (this.targetLabel != null) {
            sb.append("targetLabel:");
            sb.append(this.targetLabel + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

