package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RouteFluentImpl<A extends RouteFluent<A>> extends BaseFluent<A> implements RouteFluent<A>{
  public RouteFluentImpl() {
  }
  public RouteFluentImpl(Route instance) {
    if (instance != null) {
      this.withContinue(instance.getContinue());
      this.withGroupBy(instance.getGroupBy());
      this.withGroupInterval(instance.getGroupInterval());
      this.withGroupWait(instance.getGroupWait());
      this.withMatchers(instance.getMatchers());
      this.withReceiver(instance.getReceiver());
      this.withRepeatInterval(instance.getRepeatInterval());
      this.withRoutes(instance.getRoutes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Boolean _continue;
  private List<String> groupBy = new ArrayList<String>();
  private String groupInterval;
  private String groupWait;
  private ArrayList<MatcherBuilder> matchers = new ArrayList<MatcherBuilder>();
  private String receiver;
  private String repeatInterval;
  private List<JsonNode> routes = new ArrayList<JsonNode>();
  private Map<String,Object> additionalProperties;
  public Boolean getContinue() {
    return this._continue;
  }
  public A withContinue(Boolean _continue) {
    this._continue=_continue; return (A) this;
  }
  public Boolean hasContinue() {
    return this._continue != null;
  }
  public A addToGroupBy(int index,String item) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    this.groupBy.add(index, item);
    return (A)this;
  }
  public A setToGroupBy(int index,String item) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    this.groupBy.set(index, item); return (A)this;
  }
  public A addToGroupBy(java.lang.String... items) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    for (String item : items) {this.groupBy.add(item);} return (A)this;
  }
  public A addAllToGroupBy(Collection<String> items) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    for (String item : items) {this.groupBy.add(item);} return (A)this;
  }
  public A removeFromGroupBy(java.lang.String... items) {
    for (String item : items) {if (this.groupBy!= null){ this.groupBy.remove(item);}} return (A)this;
  }
  public A removeAllFromGroupBy(Collection<String> items) {
    for (String item : items) {if (this.groupBy!= null){ this.groupBy.remove(item);}} return (A)this;
  }
  public List<String> getGroupBy() {
    return this.groupBy;
  }
  public String getGroupBy(int index) {
    return this.groupBy.get(index);
  }
  public String getFirstGroupBy() {
    return this.groupBy.get(0);
  }
  public String getLastGroupBy() {
    return this.groupBy.get(groupBy.size() - 1);
  }
  public String getMatchingGroupBy(Predicate<String> predicate) {
    for (String item: groupBy) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroupBy(Predicate<String> predicate) {
    for (String item: groupBy) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroupBy(List<String> groupBy) {
    if (groupBy != null) {this.groupBy = new ArrayList(); for (String item : groupBy){this.addToGroupBy(item);}} else { this.groupBy = null;} return (A) this;
  }
  public A withGroupBy(java.lang.String... groupBy) {
    if (this.groupBy != null) {this.groupBy.clear(); _visitables.remove("groupBy"); }
    if (groupBy != null) {for (String item :groupBy){ this.addToGroupBy(item);}} return (A) this;
  }
  public Boolean hasGroupBy() {
    return groupBy != null && !groupBy.isEmpty();
  }
  public String getGroupInterval() {
    return this.groupInterval;
  }
  public A withGroupInterval(String groupInterval) {
    this.groupInterval=groupInterval; return (A) this;
  }
  public Boolean hasGroupInterval() {
    return this.groupInterval != null;
  }
  public String getGroupWait() {
    return this.groupWait;
  }
  public A withGroupWait(String groupWait) {
    this.groupWait=groupWait; return (A) this;
  }
  public Boolean hasGroupWait() {
    return this.groupWait != null;
  }
  public A addToMatchers(int index,Matcher item) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);
    if (index < 0 || index >= matchers.size()) { _visitables.get("matchers").add(builder); matchers.add(builder); } else { _visitables.get("matchers").add(index, builder); matchers.add(index, builder);}
    return (A)this;
  }
  public A setToMatchers(int index,Matcher item) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);
    if (index < 0 || index >= matchers.size()) { _visitables.get("matchers").add(builder); matchers.add(builder); } else { _visitables.get("matchers").set(index, builder); matchers.set(index, builder);}
    return (A)this;
  }
  public A addToMatchers(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... items) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").add(builder);this.matchers.add(builder);} return (A)this;
  }
  public A addAllToMatchers(Collection<Matcher> items) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").add(builder);this.matchers.add(builder);} return (A)this;
  }
  public A removeFromMatchers(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... items) {
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").remove(builder);if (this.matchers != null) {this.matchers.remove(builder);}} return (A)this;
  }
  public A removeAllFromMatchers(Collection<Matcher> items) {
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").remove(builder);if (this.matchers != null) {this.matchers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMatchers(Predicate<MatcherBuilder> predicate) {
    if (matchers == null) return (A) this;
    final Iterator<MatcherBuilder> each = matchers.iterator();
    final List visitables = _visitables.get("matchers");
    while (each.hasNext()) {
      MatcherBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMatchers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Matcher> getMatchers() {
    return matchers != null ? build(matchers) : null;
  }
  public List<Matcher> buildMatchers() {
    return matchers != null ? build(matchers) : null;
  }
  public Matcher buildMatcher(int index) {
    return this.matchers.get(index).build();
  }
  public Matcher buildFirstMatcher() {
    return this.matchers.get(0).build();
  }
  public Matcher buildLastMatcher() {
    return this.matchers.get(matchers.size() - 1).build();
  }
  public Matcher buildMatchingMatcher(Predicate<MatcherBuilder> predicate) {
    for (MatcherBuilder item: matchers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMatcher(Predicate<MatcherBuilder> predicate) {
    for (MatcherBuilder item: matchers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatchers(List<Matcher> matchers) {
    if (this.matchers != null) { _visitables.get("matchers").clear();}
    if (matchers != null) {this.matchers = new ArrayList(); for (Matcher item : matchers){this.addToMatchers(item);}} else { this.matchers = null;} return (A) this;
  }
  public A withMatchers(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... matchers) {
    if (this.matchers != null) {this.matchers.clear(); _visitables.remove("matchers"); }
    if (matchers != null) {for (Matcher item :matchers){ this.addToMatchers(item);}} return (A) this;
  }
  public Boolean hasMatchers() {
    return matchers != null && !matchers.isEmpty();
  }
  public A addNewMatcher(String name,Boolean regex,String value) {
    return (A)addToMatchers(new Matcher(name, regex, value));
  }
  public RouteFluentImpl.MatchersNested<A> addNewMatcher() {
    return new RouteFluentImpl.MatchersNestedImpl();
  }
  public RouteFluentImpl.MatchersNested<A> addNewMatcherLike(Matcher item) {
    return new RouteFluentImpl.MatchersNestedImpl(-1, item);
  }
  public RouteFluentImpl.MatchersNested<A> setNewMatcherLike(int index,Matcher item) {
    return new RouteFluentImpl.MatchersNestedImpl(index, item);
  }
  public RouteFluentImpl.MatchersNested<A> editMatcher(int index) {
    if (matchers.size() <= index) throw new RuntimeException("Can't edit matchers. Index exceeds size.");
    return setNewMatcherLike(index, buildMatcher(index));
  }
  public RouteFluentImpl.MatchersNested<A> editFirstMatcher() {
    if (matchers.size() == 0) throw new RuntimeException("Can't edit first matchers. The list is empty.");
    return setNewMatcherLike(0, buildMatcher(0));
  }
  public RouteFluentImpl.MatchersNested<A> editLastMatcher() {
    int index = matchers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchers. The list is empty.");
    return setNewMatcherLike(index, buildMatcher(index));
  }
  public RouteFluentImpl.MatchersNested<A> editMatchingMatcher(Predicate<MatcherBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchers.size();i++) { 
    if (predicate.test(matchers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchers. No match found.");
    return setNewMatcherLike(index, buildMatcher(index));
  }
  public String getReceiver() {
    return this.receiver;
  }
  public A withReceiver(String receiver) {
    this.receiver=receiver; return (A) this;
  }
  public Boolean hasReceiver() {
    return this.receiver != null;
  }
  public String getRepeatInterval() {
    return this.repeatInterval;
  }
  public A withRepeatInterval(String repeatInterval) {
    this.repeatInterval=repeatInterval; return (A) this;
  }
  public Boolean hasRepeatInterval() {
    return this.repeatInterval != null;
  }
  public A addToRoutes(int index,JsonNode item) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    this.routes.add(index, item);
    return (A)this;
  }
  public A setToRoutes(int index,JsonNode item) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    this.routes.set(index, item); return (A)this;
  }
  public A addToRoutes(com.fasterxml.jackson.databind.JsonNode... items) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this.routes.add(item);} return (A)this;
  }
  public A addAllToRoutes(Collection<JsonNode> items) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this.routes.add(item);} return (A)this;
  }
  public A removeFromRoutes(com.fasterxml.jackson.databind.JsonNode... items) {
    for (JsonNode item : items) {if (this.routes!= null){ this.routes.remove(item);}} return (A)this;
  }
  public A removeAllFromRoutes(Collection<JsonNode> items) {
    for (JsonNode item : items) {if (this.routes!= null){ this.routes.remove(item);}} return (A)this;
  }
  public List<JsonNode> getRoutes() {
    return this.routes;
  }
  public JsonNode getRoute(int index) {
    return this.routes.get(index);
  }
  public JsonNode getFirstRoute() {
    return this.routes.get(0);
  }
  public JsonNode getLastRoute() {
    return this.routes.get(routes.size() - 1);
  }
  public JsonNode getMatchingRoute(Predicate<JsonNode> predicate) {
    for (JsonNode item: routes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRoute(Predicate<JsonNode> predicate) {
    for (JsonNode item: routes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoutes(List<JsonNode> routes) {
    if (routes != null) {this.routes = new ArrayList(); for (JsonNode item : routes){this.addToRoutes(item);}} else { this.routes = null;} return (A) this;
  }
  public A withRoutes(com.fasterxml.jackson.databind.JsonNode... routes) {
    if (this.routes != null) {this.routes.clear(); _visitables.remove("routes"); }
    if (routes != null) {for (JsonNode item :routes){ this.addToRoutes(item);}} return (A) this;
  }
  public Boolean hasRoutes() {
    return routes != null && !routes.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RouteFluentImpl that = (RouteFluentImpl) o;
    if (!java.util.Objects.equals(_continue, that._continue)) return false;

    if (!java.util.Objects.equals(groupBy, that.groupBy)) return false;

    if (!java.util.Objects.equals(groupInterval, that.groupInterval)) return false;

    if (!java.util.Objects.equals(groupWait, that.groupWait)) return false;

    if (!java.util.Objects.equals(matchers, that.matchers)) return false;

    if (!java.util.Objects.equals(receiver, that.receiver)) return false;

    if (!java.util.Objects.equals(repeatInterval, that.repeatInterval)) return false;

    if (!java.util.Objects.equals(routes, that.routes)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(_continue,  groupBy,  groupInterval,  groupWait,  matchers,  receiver,  repeatInterval,  routes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (_continue != null) { sb.append("_continue:"); sb.append(_continue + ","); }
    if (groupBy != null && !groupBy.isEmpty()) { sb.append("groupBy:"); sb.append(groupBy + ","); }
    if (groupInterval != null) { sb.append("groupInterval:"); sb.append(groupInterval + ","); }
    if (groupWait != null) { sb.append("groupWait:"); sb.append(groupWait + ","); }
    if (matchers != null && !matchers.isEmpty()) { sb.append("matchers:"); sb.append(matchers + ","); }
    if (receiver != null) { sb.append("receiver:"); sb.append(receiver + ","); }
    if (repeatInterval != null) { sb.append("repeatInterval:"); sb.append(repeatInterval + ","); }
    if (routes != null && !routes.isEmpty()) { sb.append("routes:"); sb.append(routes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withContinue() {
    return withContinue(true);
  }
  class MatchersNestedImpl<N> extends MatcherFluentImpl<RouteFluentImpl.MatchersNested<N>> implements RouteFluentImpl.MatchersNested<N>,Nested<N>{
    MatchersNestedImpl(int index,Matcher item) {
      this.index = index;
      this.builder = new MatcherBuilder(this, item);
    }
    MatchersNestedImpl() {
      this.index = -1;
      this.builder = new MatcherBuilder(this);
    }
    MatcherBuilder builder;
    int index;
    public N and() {
      return (N) RouteFluentImpl.this.setToMatchers(index,builder.build());
    }
    public N endMatcher() {
      return and();
    }
    
  }
  
}