package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpsGenieConfigBuilder extends OpsGenieConfigFluentImpl<OpsGenieConfigBuilder> implements VisitableBuilder<OpsGenieConfig,OpsGenieConfigBuilder>{
  public OpsGenieConfigBuilder() {
    this(false);
  }
  public OpsGenieConfigBuilder(Boolean validationEnabled) {
    this(new OpsGenieConfig(), validationEnabled);
  }
  public OpsGenieConfigBuilder(OpsGenieConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public OpsGenieConfigBuilder(OpsGenieConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpsGenieConfig(), validationEnabled);
  }
  public OpsGenieConfigBuilder(OpsGenieConfigFluent<?> fluent,OpsGenieConfig instance) {
    this(fluent, instance, false);
  }
  public OpsGenieConfigBuilder(OpsGenieConfigFluent<?> fluent,OpsGenieConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiKey(instance.getApiKey());
      fluent.withApiURL(instance.getApiURL());
      fluent.withDescription(instance.getDescription());
      fluent.withDetails(instance.getDetails());
      fluent.withHttpConfig(instance.getHttpConfig());
      fluent.withMessage(instance.getMessage());
      fluent.withNote(instance.getNote());
      fluent.withPriority(instance.getPriority());
      fluent.withResponders(instance.getResponders());
      fluent.withSendResolved(instance.getSendResolved());
      fluent.withSource(instance.getSource());
      fluent.withTags(instance.getTags());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpsGenieConfigBuilder(OpsGenieConfig instance) {
    this(instance,false);
  }
  public OpsGenieConfigBuilder(OpsGenieConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiKey(instance.getApiKey());
      this.withApiURL(instance.getApiURL());
      this.withDescription(instance.getDescription());
      this.withDetails(instance.getDetails());
      this.withHttpConfig(instance.getHttpConfig());
      this.withMessage(instance.getMessage());
      this.withNote(instance.getNote());
      this.withPriority(instance.getPriority());
      this.withResponders(instance.getResponders());
      this.withSendResolved(instance.getSendResolved());
      this.withSource(instance.getSource());
      this.withTags(instance.getTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpsGenieConfigFluent<?> fluent;
  Boolean validationEnabled;
  public OpsGenieConfig build() {
    OpsGenieConfig buildable = new OpsGenieConfig(fluent.getApiKey(),fluent.getApiURL(),fluent.getDescription(),fluent.getDetails(),fluent.getHttpConfig(),fluent.getMessage(),fluent.getNote(),fluent.getPriority(),fluent.getResponders(),fluent.getSendResolved(),fluent.getSource(),fluent.getTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}