package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EmailConfigBuilder extends EmailConfigFluentImpl<EmailConfigBuilder> implements VisitableBuilder<EmailConfig,EmailConfigBuilder>{
  public EmailConfigBuilder() {
    this(false);
  }
  public EmailConfigBuilder(Boolean validationEnabled) {
    this(new EmailConfig(), validationEnabled);
  }
  public EmailConfigBuilder(EmailConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public EmailConfigBuilder(EmailConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EmailConfig(), validationEnabled);
  }
  public EmailConfigBuilder(EmailConfigFluent<?> fluent,EmailConfig instance) {
    this(fluent, instance, false);
  }
  public EmailConfigBuilder(EmailConfigFluent<?> fluent,EmailConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAuthIdentity(instance.getAuthIdentity());
      fluent.withAuthPassword(instance.getAuthPassword());
      fluent.withAuthSecret(instance.getAuthSecret());
      fluent.withAuthUsername(instance.getAuthUsername());
      fluent.withFrom(instance.getFrom());
      fluent.withHeaders(instance.getHeaders());
      fluent.withHello(instance.getHello());
      fluent.withHtml(instance.getHtml());
      fluent.withRequireTLS(instance.getRequireTLS());
      fluent.withSendResolved(instance.getSendResolved());
      fluent.withSmarthost(instance.getSmarthost());
      fluent.withText(instance.getText());
      fluent.withTlsConfig(instance.getTlsConfig());
      fluent.withTo(instance.getTo());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EmailConfigBuilder(EmailConfig instance) {
    this(instance,false);
  }
  public EmailConfigBuilder(EmailConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAuthIdentity(instance.getAuthIdentity());
      this.withAuthPassword(instance.getAuthPassword());
      this.withAuthSecret(instance.getAuthSecret());
      this.withAuthUsername(instance.getAuthUsername());
      this.withFrom(instance.getFrom());
      this.withHeaders(instance.getHeaders());
      this.withHello(instance.getHello());
      this.withHtml(instance.getHtml());
      this.withRequireTLS(instance.getRequireTLS());
      this.withSendResolved(instance.getSendResolved());
      this.withSmarthost(instance.getSmarthost());
      this.withText(instance.getText());
      this.withTlsConfig(instance.getTlsConfig());
      this.withTo(instance.getTo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EmailConfigFluent<?> fluent;
  Boolean validationEnabled;
  public EmailConfig build() {
    EmailConfig buildable = new EmailConfig(fluent.getAuthIdentity(),fluent.getAuthPassword(),fluent.getAuthSecret(),fluent.getAuthUsername(),fluent.getFrom(),fluent.getHeaders(),fluent.getHello(),fluent.getHtml(),fluent.getRequireTLS(),fluent.getSendResolved(),fluent.getSmarthost(),fluent.getText(),fluent.getTlsConfig(),fluent.getTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}