package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlertmanagerConfigListBuilder extends AlertmanagerConfigListFluentImpl<AlertmanagerConfigListBuilder> implements VisitableBuilder<AlertmanagerConfigList,AlertmanagerConfigListBuilder>{
  public AlertmanagerConfigListBuilder() {
    this(false);
  }
  public AlertmanagerConfigListBuilder(Boolean validationEnabled) {
    this(new AlertmanagerConfigList(), validationEnabled);
  }
  public AlertmanagerConfigListBuilder(AlertmanagerConfigListFluent<?> fluent) {
    this(fluent, false);
  }
  public AlertmanagerConfigListBuilder(AlertmanagerConfigListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AlertmanagerConfigList(), validationEnabled);
  }
  public AlertmanagerConfigListBuilder(AlertmanagerConfigListFluent<?> fluent,AlertmanagerConfigList instance) {
    this(fluent, instance, false);
  }
  public AlertmanagerConfigListBuilder(AlertmanagerConfigListFluent<?> fluent,AlertmanagerConfigList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AlertmanagerConfigListBuilder(AlertmanagerConfigList instance) {
    this(instance,false);
  }
  public AlertmanagerConfigListBuilder(AlertmanagerConfigList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AlertmanagerConfigListFluent<?> fluent;
  Boolean validationEnabled;
  public AlertmanagerConfigList build() {
    AlertmanagerConfigList buildable = new AlertmanagerConfigList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}