package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlertmanagerConfigBuilder extends AlertmanagerConfigFluentImpl<AlertmanagerConfigBuilder> implements VisitableBuilder<AlertmanagerConfig,AlertmanagerConfigBuilder>{
  public AlertmanagerConfigBuilder() {
    this(false);
  }
  public AlertmanagerConfigBuilder(Boolean validationEnabled) {
    this(new AlertmanagerConfig(), validationEnabled);
  }
  public AlertmanagerConfigBuilder(AlertmanagerConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public AlertmanagerConfigBuilder(AlertmanagerConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AlertmanagerConfig(), validationEnabled);
  }
  public AlertmanagerConfigBuilder(AlertmanagerConfigFluent<?> fluent,AlertmanagerConfig instance) {
    this(fluent, instance, false);
  }
  public AlertmanagerConfigBuilder(AlertmanagerConfigFluent<?> fluent,AlertmanagerConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AlertmanagerConfigBuilder(AlertmanagerConfig instance) {
    this(instance,false);
  }
  public AlertmanagerConfigBuilder(AlertmanagerConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AlertmanagerConfigFluent<?> fluent;
  Boolean validationEnabled;
  public AlertmanagerConfig build() {
    AlertmanagerConfig buildable = new AlertmanagerConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}