package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceMonitorSpecFluent<A extends ServiceMonitorSpecFluent<A>> extends Fluent<A>{
  public A addToEndpoints(int index,Endpoint item);
  public A setToEndpoints(int index,Endpoint item);
  public A addToEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... items);
  public A addAllToEndpoints(Collection<Endpoint> items);
  public A removeFromEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... items);
  public A removeAllFromEndpoints(Collection<Endpoint> items);
  public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Endpoint> getEndpoints();
  public List<Endpoint> buildEndpoints();
  public Endpoint buildEndpoint(int index);
  public Endpoint buildFirstEndpoint();
  public Endpoint buildLastEndpoint();
  public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate);
  public Boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate);
  public A withEndpoints(List<Endpoint> endpoints);
  public A withEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... endpoints);
  public Boolean hasEndpoints();
  public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpoint();
  public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item);
  public ServiceMonitorSpecFluent.EndpointsNested<A> setNewEndpointLike(int index,Endpoint item);
  public ServiceMonitorSpecFluent.EndpointsNested<A> editEndpoint(int index);
  public ServiceMonitorSpecFluent.EndpointsNested<A> editFirstEndpoint();
  public ServiceMonitorSpecFluent.EndpointsNested<A> editLastEndpoint();
  public ServiceMonitorSpecFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate);
  public String getJobLabel();
  public A withJobLabel(String jobLabel);
  public Boolean hasJobLabel();
  public Long getLabelLimit();
  public A withLabelLimit(Long labelLimit);
  public Boolean hasLabelLimit();
  public Long getLabelNameLengthLimit();
  public A withLabelNameLengthLimit(Long labelNameLengthLimit);
  public Boolean hasLabelNameLengthLimit();
  public Long getLabelValueLengthLimit();
  public A withLabelValueLengthLimit(Long labelValueLengthLimit);
  public Boolean hasLabelValueLengthLimit();
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamespaceSelector getNamespaceSelector();
  public NamespaceSelector buildNamespaceSelector();
  public A withNamespaceSelector(NamespaceSelector namespaceSelector);
  public Boolean hasNamespaceSelector();
  public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector();
  public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item);
  public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector();
  public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector();
  public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item);
  public A addToPodTargetLabels(int index,String item);
  public A setToPodTargetLabels(int index,String item);
  public A addToPodTargetLabels(java.lang.String... items);
  public A addAllToPodTargetLabels(Collection<String> items);
  public A removeFromPodTargetLabels(java.lang.String... items);
  public A removeAllFromPodTargetLabels(Collection<String> items);
  public List<String> getPodTargetLabels();
  public String getPodTargetLabel(int index);
  public String getFirstPodTargetLabel();
  public String getLastPodTargetLabel();
  public String getMatchingPodTargetLabel(Predicate<String> predicate);
  public Boolean hasMatchingPodTargetLabel(Predicate<String> predicate);
  public A withPodTargetLabels(List<String> podTargetLabels);
  public A withPodTargetLabels(java.lang.String... podTargetLabels);
  public Boolean hasPodTargetLabels();
  public Long getSampleLimit();
  public A withSampleLimit(Long sampleLimit);
  public Boolean hasSampleLimit();
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector();
  public LabelSelector buildSelector();
  public A withSelector(LabelSelector selector);
  public Boolean hasSelector();
  public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelector();
  public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
  public ServiceMonitorSpecFluent.SelectorNested<A> editSelector();
  public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelector();
  public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
  public A addToTargetLabels(int index,String item);
  public A setToTargetLabels(int index,String item);
  public A addToTargetLabels(java.lang.String... items);
  public A addAllToTargetLabels(Collection<String> items);
  public A removeFromTargetLabels(java.lang.String... items);
  public A removeAllFromTargetLabels(Collection<String> items);
  public List<String> getTargetLabels();
  public String getTargetLabel(int index);
  public String getFirstTargetLabel();
  public String getLastTargetLabel();
  public String getMatchingTargetLabel(Predicate<String> predicate);
  public Boolean hasMatchingTargetLabel(Predicate<String> predicate);
  public A withTargetLabels(List<String> targetLabels);
  public A withTargetLabels(java.lang.String... targetLabels);
  public Boolean hasTargetLabels();
  public Long getTargetLimit();
  public A withTargetLimit(Long targetLimit);
  public Boolean hasTargetLimit();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface EndpointsNested<N> extends Nested<N>,EndpointFluent<ServiceMonitorSpecFluent.EndpointsNested<N>>{
    public N and();
    public N endEndpoint();
    
  }
  public interface NamespaceSelectorNested<N> extends Nested<N>,NamespaceSelectorFluent<ServiceMonitorSpecFluent.NamespaceSelectorNested<N>>{
    public N and();
    public N endNamespaceSelector();
    
  }
  public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<ServiceMonitorSpecFluent.SelectorNested<N>>{
    public N and();
    public N endSelector();
    
  }
  
}