package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodMonitorSpecFluentImpl<A extends PodMonitorSpecFluent<A>> extends BaseFluent<A> implements PodMonitorSpecFluent<A>{
  public PodMonitorSpecFluentImpl() {
  }
  public PodMonitorSpecFluentImpl(PodMonitorSpec instance) {
    if (instance != null) {
      this.withJobLabel(instance.getJobLabel());
      this.withLabelLimit(instance.getLabelLimit());
      this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
      this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withPodMetricsEndpoints(instance.getPodMetricsEndpoints());
      this.withPodTargetLabels(instance.getPodTargetLabels());
      this.withSampleLimit(instance.getSampleLimit());
      this.withSelector(instance.getSelector());
      this.withTargetLimit(instance.getTargetLimit());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String jobLabel;
  private Long labelLimit;
  private Long labelNameLengthLimit;
  private Long labelValueLengthLimit;
  private NamespaceSelectorBuilder namespaceSelector;
  private ArrayList<PodMetricsEndpointBuilder> podMetricsEndpoints = new ArrayList<PodMetricsEndpointBuilder>();
  private List<String> podTargetLabels = new ArrayList<String>();
  private Long sampleLimit;
  private LabelSelectorBuilder selector;
  private Long targetLimit;
  private Map<String,Object> additionalProperties;
  public String getJobLabel() {
    return this.jobLabel;
  }
  public A withJobLabel(String jobLabel) {
    this.jobLabel=jobLabel; return (A) this;
  }
  public Boolean hasJobLabel() {
    return this.jobLabel != null;
  }
  public Long getLabelLimit() {
    return this.labelLimit;
  }
  public A withLabelLimit(Long labelLimit) {
    this.labelLimit=labelLimit; return (A) this;
  }
  public Boolean hasLabelLimit() {
    return this.labelLimit != null;
  }
  public Long getLabelNameLengthLimit() {
    return this.labelNameLengthLimit;
  }
  public A withLabelNameLengthLimit(Long labelNameLengthLimit) {
    this.labelNameLengthLimit=labelNameLengthLimit; return (A) this;
  }
  public Boolean hasLabelNameLengthLimit() {
    return this.labelNameLengthLimit != null;
  }
  public Long getLabelValueLengthLimit() {
    return this.labelValueLengthLimit;
  }
  public A withLabelValueLengthLimit(Long labelValueLengthLimit) {
    this.labelValueLengthLimit=labelValueLengthLimit; return (A) this;
  }
  public Boolean hasLabelValueLengthLimit() {
    return this.labelValueLengthLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamespaceSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public NamespaceSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new NamespaceSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public PodMonitorSpecFluentImpl.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new PodMonitorSpecFluentImpl.NamespaceSelectorNestedImpl();
  }
  public PodMonitorSpecFluentImpl.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
    return new PodMonitorSpecFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public PodMonitorSpecFluentImpl.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public PodMonitorSpecFluentImpl.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new NamespaceSelectorBuilder().build());
  }
  public PodMonitorSpecFluentImpl.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  public A addToPodMetricsEndpoints(int index,PodMetricsEndpoint item) {
    if (this.podMetricsEndpoints == null) {this.podMetricsEndpoints = new ArrayList<PodMetricsEndpointBuilder>();}
    PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
    if (index < 0 || index >= podMetricsEndpoints.size()) { _visitables.get("podMetricsEndpoints").add(builder); podMetricsEndpoints.add(builder); } else { _visitables.get("podMetricsEndpoints").add(index, builder); podMetricsEndpoints.add(index, builder);}
    return (A)this;
  }
  public A setToPodMetricsEndpoints(int index,PodMetricsEndpoint item) {
    if (this.podMetricsEndpoints == null) {this.podMetricsEndpoints = new ArrayList<PodMetricsEndpointBuilder>();}
    PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
    if (index < 0 || index >= podMetricsEndpoints.size()) { _visitables.get("podMetricsEndpoints").add(builder); podMetricsEndpoints.add(builder); } else { _visitables.get("podMetricsEndpoints").set(index, builder); podMetricsEndpoints.set(index, builder);}
    return (A)this;
  }
  public A addToPodMetricsEndpoints(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint... items) {
    if (this.podMetricsEndpoints == null) {this.podMetricsEndpoints = new ArrayList<PodMetricsEndpointBuilder>();}
    for (PodMetricsEndpoint item : items) {PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);_visitables.get("podMetricsEndpoints").add(builder);this.podMetricsEndpoints.add(builder);} return (A)this;
  }
  public A addAllToPodMetricsEndpoints(Collection<PodMetricsEndpoint> items) {
    if (this.podMetricsEndpoints == null) {this.podMetricsEndpoints = new ArrayList<PodMetricsEndpointBuilder>();}
    for (PodMetricsEndpoint item : items) {PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);_visitables.get("podMetricsEndpoints").add(builder);this.podMetricsEndpoints.add(builder);} return (A)this;
  }
  public A removeFromPodMetricsEndpoints(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint... items) {
    for (PodMetricsEndpoint item : items) {PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);_visitables.get("podMetricsEndpoints").remove(builder);if (this.podMetricsEndpoints != null) {this.podMetricsEndpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromPodMetricsEndpoints(Collection<PodMetricsEndpoint> items) {
    for (PodMetricsEndpoint item : items) {PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);_visitables.get("podMetricsEndpoints").remove(builder);if (this.podMetricsEndpoints != null) {this.podMetricsEndpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPodMetricsEndpoints(Predicate<PodMetricsEndpointBuilder> predicate) {
    if (podMetricsEndpoints == null) return (A) this;
    final Iterator<PodMetricsEndpointBuilder> each = podMetricsEndpoints.iterator();
    final List visitables = _visitables.get("podMetricsEndpoints");
    while (each.hasNext()) {
      PodMetricsEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPodMetricsEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodMetricsEndpoint> getPodMetricsEndpoints() {
    return podMetricsEndpoints != null ? build(podMetricsEndpoints) : null;
  }
  public List<PodMetricsEndpoint> buildPodMetricsEndpoints() {
    return podMetricsEndpoints != null ? build(podMetricsEndpoints) : null;
  }
  public PodMetricsEndpoint buildPodMetricsEndpoint(int index) {
    return this.podMetricsEndpoints.get(index).build();
  }
  public PodMetricsEndpoint buildFirstPodMetricsEndpoint() {
    return this.podMetricsEndpoints.get(0).build();
  }
  public PodMetricsEndpoint buildLastPodMetricsEndpoint() {
    return this.podMetricsEndpoints.get(podMetricsEndpoints.size() - 1).build();
  }
  public PodMetricsEndpoint buildMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
    for (PodMetricsEndpointBuilder item: podMetricsEndpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
    for (PodMetricsEndpointBuilder item: podMetricsEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPodMetricsEndpoints(List<PodMetricsEndpoint> podMetricsEndpoints) {
    if (this.podMetricsEndpoints != null) { _visitables.get("podMetricsEndpoints").clear();}
    if (podMetricsEndpoints != null) {this.podMetricsEndpoints = new ArrayList(); for (PodMetricsEndpoint item : podMetricsEndpoints){this.addToPodMetricsEndpoints(item);}} else { this.podMetricsEndpoints = null;} return (A) this;
  }
  public A withPodMetricsEndpoints(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint... podMetricsEndpoints) {
    if (this.podMetricsEndpoints != null) {this.podMetricsEndpoints.clear(); _visitables.remove("podMetricsEndpoints"); }
    if (podMetricsEndpoints != null) {for (PodMetricsEndpoint item :podMetricsEndpoints){ this.addToPodMetricsEndpoints(item);}} return (A) this;
  }
  public Boolean hasPodMetricsEndpoints() {
    return podMetricsEndpoints != null && !podMetricsEndpoints.isEmpty();
  }
  public PodMonitorSpecFluentImpl.PodMetricsEndpointsNested<A> addNewPodMetricsEndpoint() {
    return new PodMonitorSpecFluentImpl.PodMetricsEndpointsNestedImpl();
  }
  public PodMonitorSpecFluentImpl.PodMetricsEndpointsNested<A> addNewPodMetricsEndpointLike(PodMetricsEndpoint item) {
    return new PodMonitorSpecFluentImpl.PodMetricsEndpointsNestedImpl(-1, item);
  }
  public PodMonitorSpecFluentImpl.PodMetricsEndpointsNested<A> setNewPodMetricsEndpointLike(int index,PodMetricsEndpoint item) {
    return new PodMonitorSpecFluentImpl.PodMetricsEndpointsNestedImpl(index, item);
  }
  public PodMonitorSpecFluentImpl.PodMetricsEndpointsNested<A> editPodMetricsEndpoint(int index) {
    if (podMetricsEndpoints.size() <= index) throw new RuntimeException("Can't edit podMetricsEndpoints. Index exceeds size.");
    return setNewPodMetricsEndpointLike(index, buildPodMetricsEndpoint(index));
  }
  public PodMonitorSpecFluentImpl.PodMetricsEndpointsNested<A> editFirstPodMetricsEndpoint() {
    if (podMetricsEndpoints.size() == 0) throw new RuntimeException("Can't edit first podMetricsEndpoints. The list is empty.");
    return setNewPodMetricsEndpointLike(0, buildPodMetricsEndpoint(0));
  }
  public PodMonitorSpecFluentImpl.PodMetricsEndpointsNested<A> editLastPodMetricsEndpoint() {
    int index = podMetricsEndpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last podMetricsEndpoints. The list is empty.");
    return setNewPodMetricsEndpointLike(index, buildPodMetricsEndpoint(index));
  }
  public PodMonitorSpecFluentImpl.PodMetricsEndpointsNested<A> editMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<podMetricsEndpoints.size();i++) { 
    if (predicate.test(podMetricsEndpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching podMetricsEndpoints. No match found.");
    return setNewPodMetricsEndpointLike(index, buildPodMetricsEndpoint(index));
  }
  public A addToPodTargetLabels(int index,String item) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    this.podTargetLabels.add(index, item);
    return (A)this;
  }
  public A setToPodTargetLabels(int index,String item) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    this.podTargetLabels.set(index, item); return (A)this;
  }
  public A addToPodTargetLabels(java.lang.String... items) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    for (String item : items) {this.podTargetLabels.add(item);} return (A)this;
  }
  public A addAllToPodTargetLabels(Collection<String> items) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    for (String item : items) {this.podTargetLabels.add(item);} return (A)this;
  }
  public A removeFromPodTargetLabels(java.lang.String... items) {
    for (String item : items) {if (this.podTargetLabels!= null){ this.podTargetLabels.remove(item);}} return (A)this;
  }
  public A removeAllFromPodTargetLabels(Collection<String> items) {
    for (String item : items) {if (this.podTargetLabels!= null){ this.podTargetLabels.remove(item);}} return (A)this;
  }
  public List<String> getPodTargetLabels() {
    return this.podTargetLabels;
  }
  public String getPodTargetLabel(int index) {
    return this.podTargetLabels.get(index);
  }
  public String getFirstPodTargetLabel() {
    return this.podTargetLabels.get(0);
  }
  public String getLastPodTargetLabel() {
    return this.podTargetLabels.get(podTargetLabels.size() - 1);
  }
  public String getMatchingPodTargetLabel(Predicate<String> predicate) {
    for (String item: podTargetLabels) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPodTargetLabel(Predicate<String> predicate) {
    for (String item: podTargetLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPodTargetLabels(List<String> podTargetLabels) {
    if (podTargetLabels != null) {this.podTargetLabels = new ArrayList(); for (String item : podTargetLabels){this.addToPodTargetLabels(item);}} else { this.podTargetLabels = null;} return (A) this;
  }
  public A withPodTargetLabels(java.lang.String... podTargetLabels) {
    if (this.podTargetLabels != null) {this.podTargetLabels.clear(); _visitables.remove("podTargetLabels"); }
    if (podTargetLabels != null) {for (String item :podTargetLabels){ this.addToPodTargetLabels(item);}} return (A) this;
  }
  public Boolean hasPodTargetLabels() {
    return podTargetLabels != null && !podTargetLabels.isEmpty();
  }
  public Long getSampleLimit() {
    return this.sampleLimit;
  }
  public A withSampleLimit(Long sampleLimit) {
    this.sampleLimit=sampleLimit; return (A) this;
  }
  public Boolean hasSampleLimit() {
    return this.sampleLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public PodMonitorSpecFluentImpl.SelectorNested<A> withNewSelector() {
    return new PodMonitorSpecFluentImpl.SelectorNestedImpl();
  }
  public PodMonitorSpecFluentImpl.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new PodMonitorSpecFluentImpl.SelectorNestedImpl(item);
  }
  public PodMonitorSpecFluentImpl.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public PodMonitorSpecFluentImpl.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public PodMonitorSpecFluentImpl.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public Long getTargetLimit() {
    return this.targetLimit;
  }
  public A withTargetLimit(Long targetLimit) {
    this.targetLimit=targetLimit; return (A) this;
  }
  public Boolean hasTargetLimit() {
    return this.targetLimit != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodMonitorSpecFluentImpl that = (PodMonitorSpecFluentImpl) o;
    if (!java.util.Objects.equals(jobLabel, that.jobLabel)) return false;

    if (!java.util.Objects.equals(labelLimit, that.labelLimit)) return false;

    if (!java.util.Objects.equals(labelNameLengthLimit, that.labelNameLengthLimit)) return false;

    if (!java.util.Objects.equals(labelValueLengthLimit, that.labelValueLengthLimit)) return false;

    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;

    if (!java.util.Objects.equals(podMetricsEndpoints, that.podMetricsEndpoints)) return false;

    if (!java.util.Objects.equals(podTargetLabels, that.podTargetLabels)) return false;

    if (!java.util.Objects.equals(sampleLimit, that.sampleLimit)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(targetLimit, that.targetLimit)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(jobLabel,  labelLimit,  labelNameLengthLimit,  labelValueLengthLimit,  namespaceSelector,  podMetricsEndpoints,  podTargetLabels,  sampleLimit,  selector,  targetLimit,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (jobLabel != null) { sb.append("jobLabel:"); sb.append(jobLabel + ","); }
    if (labelLimit != null) { sb.append("labelLimit:"); sb.append(labelLimit + ","); }
    if (labelNameLengthLimit != null) { sb.append("labelNameLengthLimit:"); sb.append(labelNameLengthLimit + ","); }
    if (labelValueLengthLimit != null) { sb.append("labelValueLengthLimit:"); sb.append(labelValueLengthLimit + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (podMetricsEndpoints != null && !podMetricsEndpoints.isEmpty()) { sb.append("podMetricsEndpoints:"); sb.append(podMetricsEndpoints + ","); }
    if (podTargetLabels != null && !podTargetLabels.isEmpty()) { sb.append("podTargetLabels:"); sb.append(podTargetLabels + ","); }
    if (sampleLimit != null) { sb.append("sampleLimit:"); sb.append(sampleLimit + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (targetLimit != null) { sb.append("targetLimit:"); sb.append(targetLimit + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class NamespaceSelectorNestedImpl<N> extends NamespaceSelectorFluentImpl<PodMonitorSpecFluentImpl.NamespaceSelectorNested<N>> implements PodMonitorSpecFluentImpl.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(NamespaceSelector item) {
      this.builder = new NamespaceSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new NamespaceSelectorBuilder(this);
    }
    NamespaceSelectorBuilder builder;
    public N and() {
      return (N) PodMonitorSpecFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class PodMetricsEndpointsNestedImpl<N> extends PodMetricsEndpointFluentImpl<PodMonitorSpecFluentImpl.PodMetricsEndpointsNested<N>> implements PodMonitorSpecFluentImpl.PodMetricsEndpointsNested<N>,Nested<N>{
    PodMetricsEndpointsNestedImpl(int index,PodMetricsEndpoint item) {
      this.index = index;
      this.builder = new PodMetricsEndpointBuilder(this, item);
    }
    PodMetricsEndpointsNestedImpl() {
      this.index = -1;
      this.builder = new PodMetricsEndpointBuilder(this);
    }
    PodMetricsEndpointBuilder builder;
    int index;
    public N and() {
      return (N) PodMonitorSpecFluentImpl.this.setToPodMetricsEndpoints(index,builder.build());
    }
    public N endPodMetricsEndpoint() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<PodMonitorSpecFluentImpl.SelectorNested<N>> implements PodMonitorSpecFluentImpl.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PodMonitorSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}