package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlertmanagerEndpointsBuilder extends AlertmanagerEndpointsFluentImpl<AlertmanagerEndpointsBuilder> implements VisitableBuilder<AlertmanagerEndpoints,AlertmanagerEndpointsBuilder>{
  public AlertmanagerEndpointsBuilder() {
    this(false);
  }
  public AlertmanagerEndpointsBuilder(Boolean validationEnabled) {
    this(new AlertmanagerEndpoints(), validationEnabled);
  }
  public AlertmanagerEndpointsBuilder(AlertmanagerEndpointsFluent<?> fluent) {
    this(fluent, false);
  }
  public AlertmanagerEndpointsBuilder(AlertmanagerEndpointsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AlertmanagerEndpoints(), validationEnabled);
  }
  public AlertmanagerEndpointsBuilder(AlertmanagerEndpointsFluent<?> fluent,AlertmanagerEndpoints instance) {
    this(fluent, instance, false);
  }
  public AlertmanagerEndpointsBuilder(AlertmanagerEndpointsFluent<?> fluent,AlertmanagerEndpoints instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withAuthorization(instance.getAuthorization());
      fluent.withBearerTokenFile(instance.getBearerTokenFile());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPathPrefix(instance.getPathPrefix());
      fluent.withPort(instance.getPort());
      fluent.withScheme(instance.getScheme());
      fluent.withTimeout(instance.getTimeout());
      fluent.withTlsConfig(instance.getTlsConfig());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AlertmanagerEndpointsBuilder(AlertmanagerEndpoints instance) {
    this(instance,false);
  }
  public AlertmanagerEndpointsBuilder(AlertmanagerEndpoints instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withAuthorization(instance.getAuthorization());
      this.withBearerTokenFile(instance.getBearerTokenFile());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPathPrefix(instance.getPathPrefix());
      this.withPort(instance.getPort());
      this.withScheme(instance.getScheme());
      this.withTimeout(instance.getTimeout());
      this.withTlsConfig(instance.getTlsConfig());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AlertmanagerEndpointsFluent<?> fluent;
  Boolean validationEnabled;
  public AlertmanagerEndpoints build() {
    AlertmanagerEndpoints buildable = new AlertmanagerEndpoints(fluent.getApiVersion(),fluent.getAuthorization(),fluent.getBearerTokenFile(),fluent.getName(),fluent.getNamespace(),fluent.getPathPrefix(),fluent.getPort(),fluent.getScheme(),fluent.getTimeout(),fluent.getTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}