package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RelabelConfigFluentImpl<A extends RelabelConfigFluent<A>> extends BaseFluent<A> implements RelabelConfigFluent<A>{
  public RelabelConfigFluentImpl() {
  }
  public RelabelConfigFluentImpl(RelabelConfig instance) {
    this.withAction(instance.getAction()); 
    this.withModulus(instance.getModulus()); 
    this.withRegex(instance.getRegex()); 
    this.withReplacement(instance.getReplacement()); 
    this.withSeparator(instance.getSeparator()); 
    this.withSourceLabels(instance.getSourceLabels()); 
    this.withTargetLabel(instance.getTargetLabel()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String action;
  private Long modulus;
  private String regex;
  private String replacement;
  private String separator;
  private List<String> sourceLabels = new ArrayList<String>();
  private String targetLabel;
  private Map<String,Object> additionalProperties;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public Long getModulus() {
    return this.modulus;
  }
  public A withModulus(Long modulus) {
    this.modulus=modulus; return (A) this;
  }
  public Boolean hasModulus() {
    return this.modulus != null;
  }
  public String getRegex() {
    return this.regex;
  }
  public A withRegex(String regex) {
    this.regex=regex; return (A) this;
  }
  public Boolean hasRegex() {
    return this.regex != null;
  }
  public String getReplacement() {
    return this.replacement;
  }
  public A withReplacement(String replacement) {
    this.replacement=replacement; return (A) this;
  }
  public Boolean hasReplacement() {
    return this.replacement != null;
  }
  public String getSeparator() {
    return this.separator;
  }
  public A withSeparator(String separator) {
    this.separator=separator; return (A) this;
  }
  public Boolean hasSeparator() {
    return this.separator != null;
  }
  public A addToSourceLabels(Integer index,String item) {
    if (this.sourceLabels == null) {this.sourceLabels = new ArrayList<String>();}
    this.sourceLabels.add(index, item);
    return (A)this;
  }
  public A setToSourceLabels(Integer index,String item) {
    if (this.sourceLabels == null) {this.sourceLabels = new ArrayList<String>();}
    this.sourceLabels.set(index, item); return (A)this;
  }
  public A addToSourceLabels(java.lang.String... items) {
    if (this.sourceLabels == null) {this.sourceLabels = new ArrayList<String>();}
    for (String item : items) {this.sourceLabels.add(item);} return (A)this;
  }
  public A addAllToSourceLabels(Collection<String> items) {
    if (this.sourceLabels == null) {this.sourceLabels = new ArrayList<String>();}
    for (String item : items) {this.sourceLabels.add(item);} return (A)this;
  }
  public A removeFromSourceLabels(java.lang.String... items) {
    for (String item : items) {if (this.sourceLabels!= null){ this.sourceLabels.remove(item);}} return (A)this;
  }
  public A removeAllFromSourceLabels(Collection<String> items) {
    for (String item : items) {if (this.sourceLabels!= null){ this.sourceLabels.remove(item);}} return (A)this;
  }
  public List<String> getSourceLabels() {
    return this.sourceLabels;
  }
  public String getSourceLabel(Integer index) {
    return this.sourceLabels.get(index);
  }
  public String getFirstSourceLabel() {
    return this.sourceLabels.get(0);
  }
  public String getLastSourceLabel() {
    return this.sourceLabels.get(sourceLabels.size() - 1);
  }
  public String getMatchingSourceLabel(Predicate<String> predicate) {
    for (String item: sourceLabels) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSourceLabel(Predicate<String> predicate) {
    for (String item: sourceLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSourceLabels(List<String> sourceLabels) {
    if (sourceLabels != null) {this.sourceLabels = new ArrayList(); for (String item : sourceLabels){this.addToSourceLabels(item);}} else { this.sourceLabels = null;} return (A) this;
  }
  public A withSourceLabels(java.lang.String... sourceLabels) {
    if (this.sourceLabels != null) {this.sourceLabels.clear();}
    if (sourceLabels != null) {for (String item :sourceLabels){ this.addToSourceLabels(item);}} return (A) this;
  }
  public Boolean hasSourceLabels() {
    return sourceLabels != null && !sourceLabels.isEmpty();
  }
  public String getTargetLabel() {
    return this.targetLabel;
  }
  public A withTargetLabel(String targetLabel) {
    this.targetLabel=targetLabel; return (A) this;
  }
  public Boolean hasTargetLabel() {
    return this.targetLabel != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RelabelConfigFluentImpl that = (RelabelConfigFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (modulus != null ? !modulus.equals(that.modulus) :that.modulus != null) return false;
    if (regex != null ? !regex.equals(that.regex) :that.regex != null) return false;
    if (replacement != null ? !replacement.equals(that.replacement) :that.replacement != null) return false;
    if (separator != null ? !separator.equals(that.separator) :that.separator != null) return false;
    if (sourceLabels != null ? !sourceLabels.equals(that.sourceLabels) :that.sourceLabels != null) return false;
    if (targetLabel != null ? !targetLabel.equals(that.targetLabel) :that.targetLabel != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  modulus,  regex,  replacement,  separator,  sourceLabels,  targetLabel,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (modulus != null) { sb.append("modulus:"); sb.append(modulus + ","); }
    if (regex != null) { sb.append("regex:"); sb.append(regex + ","); }
    if (replacement != null) { sb.append("replacement:"); sb.append(replacement + ","); }
    if (separator != null) { sb.append("separator:"); sb.append(separator + ","); }
    if (sourceLabels != null && !sourceLabels.isEmpty()) { sb.append("sourceLabels:"); sb.append(sourceLabels + ","); }
    if (targetLabel != null) { sb.append("targetLabel:"); sb.append(targetLabel + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}