package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EmbeddedObjectMetadataBuilder extends EmbeddedObjectMetadataFluentImpl<EmbeddedObjectMetadataBuilder> implements VisitableBuilder<EmbeddedObjectMetadata,EmbeddedObjectMetadataBuilder>{
  public EmbeddedObjectMetadataBuilder() {
    this(false);
  }
  public EmbeddedObjectMetadataBuilder(Boolean validationEnabled) {
    this(new EmbeddedObjectMetadata(), validationEnabled);
  }
  public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadataFluent<?> fluent) {
    this(fluent, false);
  }
  public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadataFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EmbeddedObjectMetadata(), validationEnabled);
  }
  public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadataFluent<?> fluent,EmbeddedObjectMetadata instance) {
    this(fluent, instance, false);
  }
  public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadataFluent<?> fluent,EmbeddedObjectMetadata instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadata instance) {
    this(instance,false);
  }
  public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadata instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotations(instance.getAnnotations()); 
    this.withLabels(instance.getLabels()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  EmbeddedObjectMetadataFluent<?> fluent;
  Boolean validationEnabled;
  public EmbeddedObjectMetadata build() {
    EmbeddedObjectMetadata buildable = new EmbeddedObjectMetadata(fluent.getAnnotations(),fluent.getLabels(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}