package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VictorOpsConfigFluentImpl<A extends VictorOpsConfigFluent<A>> extends BaseFluent<A> implements VictorOpsConfigFluent<A>{
  public VictorOpsConfigFluentImpl() {
  }
  public VictorOpsConfigFluentImpl(VictorOpsConfig instance) {
    this.withApiKey(instance.getApiKey()); 
    this.withApiUrl(instance.getApiUrl()); 
    this.withCustomFields(instance.getCustomFields()); 
    this.withEntityDisplayName(instance.getEntityDisplayName()); 
    this.withHttpConfig(instance.getHttpConfig()); 
    this.withMessageType(instance.getMessageType()); 
    this.withMonitoringTool(instance.getMonitoringTool()); 
    this.withRoutingKey(instance.getRoutingKey()); 
    this.withSendResolved(instance.getSendResolved()); 
    this.withStateMessage(instance.getStateMessage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SecretKeySelector apiKey;
  private String apiUrl;
  private ArrayList<KeyValueBuilder> customFields = new ArrayList<KeyValueBuilder>();
  private String entityDisplayName;
  private HTTPConfigBuilder httpConfig;
  private String messageType;
  private String monitoringTool;
  private String routingKey;
  private Boolean sendResolved;
  private String stateMessage;
  private Map<String,Object> additionalProperties;
  public SecretKeySelector getApiKey() {
    return this.apiKey;
  }
  public A withApiKey(SecretKeySelector apiKey) {
    this.apiKey=apiKey; return (A) this;
  }
  public Boolean hasApiKey() {
    return this.apiKey != null;
  }
  public A withNewApiKey(String key,String name,Boolean optional) {
    return (A)withApiKey(new SecretKeySelector(key, name, optional));
  }
  public String getApiUrl() {
    return this.apiUrl;
  }
  public A withApiUrl(String apiUrl) {
    this.apiUrl=apiUrl; return (A) this;
  }
  public Boolean hasApiUrl() {
    return this.apiUrl != null;
  }
  public A addToCustomFields(Integer index,KeyValue item) {
    if (this.customFields == null) {this.customFields = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("customFields").add(index >= 0 ? index : _visitables.get("customFields").size(), builder);this.customFields.add(index >= 0 ? index : customFields.size(), builder); return (A)this;
  }
  public A setToCustomFields(Integer index,KeyValue item) {
    if (this.customFields == null) {this.customFields = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);
    if (index < 0 || index >= _visitables.get("customFields").size()) { _visitables.get("customFields").add(builder); } else { _visitables.get("customFields").set(index, builder);}
    if (index < 0 || index >= customFields.size()) { customFields.add(builder); } else { customFields.set(index, builder);}
     return (A)this;
  }
  public A addToCustomFields(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    if (this.customFields == null) {this.customFields = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("customFields").add(builder);this.customFields.add(builder);} return (A)this;
  }
  public A addAllToCustomFields(Collection<KeyValue> items) {
    if (this.customFields == null) {this.customFields = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("customFields").add(builder);this.customFields.add(builder);} return (A)this;
  }
  public A removeFromCustomFields(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("customFields").remove(builder);if (this.customFields != null) {this.customFields.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomFields(Collection<KeyValue> items) {
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("customFields").remove(builder);if (this.customFields != null) {this.customFields.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomFields(Predicate<KeyValueBuilder> predicate) {
    if (customFields == null) return (A) this;
    final Iterator<KeyValueBuilder> each = customFields.iterator();
    final List visitables = _visitables.get("customFields");
    while (each.hasNext()) {
      KeyValueBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCustomFields instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<KeyValue> getCustomFields() {
    return customFields != null ? build(customFields) : null;
  }
  public List<KeyValue> buildCustomFields() {
    return customFields != null ? build(customFields) : null;
  }
  public KeyValue buildCustomField(Integer index) {
    return this.customFields.get(index).build();
  }
  public KeyValue buildFirstCustomField() {
    return this.customFields.get(0).build();
  }
  public KeyValue buildLastCustomField() {
    return this.customFields.get(customFields.size() - 1).build();
  }
  public KeyValue buildMatchingCustomField(Predicate<KeyValueBuilder> predicate) {
    for (KeyValueBuilder item: customFields) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCustomField(Predicate<KeyValueBuilder> predicate) {
    for (KeyValueBuilder item: customFields) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCustomFields(List<KeyValue> customFields) {
    if (this.customFields != null) { _visitables.get("customFields").removeAll(this.customFields);}
    if (customFields != null) {this.customFields = new ArrayList(); for (KeyValue item : customFields){this.addToCustomFields(item);}} else { this.customFields = null;} return (A) this;
  }
  public A withCustomFields(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... customFields) {
    if (this.customFields != null) {this.customFields.clear();}
    if (customFields != null) {for (KeyValue item :customFields){ this.addToCustomFields(item);}} return (A) this;
  }
  public Boolean hasCustomFields() {
    return customFields != null && !customFields.isEmpty();
  }
  public A addNewCustomField(String key,String value) {
    return (A)addToCustomFields(new KeyValue(key, value));
  }
  public VictorOpsConfigFluent.CustomFieldsNested<A> addNewCustomField() {
    return new VictorOpsConfigFluentImpl.CustomFieldsNestedImpl();
  }
  public VictorOpsConfigFluent.CustomFieldsNested<A> addNewCustomFieldLike(KeyValue item) {
    return new VictorOpsConfigFluentImpl.CustomFieldsNestedImpl(-1, item);
  }
  public VictorOpsConfigFluent.CustomFieldsNested<A> setNewCustomFieldLike(Integer index,KeyValue item) {
    return new VictorOpsConfigFluentImpl.CustomFieldsNestedImpl(index, item);
  }
  public VictorOpsConfigFluent.CustomFieldsNested<A> editCustomField(Integer index) {
    if (customFields.size() <= index) throw new RuntimeException("Can't edit customFields. Index exceeds size.");
    return setNewCustomFieldLike(index, buildCustomField(index));
  }
  public VictorOpsConfigFluent.CustomFieldsNested<A> editFirstCustomField() {
    if (customFields.size() == 0) throw new RuntimeException("Can't edit first customFields. The list is empty.");
    return setNewCustomFieldLike(0, buildCustomField(0));
  }
  public VictorOpsConfigFluent.CustomFieldsNested<A> editLastCustomField() {
    int index = customFields.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last customFields. The list is empty.");
    return setNewCustomFieldLike(index, buildCustomField(index));
  }
  public VictorOpsConfigFluent.CustomFieldsNested<A> editMatchingCustomField(Predicate<KeyValueBuilder> predicate) {
    int index = -1;
    for (int i=0;i<customFields.size();i++) { 
    if (predicate.test(customFields.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching customFields. No match found.");
    return setNewCustomFieldLike(index, buildCustomField(index));
  }
  public String getEntityDisplayName() {
    return this.entityDisplayName;
  }
  public A withEntityDisplayName(String entityDisplayName) {
    this.entityDisplayName=entityDisplayName; return (A) this;
  }
  public Boolean hasEntityDisplayName() {
    return this.entityDisplayName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildHttpConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTTPConfig getHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public A withHttpConfig(HTTPConfig httpConfig) {
    _visitables.get("httpConfig").remove(this.httpConfig);
    if (httpConfig!=null){ this.httpConfig= new HTTPConfigBuilder(httpConfig); _visitables.get("httpConfig").add(this.httpConfig);} else { this.httpConfig = null; _visitables.get("httpConfig").remove(this.httpConfig); } return (A) this;
  }
  public Boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  public VictorOpsConfigFluent.HttpConfigNested<A> withNewHttpConfig() {
    return new VictorOpsConfigFluentImpl.HttpConfigNestedImpl();
  }
  public VictorOpsConfigFluent.HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new VictorOpsConfigFluentImpl.HttpConfigNestedImpl(item);
  }
  public VictorOpsConfigFluent.HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig());
  }
  public VictorOpsConfigFluent.HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): new HTTPConfigBuilder().build());
  }
  public VictorOpsConfigFluent.HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): item);
  }
  public String getMessageType() {
    return this.messageType;
  }
  public A withMessageType(String messageType) {
    this.messageType=messageType; return (A) this;
  }
  public Boolean hasMessageType() {
    return this.messageType != null;
  }
  public String getMonitoringTool() {
    return this.monitoringTool;
  }
  public A withMonitoringTool(String monitoringTool) {
    this.monitoringTool=monitoringTool; return (A) this;
  }
  public Boolean hasMonitoringTool() {
    return this.monitoringTool != null;
  }
  public String getRoutingKey() {
    return this.routingKey;
  }
  public A withRoutingKey(String routingKey) {
    this.routingKey=routingKey; return (A) this;
  }
  public Boolean hasRoutingKey() {
    return this.routingKey != null;
  }
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved=sendResolved; return (A) this;
  }
  public Boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  public String getStateMessage() {
    return this.stateMessage;
  }
  public A withStateMessage(String stateMessage) {
    this.stateMessage=stateMessage; return (A) this;
  }
  public Boolean hasStateMessage() {
    return this.stateMessage != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VictorOpsConfigFluentImpl that = (VictorOpsConfigFluentImpl) o;
    if (apiKey != null ? !apiKey.equals(that.apiKey) :that.apiKey != null) return false;
    if (apiUrl != null ? !apiUrl.equals(that.apiUrl) :that.apiUrl != null) return false;
    if (customFields != null ? !customFields.equals(that.customFields) :that.customFields != null) return false;
    if (entityDisplayName != null ? !entityDisplayName.equals(that.entityDisplayName) :that.entityDisplayName != null) return false;
    if (httpConfig != null ? !httpConfig.equals(that.httpConfig) :that.httpConfig != null) return false;
    if (messageType != null ? !messageType.equals(that.messageType) :that.messageType != null) return false;
    if (monitoringTool != null ? !monitoringTool.equals(that.monitoringTool) :that.monitoringTool != null) return false;
    if (routingKey != null ? !routingKey.equals(that.routingKey) :that.routingKey != null) return false;
    if (sendResolved != null ? !sendResolved.equals(that.sendResolved) :that.sendResolved != null) return false;
    if (stateMessage != null ? !stateMessage.equals(that.stateMessage) :that.stateMessage != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiKey,  apiUrl,  customFields,  entityDisplayName,  httpConfig,  messageType,  monitoringTool,  routingKey,  sendResolved,  stateMessage,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiKey != null) { sb.append("apiKey:"); sb.append(apiKey + ","); }
    if (apiUrl != null) { sb.append("apiUrl:"); sb.append(apiUrl + ","); }
    if (customFields != null && !customFields.isEmpty()) { sb.append("customFields:"); sb.append(customFields + ","); }
    if (entityDisplayName != null) { sb.append("entityDisplayName:"); sb.append(entityDisplayName + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (messageType != null) { sb.append("messageType:"); sb.append(messageType + ","); }
    if (monitoringTool != null) { sb.append("monitoringTool:"); sb.append(monitoringTool + ","); }
    if (routingKey != null) { sb.append("routingKey:"); sb.append(routingKey + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (stateMessage != null) { sb.append("stateMessage:"); sb.append(stateMessage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withSendResolved() {
    return withSendResolved(true);
  }
  class CustomFieldsNestedImpl<N> extends KeyValueFluentImpl<VictorOpsConfigFluent.CustomFieldsNested<N>> implements VictorOpsConfigFluent.CustomFieldsNested<N>,Nested<N>{
    CustomFieldsNestedImpl(Integer index,KeyValue item) {
      this.index = index;
      this.builder = new KeyValueBuilder(this, item);
    }
    CustomFieldsNestedImpl() {
      this.index = -1;
      this.builder = new KeyValueBuilder(this);
    }
    KeyValueBuilder builder;
    Integer index;
    public N and() {
      return (N) VictorOpsConfigFluentImpl.this.setToCustomFields(index,builder.build());
    }
    public N endCustomField() {
      return and();
    }
    
  }
  class HttpConfigNestedImpl<N> extends HTTPConfigFluentImpl<VictorOpsConfigFluent.HttpConfigNested<N>> implements VictorOpsConfigFluent.HttpConfigNested<N>,Nested<N>{
    HttpConfigNestedImpl(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HttpConfigNestedImpl() {
      this.builder = new HTTPConfigBuilder(this);
    }
    HTTPConfigBuilder builder;
    public N and() {
      return (N) VictorOpsConfigFluentImpl.this.withHttpConfig(builder.build());
    }
    public N endHttpConfig() {
      return and();
    }
    
  }
  
}