package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuleGroupBuilder extends RuleGroupFluentImpl<RuleGroupBuilder> implements VisitableBuilder<RuleGroup,RuleGroupBuilder>{
  public RuleGroupBuilder() {
    this(false);
  }
  public RuleGroupBuilder(Boolean validationEnabled) {
    this(new RuleGroup(), validationEnabled);
  }
  public RuleGroupBuilder(RuleGroupFluent<?> fluent) {
    this(fluent, false);
  }
  public RuleGroupBuilder(RuleGroupFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuleGroup(), validationEnabled);
  }
  public RuleGroupBuilder(RuleGroupFluent<?> fluent,RuleGroup instance) {
    this(fluent, instance, false);
  }
  public RuleGroupBuilder(RuleGroupFluent<?> fluent,RuleGroup instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withInterval(instance.getInterval()); 
    fluent.withName(instance.getName()); 
    fluent.withPartialResponseStrategy(instance.getPartialResponseStrategy()); 
    fluent.withRules(instance.getRules()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RuleGroupBuilder(RuleGroup instance) {
    this(instance,false);
  }
  public RuleGroupBuilder(RuleGroup instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withInterval(instance.getInterval()); 
    this.withName(instance.getName()); 
    this.withPartialResponseStrategy(instance.getPartialResponseStrategy()); 
    this.withRules(instance.getRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RuleGroupFluent<?> fluent;
  Boolean validationEnabled;
  public RuleGroup build() {
    RuleGroup buildable = new RuleGroup(fluent.getInterval(),fluent.getName(),fluent.getPartialResponseStrategy(),fluent.getRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}