package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PrometheusStatusFluentImpl<A extends PrometheusStatusFluent<A>> extends BaseFluent<A> implements PrometheusStatusFluent<A>{
  public PrometheusStatusFluentImpl() {
  }
  public PrometheusStatusFluentImpl(PrometheusStatus instance) {
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withPaused(instance.getPaused()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer availableReplicas;
  private Boolean paused;
  private Integer replicas;
  private Integer unavailableReplicas;
  private Integer updatedReplicas;
  private Map<String,Object> additionalProperties;
  public Integer getAvailableReplicas() {
    return this.availableReplicas;
  }
  public A withAvailableReplicas(Integer availableReplicas) {
    this.availableReplicas=availableReplicas; return (A) this;
  }
  public Boolean hasAvailableReplicas() {
    return this.availableReplicas != null;
  }
  public Boolean getPaused() {
    return this.paused;
  }
  public A withPaused(Boolean paused) {
    this.paused=paused; return (A) this;
  }
  public Boolean hasPaused() {
    return this.paused != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public Integer getUnavailableReplicas() {
    return this.unavailableReplicas;
  }
  public A withUnavailableReplicas(Integer unavailableReplicas) {
    this.unavailableReplicas=unavailableReplicas; return (A) this;
  }
  public Boolean hasUnavailableReplicas() {
    return this.unavailableReplicas != null;
  }
  public Integer getUpdatedReplicas() {
    return this.updatedReplicas;
  }
  public A withUpdatedReplicas(Integer updatedReplicas) {
    this.updatedReplicas=updatedReplicas; return (A) this;
  }
  public Boolean hasUpdatedReplicas() {
    return this.updatedReplicas != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PrometheusStatusFluentImpl that = (PrometheusStatusFluentImpl) o;
    if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
    if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (unavailableReplicas != null ? !unavailableReplicas.equals(that.unavailableReplicas) :that.unavailableReplicas != null) return false;
    if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableReplicas,  paused,  replicas,  unavailableReplicas,  updatedReplicas,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availableReplicas != null) { sb.append("availableReplicas:"); sb.append(availableReplicas + ","); }
    if (paused != null) { sb.append("paused:"); sb.append(paused + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (unavailableReplicas != null) { sb.append("unavailableReplicas:"); sb.append(unavailableReplicas + ","); }
    if (updatedReplicas != null) { sb.append("updatedReplicas:"); sb.append(updatedReplicas + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withPaused() {
    return withPaused(true);
  }
  
}