package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProbeTargetStaticConfigFluentImpl<A extends ProbeTargetStaticConfigFluent<A>> extends BaseFluent<A> implements ProbeTargetStaticConfigFluent<A>{
  public ProbeTargetStaticConfigFluentImpl() {
  }
  public ProbeTargetStaticConfigFluentImpl(ProbeTargetStaticConfig instance) {
    this.withLabels(instance.getLabels()); 
    this.withRelabelingConfigs(instance.getRelabelingConfigs()); 
    this.withStatic(instance.getStatic()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Map<String,String> labels;
  private ArrayList<RelabelConfigBuilder> relabelingConfigs = new ArrayList<RelabelConfigBuilder>();
  private List<String> _static = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public Boolean hasLabels() {
    return this.labels != null;
  }
  public A addToRelabelingConfigs(Integer index,RelabelConfig item) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").add(index >= 0 ? index : _visitables.get("relabelingConfigs").size(), builder);this.relabelingConfigs.add(index >= 0 ? index : relabelingConfigs.size(), builder); return (A)this;
  }
  public A setToRelabelingConfigs(Integer index,RelabelConfig item) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("relabelingConfigs").size()) { _visitables.get("relabelingConfigs").add(builder); } else { _visitables.get("relabelingConfigs").set(index, builder);}
    if (index < 0 || index >= relabelingConfigs.size()) { relabelingConfigs.add(builder); } else { relabelingConfigs.set(index, builder);}
     return (A)this;
  }
  public A addToRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").add(builder);this.relabelingConfigs.add(builder);} return (A)this;
  }
  public A addAllToRelabelingConfigs(Collection<RelabelConfig> items) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").add(builder);this.relabelingConfigs.add(builder);} return (A)this;
  }
  public A removeFromRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").remove(builder);if (this.relabelingConfigs != null) {this.relabelingConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelabelingConfigs(Collection<RelabelConfig> items) {
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").remove(builder);if (this.relabelingConfigs != null) {this.relabelingConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelabelingConfigs(Predicate<RelabelConfigBuilder> predicate) {
    if (relabelingConfigs == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = relabelingConfigs.iterator();
    final List visitables = _visitables.get("relabelingConfigs");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelabelingConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RelabelConfig> getRelabelingConfigs() {
    return relabelingConfigs != null ? build(relabelingConfigs) : null;
  }
  public List<RelabelConfig> buildRelabelingConfigs() {
    return relabelingConfigs != null ? build(relabelingConfigs) : null;
  }
  public RelabelConfig buildRelabelingConfig(Integer index) {
    return this.relabelingConfigs.get(index).build();
  }
  public RelabelConfig buildFirstRelabelingConfig() {
    return this.relabelingConfigs.get(0).build();
  }
  public RelabelConfig buildLastRelabelingConfig() {
    return this.relabelingConfigs.get(relabelingConfigs.size() - 1).build();
  }
  public RelabelConfig buildMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: relabelingConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: relabelingConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelabelingConfigs(List<RelabelConfig> relabelingConfigs) {
    if (this.relabelingConfigs != null) { _visitables.get("relabelingConfigs").removeAll(this.relabelingConfigs);}
    if (relabelingConfigs != null) {this.relabelingConfigs = new ArrayList(); for (RelabelConfig item : relabelingConfigs){this.addToRelabelingConfigs(item);}} else { this.relabelingConfigs = null;} return (A) this;
  }
  public A withRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... relabelingConfigs) {
    if (this.relabelingConfigs != null) {this.relabelingConfigs.clear();}
    if (relabelingConfigs != null) {for (RelabelConfig item :relabelingConfigs){ this.addToRelabelingConfigs(item);}} return (A) this;
  }
  public Boolean hasRelabelingConfigs() {
    return relabelingConfigs != null && !relabelingConfigs.isEmpty();
  }
  public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> addNewRelabelingConfig() {
    return new ProbeTargetStaticConfigFluentImpl.RelabelingConfigsNestedImpl();
  }
  public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> addNewRelabelingConfigLike(RelabelConfig item) {
    return new ProbeTargetStaticConfigFluentImpl.RelabelingConfigsNestedImpl(-1, item);
  }
  public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> setNewRelabelingConfigLike(Integer index,RelabelConfig item) {
    return new ProbeTargetStaticConfigFluentImpl.RelabelingConfigsNestedImpl(index, item);
  }
  public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> editRelabelingConfig(Integer index) {
    if (relabelingConfigs.size() <= index) throw new RuntimeException("Can't edit relabelingConfigs. Index exceeds size.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> editFirstRelabelingConfig() {
    if (relabelingConfigs.size() == 0) throw new RuntimeException("Can't edit first relabelingConfigs. The list is empty.");
    return setNewRelabelingConfigLike(0, buildRelabelingConfig(0));
  }
  public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> editLastRelabelingConfig() {
    int index = relabelingConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relabelingConfigs. The list is empty.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> editMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relabelingConfigs.size();i++) { 
    if (predicate.test(relabelingConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relabelingConfigs. No match found.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  public A addToStatic(Integer index,String item) {
    if (this._static == null) {this._static = new ArrayList<String>();}
    this._static.add(index, item);
    return (A)this;
  }
  public A setToStatic(Integer index,String item) {
    if (this._static == null) {this._static = new ArrayList<String>();}
    this._static.set(index, item); return (A)this;
  }
  public A addToStatic(java.lang.String... items) {
    if (this._static == null) {this._static = new ArrayList<String>();}
    for (String item : items) {this._static.add(item);} return (A)this;
  }
  public A addAllToStatic(Collection<String> items) {
    if (this._static == null) {this._static = new ArrayList<String>();}
    for (String item : items) {this._static.add(item);} return (A)this;
  }
  public A removeFromStatic(java.lang.String... items) {
    for (String item : items) {if (this._static!= null){ this._static.remove(item);}} return (A)this;
  }
  public A removeAllFromStatic(Collection<String> items) {
    for (String item : items) {if (this._static!= null){ this._static.remove(item);}} return (A)this;
  }
  public List<String> getStatic() {
    return this._static;
  }
  public String getStatic(Integer index) {
    return this._static.get(index);
  }
  public String getFirstStatic() {
    return this._static.get(0);
  }
  public String getLastStatic() {
    return this._static.get(_static.size() - 1);
  }
  public String getMatchingStatic(Predicate<String> predicate) {
    for (String item: _static) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingStatic(Predicate<String> predicate) {
    for (String item: _static) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withStatic(List<String> _static) {
    if (_static != null) {this._static = new ArrayList(); for (String item : _static){this.addToStatic(item);}} else { this._static = null;} return (A) this;
  }
  public A withStatic(java.lang.String... _static) {
    if (this._static != null) {this._static.clear();}
    if (_static != null) {for (String item :_static){ this.addToStatic(item);}} return (A) this;
  }
  public Boolean hasStatic() {
    return _static != null && !_static.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProbeTargetStaticConfigFluentImpl that = (ProbeTargetStaticConfigFluentImpl) o;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (relabelingConfigs != null ? !relabelingConfigs.equals(that.relabelingConfigs) :that.relabelingConfigs != null) return false;
    if (_static != null ? !_static.equals(that._static) :that._static != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(labels,  relabelingConfigs,  _static,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (relabelingConfigs != null && !relabelingConfigs.isEmpty()) { sb.append("relabelingConfigs:"); sb.append(relabelingConfigs + ","); }
    if (_static != null && !_static.isEmpty()) { sb.append("_static:"); sb.append(_static + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RelabelingConfigsNestedImpl<N> extends RelabelConfigFluentImpl<ProbeTargetStaticConfigFluent.RelabelingConfigsNested<N>> implements ProbeTargetStaticConfigFluent.RelabelingConfigsNested<N>,Nested<N>{
    RelabelingConfigsNestedImpl(Integer index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelingConfigsNestedImpl() {
      this.index = -1;
      this.builder = new RelabelConfigBuilder(this);
    }
    RelabelConfigBuilder builder;
    Integer index;
    public N and() {
      return (N) ProbeTargetStaticConfigFluentImpl.this.setToRelabelingConfigs(index,builder.build());
    }
    public N endRelabelingConfig() {
      return and();
    }
    
  }
  
}