package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecretOrConfigMapFluentImpl<A extends SecretOrConfigMapFluent<A>> extends BaseFluent<A> implements SecretOrConfigMapFluent<A>{
  public SecretOrConfigMapFluentImpl() {
  }
  public SecretOrConfigMapFluentImpl(SecretOrConfigMap instance) {
    this.withConfigMap(instance.getConfigMap()); 
    this.withSecret(instance.getSecret()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConfigMapKeySelector configMap;
  private SecretKeySelector secret;
  private Map<String,Object> additionalProperties;
  public ConfigMapKeySelector getConfigMap() {
    return this.configMap;
  }
  public A withConfigMap(ConfigMapKeySelector configMap) {
    this.configMap=configMap; return (A) this;
  }
  public Boolean hasConfigMap() {
    return this.configMap != null;
  }
  public A withNewConfigMap(String key,String name,Boolean optional) {
    return (A)withConfigMap(new ConfigMapKeySelector(key, name, optional));
  }
  public SecretKeySelector getSecret() {
    return this.secret;
  }
  public A withSecret(SecretKeySelector secret) {
    this.secret=secret; return (A) this;
  }
  public Boolean hasSecret() {
    return this.secret != null;
  }
  public A withNewSecret(String key,String name,Boolean optional) {
    return (A)withSecret(new SecretKeySelector(key, name, optional));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SecretOrConfigMapFluentImpl that = (SecretOrConfigMapFluentImpl) o;
    if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
    if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configMap,  secret,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}