package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RemoteWriteSpecBuilder extends RemoteWriteSpecFluentImpl<RemoteWriteSpecBuilder> implements VisitableBuilder<RemoteWriteSpec,RemoteWriteSpecBuilder>{
  public RemoteWriteSpecBuilder() {
    this(false);
  }
  public RemoteWriteSpecBuilder(Boolean validationEnabled) {
    this(new RemoteWriteSpec(), validationEnabled);
  }
  public RemoteWriteSpecBuilder(RemoteWriteSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RemoteWriteSpecBuilder(RemoteWriteSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RemoteWriteSpec(), validationEnabled);
  }
  public RemoteWriteSpecBuilder(RemoteWriteSpecFluent<?> fluent,RemoteWriteSpec instance) {
    this(fluent, instance, false);
  }
  public RemoteWriteSpecBuilder(RemoteWriteSpecFluent<?> fluent,RemoteWriteSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthorization(instance.getAuthorization()); 
    fluent.withBasicAuth(instance.getBasicAuth()); 
    fluent.withBearerToken(instance.getBearerToken()); 
    fluent.withBearerTokenFile(instance.getBearerTokenFile()); 
    fluent.withHeaders(instance.getHeaders()); 
    fluent.withMetadataConfig(instance.getMetadataConfig()); 
    fluent.withName(instance.getName()); 
    fluent.withOauth2(instance.getOauth2()); 
    fluent.withProxyUrl(instance.getProxyUrl()); 
    fluent.withQueueConfig(instance.getQueueConfig()); 
    fluent.withRemoteTimeout(instance.getRemoteTimeout()); 
    fluent.withSendExemplars(instance.getSendExemplars()); 
    fluent.withSigv4(instance.getSigv4()); 
    fluent.withTlsConfig(instance.getTlsConfig()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withWriteRelabelConfigs(instance.getWriteRelabelConfigs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RemoteWriteSpecBuilder(RemoteWriteSpec instance) {
    this(instance,false);
  }
  public RemoteWriteSpecBuilder(RemoteWriteSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerToken(instance.getBearerToken()); 
    this.withBearerTokenFile(instance.getBearerTokenFile()); 
    this.withHeaders(instance.getHeaders()); 
    this.withMetadataConfig(instance.getMetadataConfig()); 
    this.withName(instance.getName()); 
    this.withOauth2(instance.getOauth2()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withQueueConfig(instance.getQueueConfig()); 
    this.withRemoteTimeout(instance.getRemoteTimeout()); 
    this.withSendExemplars(instance.getSendExemplars()); 
    this.withSigv4(instance.getSigv4()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withUrl(instance.getUrl()); 
    this.withWriteRelabelConfigs(instance.getWriteRelabelConfigs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RemoteWriteSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RemoteWriteSpec build() {
    RemoteWriteSpec buildable = new RemoteWriteSpec(fluent.getAuthorization(),fluent.getBasicAuth(),fluent.getBearerToken(),fluent.getBearerTokenFile(),fluent.getHeaders(),fluent.getMetadataConfig(),fluent.getName(),fluent.getOauth2(),fluent.getProxyUrl(),fluent.getQueueConfig(),fluent.getRemoteTimeout(),fluent.getSendExemplars(),fluent.getSigv4(),fluent.getTlsConfig(),fluent.getUrl(),fluent.getWriteRelabelConfigs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}