package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AlertmanagerEndpointsFluentImpl<A extends AlertmanagerEndpointsFluent<A>> extends BaseFluent<A> implements AlertmanagerEndpointsFluent<A>{
  public AlertmanagerEndpointsFluentImpl() {
  }
  public AlertmanagerEndpointsFluentImpl(AlertmanagerEndpoints instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withAuthorization(instance.getAuthorization()); 
    this.withBearerTokenFile(instance.getBearerTokenFile()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPathPrefix(instance.getPathPrefix()); 
    this.withPort(instance.getPort()); 
    this.withScheme(instance.getScheme()); 
    this.withTimeout(instance.getTimeout()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private SafeAuthorizationBuilder authorization;
  private String bearerTokenFile;
  private String name;
  private String namespace;
  private String pathPrefix;
  private IntOrStringBuilder port;
  private String scheme;
  private String timeout;
  private TLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @Deprecated
  public SafeAuthorization getAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public SafeAuthorization buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(SafeAuthorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new SafeAuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} else { this.authorization = null; _visitables.get("authorization").remove(this.authorization); } return (A) this;
  }
  public Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public AlertmanagerEndpointsFluent.AuthorizationNested<A> withNewAuthorization() {
    return new AlertmanagerEndpointsFluentImpl.AuthorizationNestedImpl();
  }
  public AlertmanagerEndpointsFluent.AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
    return new AlertmanagerEndpointsFluentImpl.AuthorizationNestedImpl(item);
  }
  public AlertmanagerEndpointsFluent.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public AlertmanagerEndpointsFluent.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new SafeAuthorizationBuilder().build());
  }
  public AlertmanagerEndpointsFluent.AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  public String getBearerTokenFile() {
    return this.bearerTokenFile;
  }
  public A withBearerTokenFile(String bearerTokenFile) {
    this.bearerTokenFile=bearerTokenFile; return (A) this;
  }
  public Boolean hasBearerTokenFile() {
    return this.bearerTokenFile != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public String getPathPrefix() {
    return this.pathPrefix;
  }
  public A withPathPrefix(String pathPrefix) {
    this.pathPrefix=pathPrefix; return (A) this;
  }
  public Boolean hasPathPrefix() {
    return this.pathPrefix != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public IntOrString buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(IntOrString port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(Object value) {
    return (A)withPort(new IntOrString(value));
  }
  public AlertmanagerEndpointsFluent.PortNested<A> withNewPort() {
    return new AlertmanagerEndpointsFluentImpl.PortNestedImpl();
  }
  public AlertmanagerEndpointsFluent.PortNested<A> withNewPortLike(IntOrString item) {
    return new AlertmanagerEndpointsFluentImpl.PortNestedImpl(item);
  }
  public AlertmanagerEndpointsFluent.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public AlertmanagerEndpointsFluent.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new IntOrStringBuilder().build());
  }
  public AlertmanagerEndpointsFluent.PortNested<A> editOrNewPortLike(IntOrString item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  public String getScheme() {
    return this.scheme;
  }
  public A withScheme(String scheme) {
    this.scheme=scheme; return (A) this;
  }
  public Boolean hasScheme() {
    return this.scheme != null;
  }
  public String getTimeout() {
    return this.timeout;
  }
  public A withTimeout(String timeout) {
    this.timeout=timeout; return (A) this;
  }
  public Boolean hasTimeout() {
    return this.timeout != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSConfig getTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public TLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(TLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} else { this.tlsConfig = null; _visitables.get("tlsConfig").remove(this.tlsConfig); } return (A) this;
  }
  public Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public AlertmanagerEndpointsFluent.TlsConfigNested<A> withNewTlsConfig() {
    return new AlertmanagerEndpointsFluentImpl.TlsConfigNestedImpl();
  }
  public AlertmanagerEndpointsFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
    return new AlertmanagerEndpointsFluentImpl.TlsConfigNestedImpl(item);
  }
  public AlertmanagerEndpointsFluent.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public AlertmanagerEndpointsFluent.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new TLSConfigBuilder().build());
  }
  public AlertmanagerEndpointsFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AlertmanagerEndpointsFluentImpl that = (AlertmanagerEndpointsFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
    if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (pathPrefix != null ? !pathPrefix.equals(that.pathPrefix) :that.pathPrefix != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
    if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
    if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  authorization,  bearerTokenFile,  name,  namespace,  pathPrefix,  port,  scheme,  timeout,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (bearerTokenFile != null) { sb.append("bearerTokenFile:"); sb.append(bearerTokenFile + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (pathPrefix != null) { sb.append("pathPrefix:"); sb.append(pathPrefix + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorizationNestedImpl<N> extends SafeAuthorizationFluentImpl<AlertmanagerEndpointsFluent.AuthorizationNested<N>> implements AlertmanagerEndpointsFluent.AuthorizationNested<N>,Nested<N>{
    AuthorizationNestedImpl(SafeAuthorization item) {
      this.builder = new SafeAuthorizationBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new SafeAuthorizationBuilder(this);
    }
    SafeAuthorizationBuilder builder;
    public N and() {
      return (N) AlertmanagerEndpointsFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  class PortNestedImpl<N> extends IntOrStringFluentImpl<AlertmanagerEndpointsFluent.PortNested<N>> implements AlertmanagerEndpointsFluent.PortNested<N>,Nested<N>{
    PortNestedImpl(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new IntOrStringBuilder(this);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) AlertmanagerEndpointsFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  class TlsConfigNestedImpl<N> extends TLSConfigFluentImpl<AlertmanagerEndpointsFluent.TlsConfigNested<N>> implements AlertmanagerEndpointsFluent.TlsConfigNested<N>,Nested<N>{
    TlsConfigNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) AlertmanagerEndpointsFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}