package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProbeTLSConfigBuilder extends ProbeTLSConfigFluent<ProbeTLSConfigBuilder> implements VisitableBuilder<ProbeTLSConfig,ProbeTLSConfigBuilder>{
  public ProbeTLSConfigBuilder() {
    this(new ProbeTLSConfig());
  }
  
  public ProbeTLSConfigBuilder(ProbeTLSConfigFluent<?> fluent) {
    this(fluent, new ProbeTLSConfig());
  }
  
  public ProbeTLSConfigBuilder(ProbeTLSConfigFluent<?> fluent,ProbeTLSConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProbeTLSConfigBuilder(ProbeTLSConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProbeTLSConfigFluent<?> fluent;
  
  public ProbeTLSConfig build() {
    ProbeTLSConfig buildable = new ProbeTLSConfig(fluent.buildCa(),fluent.buildCert(),fluent.getInsecureSkipVerify(),fluent.getKeySecret(),fluent.getServerName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}