package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MatcherBuilder extends MatcherFluentImpl<MatcherBuilder> implements VisitableBuilder<Matcher,MatcherBuilder>{
  public MatcherBuilder() {
    this(false);
  }
  public MatcherBuilder(Boolean validationEnabled) {
    this(new Matcher(), validationEnabled);
  }
  public MatcherBuilder(MatcherFluent<?> fluent) {
    this(fluent, false);
  }
  public MatcherBuilder(MatcherFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Matcher(), validationEnabled);
  }
  public MatcherBuilder(MatcherFluent<?> fluent,Matcher instance) {
    this(fluent, instance, false);
  }
  public MatcherBuilder(MatcherFluent<?> fluent,Matcher instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withRegex(instance.getRegex()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MatcherBuilder(Matcher instance) {
    this(instance,false);
  }
  public MatcherBuilder(Matcher instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withRegex(instance.getRegex()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MatcherFluent<?> fluent;
  Boolean validationEnabled;
  public Matcher build() {
    Matcher buildable = new Matcher(fluent.getName(),fluent.getRegex(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}