package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface EmailConfigFluent<A extends EmailConfigFluent<A>> extends Fluent<A>{
  public String getAuthIdentity();
  public A withAuthIdentity(String authIdentity);
  public Boolean hasAuthIdentity();
  public SecretKeySelector getAuthPassword();
  public A withAuthPassword(SecretKeySelector authPassword);
  public Boolean hasAuthPassword();
  public A withNewAuthPassword(String key,String name,Boolean optional);
  public SecretKeySelector getAuthSecret();
  public A withAuthSecret(SecretKeySelector authSecret);
  public Boolean hasAuthSecret();
  public A withNewAuthSecret(String key,String name,Boolean optional);
  public String getAuthUsername();
  public A withAuthUsername(String authUsername);
  public Boolean hasAuthUsername();
  public String getFrom();
  public A withFrom(String from);
  public Boolean hasFrom();
  public A addToHeaders(Integer index,KeyValue item);
  public A setToHeaders(Integer index,KeyValue item);
  public A addToHeaders(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items);
  public A addAllToHeaders(Collection<KeyValue> items);
  public A removeFromHeaders(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items);
  public A removeAllFromHeaders(Collection<KeyValue> items);
  public A removeMatchingFromHeaders(Predicate<KeyValueBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildHeaders instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<KeyValue> getHeaders();
  public List<KeyValue> buildHeaders();
  public KeyValue buildHeader(Integer index);
  public KeyValue buildFirstHeader();
  public KeyValue buildLastHeader();
  public KeyValue buildMatchingHeader(Predicate<KeyValueBuilder> predicate);
  public Boolean hasMatchingHeader(Predicate<KeyValueBuilder> predicate);
  public A withHeaders(List<KeyValue> headers);
  public A withHeaders(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... headers);
  public Boolean hasHeaders();
  public A addNewHeader(String key,String value);
  public EmailConfigFluent.HeadersNested<A> addNewHeader();
  public EmailConfigFluent.HeadersNested<A> addNewHeaderLike(KeyValue item);
  public EmailConfigFluent.HeadersNested<A> setNewHeaderLike(Integer index,KeyValue item);
  public EmailConfigFluent.HeadersNested<A> editHeader(Integer index);
  public EmailConfigFluent.HeadersNested<A> editFirstHeader();
  public EmailConfigFluent.HeadersNested<A> editLastHeader();
  public EmailConfigFluent.HeadersNested<A> editMatchingHeader(Predicate<KeyValueBuilder> predicate);
  public String getHello();
  public A withHello(String hello);
  public Boolean hasHello();
  public String getHtml();
  public A withHtml(String html);
  public Boolean hasHtml();
  public Boolean getRequireTLS();
  public A withRequireTLS(Boolean requireTLS);
  public Boolean hasRequireTLS();
  public Boolean getSendResolved();
  public A withSendResolved(Boolean sendResolved);
  public Boolean hasSendResolved();
  public String getSmarthost();
  public A withSmarthost(String smarthost);
  public Boolean hasSmarthost();
  public String getText();
  public A withText(String text);
  public Boolean hasText();
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public SafeTLSConfig getTlsConfig();
  public SafeTLSConfig buildTlsConfig();
  public A withTlsConfig(SafeTLSConfig tlsConfig);
  public Boolean hasTlsConfig();
  public EmailConfigFluent.TlsConfigNested<A> withNewTlsConfig();
  public EmailConfigFluent.TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item);
  public EmailConfigFluent.TlsConfigNested<A> editTlsConfig();
  public EmailConfigFluent.TlsConfigNested<A> editOrNewTlsConfig();
  public EmailConfigFluent.TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item);
  public String getTo();
  public A withTo(String to);
  public Boolean hasTo();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withRequireTLS();
  public A withSendResolved();
  public interface HeadersNested<N> extends Nested<N>,KeyValueFluent<EmailConfigFluent.HeadersNested<N>>{
    public N and();
    public N endHeader();
    
  }
  public interface TlsConfigNested<N> extends Nested<N>,SafeTLSConfigFluent<EmailConfigFluent.TlsConfigNested<N>>{
    public N and();
    public N endTlsConfig();
    
  }
  
}