package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TLSConfigFluentImpl<A extends TLSConfigFluent<A>> extends BaseFluent<A> implements TLSConfigFluent<A>{
  public TLSConfigFluentImpl() {
  }
  public TLSConfigFluentImpl(TLSConfig instance) {
    this.withCa(instance.getCa()); 
    this.withCaFile(instance.getCaFile()); 
    this.withCert(instance.getCert()); 
    this.withCertFile(instance.getCertFile()); 
    this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    this.withKeyFile(instance.getKeyFile()); 
    this.withKeySecret(instance.getKeySecret()); 
    this.withServerName(instance.getServerName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SecretOrConfigMapBuilder ca;
  private String caFile;
  private SecretOrConfigMapBuilder cert;
  private String certFile;
  private Boolean insecureSkipVerify;
  private String keyFile;
  private SecretKeySelector keySecret;
  private String serverName;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretOrConfigMap getCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public SecretOrConfigMap buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(SecretOrConfigMap ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new SecretOrConfigMapBuilder(ca); _visitables.get("ca").add(this.ca);} else { this.ca = null; _visitables.get("ca").remove(this.ca); } return (A) this;
  }
  public Boolean hasCa() {
    return this.ca != null;
  }
  public TLSConfigFluent.CaNested<A> withNewCa() {
    return new TLSConfigFluentImpl.CaNestedImpl();
  }
  public TLSConfigFluent.CaNested<A> withNewCaLike(SecretOrConfigMap item) {
    return new TLSConfigFluentImpl.CaNestedImpl(item);
  }
  public TLSConfigFluent.CaNested<A> editCa() {
    return withNewCaLike(getCa());
  }
  public TLSConfigFluent.CaNested<A> editOrNewCa() {
    return withNewCaLike(getCa() != null ? getCa(): new SecretOrConfigMapBuilder().build());
  }
  public TLSConfigFluent.CaNested<A> editOrNewCaLike(SecretOrConfigMap item) {
    return withNewCaLike(getCa() != null ? getCa(): item);
  }
  public String getCaFile() {
    return this.caFile;
  }
  public A withCaFile(String caFile) {
    this.caFile=caFile; return (A) this;
  }
  public Boolean hasCaFile() {
    return this.caFile != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCert instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretOrConfigMap getCert() {
    return this.cert!=null ?this.cert.build():null;
  }
  public SecretOrConfigMap buildCert() {
    return this.cert!=null ?this.cert.build():null;
  }
  public A withCert(SecretOrConfigMap cert) {
    _visitables.get("cert").remove(this.cert);
    if (cert!=null){ this.cert= new SecretOrConfigMapBuilder(cert); _visitables.get("cert").add(this.cert);} else { this.cert = null; _visitables.get("cert").remove(this.cert); } return (A) this;
  }
  public Boolean hasCert() {
    return this.cert != null;
  }
  public TLSConfigFluent.CertNested<A> withNewCert() {
    return new TLSConfigFluentImpl.CertNestedImpl();
  }
  public TLSConfigFluent.CertNested<A> withNewCertLike(SecretOrConfigMap item) {
    return new TLSConfigFluentImpl.CertNestedImpl(item);
  }
  public TLSConfigFluent.CertNested<A> editCert() {
    return withNewCertLike(getCert());
  }
  public TLSConfigFluent.CertNested<A> editOrNewCert() {
    return withNewCertLike(getCert() != null ? getCert(): new SecretOrConfigMapBuilder().build());
  }
  public TLSConfigFluent.CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
    return withNewCertLike(getCert() != null ? getCert(): item);
  }
  public String getCertFile() {
    return this.certFile;
  }
  public A withCertFile(String certFile) {
    this.certFile=certFile; return (A) this;
  }
  public Boolean hasCertFile() {
    return this.certFile != null;
  }
  public Boolean getInsecureSkipVerify() {
    return this.insecureSkipVerify;
  }
  public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
    this.insecureSkipVerify=insecureSkipVerify; return (A) this;
  }
  public Boolean hasInsecureSkipVerify() {
    return this.insecureSkipVerify != null;
  }
  public String getKeyFile() {
    return this.keyFile;
  }
  public A withKeyFile(String keyFile) {
    this.keyFile=keyFile; return (A) this;
  }
  public Boolean hasKeyFile() {
    return this.keyFile != null;
  }
  public SecretKeySelector getKeySecret() {
    return this.keySecret;
  }
  public A withKeySecret(SecretKeySelector keySecret) {
    this.keySecret=keySecret; return (A) this;
  }
  public Boolean hasKeySecret() {
    return this.keySecret != null;
  }
  public A withNewKeySecret(String key,String name,Boolean optional) {
    return (A)withKeySecret(new SecretKeySelector(key, name, optional));
  }
  public String getServerName() {
    return this.serverName;
  }
  public A withServerName(String serverName) {
    this.serverName=serverName; return (A) this;
  }
  public Boolean hasServerName() {
    return this.serverName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TLSConfigFluentImpl that = (TLSConfigFluentImpl) o;
    if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
    if (caFile != null ? !caFile.equals(that.caFile) :that.caFile != null) return false;
    if (cert != null ? !cert.equals(that.cert) :that.cert != null) return false;
    if (certFile != null ? !certFile.equals(that.certFile) :that.certFile != null) return false;
    if (insecureSkipVerify != null ? !insecureSkipVerify.equals(that.insecureSkipVerify) :that.insecureSkipVerify != null) return false;
    if (keyFile != null ? !keyFile.equals(that.keyFile) :that.keyFile != null) return false;
    if (keySecret != null ? !keySecret.equals(that.keySecret) :that.keySecret != null) return false;
    if (serverName != null ? !serverName.equals(that.serverName) :that.serverName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  caFile,  cert,  certFile,  insecureSkipVerify,  keyFile,  keySecret,  serverName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (caFile != null) { sb.append("caFile:"); sb.append(caFile + ","); }
    if (cert != null) { sb.append("cert:"); sb.append(cert + ","); }
    if (certFile != null) { sb.append("certFile:"); sb.append(certFile + ","); }
    if (insecureSkipVerify != null) { sb.append("insecureSkipVerify:"); sb.append(insecureSkipVerify + ","); }
    if (keyFile != null) { sb.append("keyFile:"); sb.append(keyFile + ","); }
    if (keySecret != null) { sb.append("keySecret:"); sb.append(keySecret + ","); }
    if (serverName != null) { sb.append("serverName:"); sb.append(serverName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withInsecureSkipVerify() {
    return withInsecureSkipVerify(true);
  }
  class CaNestedImpl<N> extends SecretOrConfigMapFluentImpl<TLSConfigFluent.CaNested<N>> implements TLSConfigFluent.CaNested<N>,Nested<N>{
    CaNestedImpl(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    CaNestedImpl() {
      this.builder = new SecretOrConfigMapBuilder(this);
    }
    SecretOrConfigMapBuilder builder;
    public N and() {
      return (N) TLSConfigFluentImpl.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  class CertNestedImpl<N> extends SecretOrConfigMapFluentImpl<TLSConfigFluent.CertNested<N>> implements TLSConfigFluent.CertNested<N>,Nested<N>{
    CertNestedImpl(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    CertNestedImpl() {
      this.builder = new SecretOrConfigMapBuilder(this);
    }
    SecretOrConfigMapBuilder builder;
    public N and() {
      return (N) TLSConfigFluentImpl.this.withCert(builder.build());
    }
    public N endCert() {
      return and();
    }
    
  }
  
}