package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RemoteWriteSpecFluentImpl<A extends RemoteWriteSpecFluent<A>> extends BaseFluent<A> implements RemoteWriteSpecFluent<A>{
  public RemoteWriteSpecFluentImpl() {
  }
  public RemoteWriteSpecFluentImpl(RemoteWriteSpec instance) {
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerToken(instance.getBearerToken()); 
    this.withBearerTokenFile(instance.getBearerTokenFile()); 
    this.withHeaders(instance.getHeaders()); 
    this.withMetadataConfig(instance.getMetadataConfig()); 
    this.withName(instance.getName()); 
    this.withOauth2(instance.getOauth2()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withQueueConfig(instance.getQueueConfig()); 
    this.withRemoteTimeout(instance.getRemoteTimeout()); 
    this.withSendExemplars(instance.getSendExemplars()); 
    this.withSigv4(instance.getSigv4()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withUrl(instance.getUrl()); 
    this.withWriteRelabelConfigs(instance.getWriteRelabelConfigs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private AuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private String bearerToken;
  private String bearerTokenFile;
  private Map<String,String> headers;
  private MetadataConfigBuilder metadataConfig;
  private String name;
  private OAuth2Builder oauth2;
  private String proxyUrl;
  private QueueConfigBuilder queueConfig;
  private String remoteTimeout;
  private Boolean sendExemplars;
  private Sigv4Builder sigv4;
  private TLSConfigBuilder tlsConfig;
  private String url;
  private ArrayList<RelabelConfigBuilder> writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @Deprecated
  public Authorization getAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public Authorization buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(Authorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new AuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} else { this.authorization = null; _visitables.get("authorization").remove(this.authorization); } return (A) this;
  }
  public Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public RemoteWriteSpecFluent.AuthorizationNested<A> withNewAuthorization() {
    return new RemoteWriteSpecFluentImpl.AuthorizationNestedImpl();
  }
  public RemoteWriteSpecFluent.AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
    return new RemoteWriteSpecFluentImpl.AuthorizationNestedImpl(item);
  }
  public RemoteWriteSpecFluent.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public RemoteWriteSpecFluent.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new AuthorizationBuilder().build());
  }
  public RemoteWriteSpecFluent.AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @Deprecated
  public BasicAuth getBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public BasicAuth buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(BasicAuth basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} else { this.basicAuth = null; _visitables.get("basicAuth").remove(this.basicAuth); } return (A) this;
  }
  public Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public RemoteWriteSpecFluent.BasicAuthNested<A> withNewBasicAuth() {
    return new RemoteWriteSpecFluentImpl.BasicAuthNestedImpl();
  }
  public RemoteWriteSpecFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new RemoteWriteSpecFluentImpl.BasicAuthNestedImpl(item);
  }
  public RemoteWriteSpecFluent.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public RemoteWriteSpecFluent.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthBuilder().build());
  }
  public RemoteWriteSpecFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  public String getBearerToken() {
    return this.bearerToken;
  }
  public A withBearerToken(String bearerToken) {
    this.bearerToken=bearerToken; return (A) this;
  }
  public Boolean hasBearerToken() {
    return this.bearerToken != null;
  }
  public String getBearerTokenFile() {
    return this.bearerTokenFile;
  }
  public A withBearerTokenFile(String bearerTokenFile) {
    this.bearerTokenFile=bearerTokenFile; return (A) this;
  }
  public Boolean hasBearerTokenFile() {
    return this.bearerTokenFile != null;
  }
  public A addToHeaders(String key,String value) {
    if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap(); }
    if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
  }
  public A addToHeaders(Map<String,String> map) {
    if(this.headers == null && map != null) { this.headers = new LinkedHashMap(); }
    if(map != null) { this.headers.putAll(map);} return (A)this;
  }
  public A removeFromHeaders(String key) {
    if(this.headers == null) { return (A) this; }
    if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
  }
  public A removeFromHeaders(Map<String,String> map) {
    if(this.headers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
  }
  public Map<String,String> getHeaders() {
    return this.headers;
  }
  public <K,V>A withHeaders(Map<String,String> headers) {
    if (headers == null) { this.headers =  null;} else {this.headers = new LinkedHashMap(headers);} return (A) this;
  }
  public Boolean hasHeaders() {
    return this.headers != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadataConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public MetadataConfig getMetadataConfig() {
    return this.metadataConfig!=null ?this.metadataConfig.build():null;
  }
  public MetadataConfig buildMetadataConfig() {
    return this.metadataConfig!=null ?this.metadataConfig.build():null;
  }
  public A withMetadataConfig(MetadataConfig metadataConfig) {
    _visitables.get("metadataConfig").remove(this.metadataConfig);
    if (metadataConfig!=null){ this.metadataConfig= new MetadataConfigBuilder(metadataConfig); _visitables.get("metadataConfig").add(this.metadataConfig);} else { this.metadataConfig = null; _visitables.get("metadataConfig").remove(this.metadataConfig); } return (A) this;
  }
  public Boolean hasMetadataConfig() {
    return this.metadataConfig != null;
  }
  public A withNewMetadataConfig(Boolean send,String sendInterval) {
    return (A)withMetadataConfig(new MetadataConfig(send, sendInterval));
  }
  public RemoteWriteSpecFluent.MetadataConfigNested<A> withNewMetadataConfig() {
    return new RemoteWriteSpecFluentImpl.MetadataConfigNestedImpl();
  }
  public RemoteWriteSpecFluent.MetadataConfigNested<A> withNewMetadataConfigLike(MetadataConfig item) {
    return new RemoteWriteSpecFluentImpl.MetadataConfigNestedImpl(item);
  }
  public RemoteWriteSpecFluent.MetadataConfigNested<A> editMetadataConfig() {
    return withNewMetadataConfigLike(getMetadataConfig());
  }
  public RemoteWriteSpecFluent.MetadataConfigNested<A> editOrNewMetadataConfig() {
    return withNewMetadataConfigLike(getMetadataConfig() != null ? getMetadataConfig(): new MetadataConfigBuilder().build());
  }
  public RemoteWriteSpecFluent.MetadataConfigNested<A> editOrNewMetadataConfigLike(MetadataConfig item) {
    return withNewMetadataConfigLike(getMetadataConfig() != null ? getMetadataConfig(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOauth2 instead.
   * @return The buildable object.
   */
  @Deprecated
  public OAuth2 getOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public OAuth2 buildOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public A withOauth2(OAuth2 oauth2) {
    _visitables.get("oauth2").remove(this.oauth2);
    if (oauth2!=null){ this.oauth2= new OAuth2Builder(oauth2); _visitables.get("oauth2").add(this.oauth2);} else { this.oauth2 = null; _visitables.get("oauth2").remove(this.oauth2); } return (A) this;
  }
  public Boolean hasOauth2() {
    return this.oauth2 != null;
  }
  public RemoteWriteSpecFluent.Oauth2Nested<A> withNewOauth2() {
    return new RemoteWriteSpecFluentImpl.Oauth2NestedImpl();
  }
  public RemoteWriteSpecFluent.Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
    return new RemoteWriteSpecFluentImpl.Oauth2NestedImpl(item);
  }
  public RemoteWriteSpecFluent.Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(getOauth2());
  }
  public RemoteWriteSpecFluent.Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): new OAuth2Builder().build());
  }
  public RemoteWriteSpecFluent.Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): item);
  }
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl=proxyUrl; return (A) this;
  }
  public Boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  /**
   * This method has been deprecated, please use method buildQueueConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public QueueConfig getQueueConfig() {
    return this.queueConfig!=null ?this.queueConfig.build():null;
  }
  public QueueConfig buildQueueConfig() {
    return this.queueConfig!=null ?this.queueConfig.build():null;
  }
  public A withQueueConfig(QueueConfig queueConfig) {
    _visitables.get("queueConfig").remove(this.queueConfig);
    if (queueConfig!=null){ this.queueConfig= new QueueConfigBuilder(queueConfig); _visitables.get("queueConfig").add(this.queueConfig);} else { this.queueConfig = null; _visitables.get("queueConfig").remove(this.queueConfig); } return (A) this;
  }
  public Boolean hasQueueConfig() {
    return this.queueConfig != null;
  }
  public RemoteWriteSpecFluent.QueueConfigNested<A> withNewQueueConfig() {
    return new RemoteWriteSpecFluentImpl.QueueConfigNestedImpl();
  }
  public RemoteWriteSpecFluent.QueueConfigNested<A> withNewQueueConfigLike(QueueConfig item) {
    return new RemoteWriteSpecFluentImpl.QueueConfigNestedImpl(item);
  }
  public RemoteWriteSpecFluent.QueueConfigNested<A> editQueueConfig() {
    return withNewQueueConfigLike(getQueueConfig());
  }
  public RemoteWriteSpecFluent.QueueConfigNested<A> editOrNewQueueConfig() {
    return withNewQueueConfigLike(getQueueConfig() != null ? getQueueConfig(): new QueueConfigBuilder().build());
  }
  public RemoteWriteSpecFluent.QueueConfigNested<A> editOrNewQueueConfigLike(QueueConfig item) {
    return withNewQueueConfigLike(getQueueConfig() != null ? getQueueConfig(): item);
  }
  public String getRemoteTimeout() {
    return this.remoteTimeout;
  }
  public A withRemoteTimeout(String remoteTimeout) {
    this.remoteTimeout=remoteTimeout; return (A) this;
  }
  public Boolean hasRemoteTimeout() {
    return this.remoteTimeout != null;
  }
  public Boolean getSendExemplars() {
    return this.sendExemplars;
  }
  public A withSendExemplars(Boolean sendExemplars) {
    this.sendExemplars=sendExemplars; return (A) this;
  }
  public Boolean hasSendExemplars() {
    return this.sendExemplars != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSigv4 instead.
   * @return The buildable object.
   */
  @Deprecated
  public Sigv4 getSigv4() {
    return this.sigv4!=null ?this.sigv4.build():null;
  }
  public Sigv4 buildSigv4() {
    return this.sigv4!=null ?this.sigv4.build():null;
  }
  public A withSigv4(Sigv4 sigv4) {
    _visitables.get("sigv4").remove(this.sigv4);
    if (sigv4!=null){ this.sigv4= new Sigv4Builder(sigv4); _visitables.get("sigv4").add(this.sigv4);} else { this.sigv4 = null; _visitables.get("sigv4").remove(this.sigv4); } return (A) this;
  }
  public Boolean hasSigv4() {
    return this.sigv4 != null;
  }
  public RemoteWriteSpecFluent.Sigv4Nested<A> withNewSigv4() {
    return new RemoteWriteSpecFluentImpl.Sigv4NestedImpl();
  }
  public RemoteWriteSpecFluent.Sigv4Nested<A> withNewSigv4Like(Sigv4 item) {
    return new RemoteWriteSpecFluentImpl.Sigv4NestedImpl(item);
  }
  public RemoteWriteSpecFluent.Sigv4Nested<A> editSigv4() {
    return withNewSigv4Like(getSigv4());
  }
  public RemoteWriteSpecFluent.Sigv4Nested<A> editOrNewSigv4() {
    return withNewSigv4Like(getSigv4() != null ? getSigv4(): new Sigv4Builder().build());
  }
  public RemoteWriteSpecFluent.Sigv4Nested<A> editOrNewSigv4Like(Sigv4 item) {
    return withNewSigv4Like(getSigv4() != null ? getSigv4(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSConfig getTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public TLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(TLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} else { this.tlsConfig = null; _visitables.get("tlsConfig").remove(this.tlsConfig); } return (A) this;
  }
  public Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public RemoteWriteSpecFluent.TlsConfigNested<A> withNewTlsConfig() {
    return new RemoteWriteSpecFluentImpl.TlsConfigNestedImpl();
  }
  public RemoteWriteSpecFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
    return new RemoteWriteSpecFluentImpl.TlsConfigNestedImpl(item);
  }
  public RemoteWriteSpecFluent.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public RemoteWriteSpecFluent.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new TLSConfigBuilder().build());
  }
  public RemoteWriteSpecFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public A addToWriteRelabelConfigs(Integer index,RelabelConfig item) {
    if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").add(index >= 0 ? index : _visitables.get("writeRelabelConfigs").size(), builder);this.writeRelabelConfigs.add(index >= 0 ? index : writeRelabelConfigs.size(), builder); return (A)this;
  }
  public A setToWriteRelabelConfigs(Integer index,RelabelConfig item) {
    if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("writeRelabelConfigs").size()) { _visitables.get("writeRelabelConfigs").add(builder); } else { _visitables.get("writeRelabelConfigs").set(index, builder);}
    if (index < 0 || index >= writeRelabelConfigs.size()) { writeRelabelConfigs.add(builder); } else { writeRelabelConfigs.set(index, builder);}
     return (A)this;
  }
  public A addToWriteRelabelConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").add(builder);this.writeRelabelConfigs.add(builder);} return (A)this;
  }
  public A addAllToWriteRelabelConfigs(Collection<RelabelConfig> items) {
    if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").add(builder);this.writeRelabelConfigs.add(builder);} return (A)this;
  }
  public A removeFromWriteRelabelConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").remove(builder);if (this.writeRelabelConfigs != null) {this.writeRelabelConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromWriteRelabelConfigs(Collection<RelabelConfig> items) {
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").remove(builder);if (this.writeRelabelConfigs != null) {this.writeRelabelConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromWriteRelabelConfigs(Predicate<RelabelConfigBuilder> predicate) {
    if (writeRelabelConfigs == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = writeRelabelConfigs.iterator();
    final List visitables = _visitables.get("writeRelabelConfigs");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildWriteRelabelConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RelabelConfig> getWriteRelabelConfigs() {
    return writeRelabelConfigs != null ? build(writeRelabelConfigs) : null;
  }
  public List<RelabelConfig> buildWriteRelabelConfigs() {
    return writeRelabelConfigs != null ? build(writeRelabelConfigs) : null;
  }
  public RelabelConfig buildWriteRelabelConfig(Integer index) {
    return this.writeRelabelConfigs.get(index).build();
  }
  public RelabelConfig buildFirstWriteRelabelConfig() {
    return this.writeRelabelConfigs.get(0).build();
  }
  public RelabelConfig buildLastWriteRelabelConfig() {
    return this.writeRelabelConfigs.get(writeRelabelConfigs.size() - 1).build();
  }
  public RelabelConfig buildMatchingWriteRelabelConfig(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: writeRelabelConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingWriteRelabelConfig(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: writeRelabelConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withWriteRelabelConfigs(List<RelabelConfig> writeRelabelConfigs) {
    if (this.writeRelabelConfigs != null) { _visitables.get("writeRelabelConfigs").removeAll(this.writeRelabelConfigs);}
    if (writeRelabelConfigs != null) {this.writeRelabelConfigs = new ArrayList(); for (RelabelConfig item : writeRelabelConfigs){this.addToWriteRelabelConfigs(item);}} else { this.writeRelabelConfigs = null;} return (A) this;
  }
  public A withWriteRelabelConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... writeRelabelConfigs) {
    if (this.writeRelabelConfigs != null) {this.writeRelabelConfigs.clear();}
    if (writeRelabelConfigs != null) {for (RelabelConfig item :writeRelabelConfigs){ this.addToWriteRelabelConfigs(item);}} return (A) this;
  }
  public Boolean hasWriteRelabelConfigs() {
    return writeRelabelConfigs != null && !writeRelabelConfigs.isEmpty();
  }
  public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> addNewWriteRelabelConfig() {
    return new RemoteWriteSpecFluentImpl.WriteRelabelConfigsNestedImpl();
  }
  public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> addNewWriteRelabelConfigLike(RelabelConfig item) {
    return new RemoteWriteSpecFluentImpl.WriteRelabelConfigsNestedImpl(-1, item);
  }
  public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> setNewWriteRelabelConfigLike(Integer index,RelabelConfig item) {
    return new RemoteWriteSpecFluentImpl.WriteRelabelConfigsNestedImpl(index, item);
  }
  public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> editWriteRelabelConfig(Integer index) {
    if (writeRelabelConfigs.size() <= index) throw new RuntimeException("Can't edit writeRelabelConfigs. Index exceeds size.");
    return setNewWriteRelabelConfigLike(index, buildWriteRelabelConfig(index));
  }
  public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> editFirstWriteRelabelConfig() {
    if (writeRelabelConfigs.size() == 0) throw new RuntimeException("Can't edit first writeRelabelConfigs. The list is empty.");
    return setNewWriteRelabelConfigLike(0, buildWriteRelabelConfig(0));
  }
  public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> editLastWriteRelabelConfig() {
    int index = writeRelabelConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last writeRelabelConfigs. The list is empty.");
    return setNewWriteRelabelConfigLike(index, buildWriteRelabelConfig(index));
  }
  public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> editMatchingWriteRelabelConfig(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<writeRelabelConfigs.size();i++) { 
    if (predicate.test(writeRelabelConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching writeRelabelConfigs. No match found.");
    return setNewWriteRelabelConfigLike(index, buildWriteRelabelConfig(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoteWriteSpecFluentImpl that = (RemoteWriteSpecFluentImpl) o;
    if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
    if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
    if (bearerToken != null ? !bearerToken.equals(that.bearerToken) :that.bearerToken != null) return false;
    if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
    if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
    if (metadataConfig != null ? !metadataConfig.equals(that.metadataConfig) :that.metadataConfig != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (oauth2 != null ? !oauth2.equals(that.oauth2) :that.oauth2 != null) return false;
    if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
    if (queueConfig != null ? !queueConfig.equals(that.queueConfig) :that.queueConfig != null) return false;
    if (remoteTimeout != null ? !remoteTimeout.equals(that.remoteTimeout) :that.remoteTimeout != null) return false;
    if (sendExemplars != null ? !sendExemplars.equals(that.sendExemplars) :that.sendExemplars != null) return false;
    if (sigv4 != null ? !sigv4.equals(that.sigv4) :that.sigv4 != null) return false;
    if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    if (writeRelabelConfigs != null ? !writeRelabelConfigs.equals(that.writeRelabelConfigs) :that.writeRelabelConfigs != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerToken,  bearerTokenFile,  headers,  metadataConfig,  name,  oauth2,  proxyUrl,  queueConfig,  remoteTimeout,  sendExemplars,  sigv4,  tlsConfig,  url,  writeRelabelConfigs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerToken != null) { sb.append("bearerToken:"); sb.append(bearerToken + ","); }
    if (bearerTokenFile != null) { sb.append("bearerTokenFile:"); sb.append(bearerTokenFile + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (metadataConfig != null) { sb.append("metadataConfig:"); sb.append(metadataConfig + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (queueConfig != null) { sb.append("queueConfig:"); sb.append(queueConfig + ","); }
    if (remoteTimeout != null) { sb.append("remoteTimeout:"); sb.append(remoteTimeout + ","); }
    if (sendExemplars != null) { sb.append("sendExemplars:"); sb.append(sendExemplars + ","); }
    if (sigv4 != null) { sb.append("sigv4:"); sb.append(sigv4 + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (writeRelabelConfigs != null && !writeRelabelConfigs.isEmpty()) { sb.append("writeRelabelConfigs:"); sb.append(writeRelabelConfigs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withSendExemplars() {
    return withSendExemplars(true);
  }
  class AuthorizationNestedImpl<N> extends AuthorizationFluentImpl<RemoteWriteSpecFluent.AuthorizationNested<N>> implements RemoteWriteSpecFluent.AuthorizationNested<N>,Nested<N>{
    AuthorizationNestedImpl(Authorization item) {
      this.builder = new AuthorizationBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new AuthorizationBuilder(this);
    }
    AuthorizationBuilder builder;
    public N and() {
      return (N) RemoteWriteSpecFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<RemoteWriteSpecFluent.BasicAuthNested<N>> implements RemoteWriteSpecFluent.BasicAuthNested<N>,Nested<N>{
    BasicAuthNestedImpl(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new BasicAuthBuilder(this);
    }
    BasicAuthBuilder builder;
    public N and() {
      return (N) RemoteWriteSpecFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  class MetadataConfigNestedImpl<N> extends MetadataConfigFluentImpl<RemoteWriteSpecFluent.MetadataConfigNested<N>> implements RemoteWriteSpecFluent.MetadataConfigNested<N>,Nested<N>{
    MetadataConfigNestedImpl(MetadataConfig item) {
      this.builder = new MetadataConfigBuilder(this, item);
    }
    MetadataConfigNestedImpl() {
      this.builder = new MetadataConfigBuilder(this);
    }
    MetadataConfigBuilder builder;
    public N and() {
      return (N) RemoteWriteSpecFluentImpl.this.withMetadataConfig(builder.build());
    }
    public N endMetadataConfig() {
      return and();
    }
    
  }
  class Oauth2NestedImpl<N> extends OAuth2FluentImpl<RemoteWriteSpecFluent.Oauth2Nested<N>> implements RemoteWriteSpecFluent.Oauth2Nested<N>,Nested<N>{
    Oauth2NestedImpl(OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    Oauth2NestedImpl() {
      this.builder = new OAuth2Builder(this);
    }
    OAuth2Builder builder;
    public N and() {
      return (N) RemoteWriteSpecFluentImpl.this.withOauth2(builder.build());
    }
    public N endOauth2() {
      return and();
    }
    
  }
  class QueueConfigNestedImpl<N> extends QueueConfigFluentImpl<RemoteWriteSpecFluent.QueueConfigNested<N>> implements RemoteWriteSpecFluent.QueueConfigNested<N>,Nested<N>{
    QueueConfigNestedImpl(QueueConfig item) {
      this.builder = new QueueConfigBuilder(this, item);
    }
    QueueConfigNestedImpl() {
      this.builder = new QueueConfigBuilder(this);
    }
    QueueConfigBuilder builder;
    public N and() {
      return (N) RemoteWriteSpecFluentImpl.this.withQueueConfig(builder.build());
    }
    public N endQueueConfig() {
      return and();
    }
    
  }
  class Sigv4NestedImpl<N> extends Sigv4FluentImpl<RemoteWriteSpecFluent.Sigv4Nested<N>> implements RemoteWriteSpecFluent.Sigv4Nested<N>,Nested<N>{
    Sigv4NestedImpl(Sigv4 item) {
      this.builder = new Sigv4Builder(this, item);
    }
    Sigv4NestedImpl() {
      this.builder = new Sigv4Builder(this);
    }
    Sigv4Builder builder;
    public N and() {
      return (N) RemoteWriteSpecFluentImpl.this.withSigv4(builder.build());
    }
    public N endSigv4() {
      return and();
    }
    
  }
  class TlsConfigNestedImpl<N> extends TLSConfigFluentImpl<RemoteWriteSpecFluent.TlsConfigNested<N>> implements RemoteWriteSpecFluent.TlsConfigNested<N>,Nested<N>{
    TlsConfigNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) RemoteWriteSpecFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  class WriteRelabelConfigsNestedImpl<N> extends RelabelConfigFluentImpl<RemoteWriteSpecFluent.WriteRelabelConfigsNested<N>> implements RemoteWriteSpecFluent.WriteRelabelConfigsNested<N>,Nested<N>{
    WriteRelabelConfigsNestedImpl(Integer index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    WriteRelabelConfigsNestedImpl() {
      this.index = -1;
      this.builder = new RelabelConfigBuilder(this);
    }
    RelabelConfigBuilder builder;
    Integer index;
    public N and() {
      return (N) RemoteWriteSpecFluentImpl.this.setToWriteRelabelConfigs(index,builder.build());
    }
    public N endWriteRelabelConfig() {
      return and();
    }
    
  }
  
}