package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusStatusBuilder extends PrometheusStatusFluentImpl<PrometheusStatusBuilder> implements VisitableBuilder<PrometheusStatus,PrometheusStatusBuilder>{
  public PrometheusStatusBuilder() {
    this(false);
  }
  public PrometheusStatusBuilder(Boolean validationEnabled) {
    this(new PrometheusStatus(), validationEnabled);
  }
  public PrometheusStatusBuilder(PrometheusStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusStatusBuilder(PrometheusStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrometheusStatus(), validationEnabled);
  }
  public PrometheusStatusBuilder(PrometheusStatusFluent<?> fluent,PrometheusStatus instance) {
    this(fluent, instance, false);
  }
  public PrometheusStatusBuilder(PrometheusStatusFluent<?> fluent,PrometheusStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PrometheusStatusBuilder(PrometheusStatus instance) {
    this(instance,false);
  }
  public PrometheusStatusBuilder(PrometheusStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withPaused(instance.getPaused()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PrometheusStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PrometheusStatus build() {
    PrometheusStatus buildable = new PrometheusStatus(fluent.getAvailableReplicas(),fluent.getPaused(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}