package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import java.lang.Integer;

 /**
  * Generated
  */
public interface PrometheusSpecFluent<A extends PrometheusSpecFluent<A>> extends Fluent<A>{
  public SecretKeySelector getAdditionalAlertManagerConfigs();
  public A withAdditionalAlertManagerConfigs(SecretKeySelector additionalAlertManagerConfigs);
  public Boolean hasAdditionalAlertManagerConfigs();
  public A withNewAdditionalAlertManagerConfigs(String key,String name,Boolean optional);
  public SecretKeySelector getAdditionalAlertRelabelConfigs();
  public A withAdditionalAlertRelabelConfigs(SecretKeySelector additionalAlertRelabelConfigs);
  public Boolean hasAdditionalAlertRelabelConfigs();
  public A withNewAdditionalAlertRelabelConfigs(String key,String name,Boolean optional);
  public SecretKeySelector getAdditionalScrapeConfigs();
  public A withAdditionalScrapeConfigs(SecretKeySelector additionalScrapeConfigs);
  public Boolean hasAdditionalScrapeConfigs();
  public A withNewAdditionalScrapeConfigs(String key,String name,Boolean optional);
  public Affinity getAffinity();
  public A withAffinity(Affinity affinity);
  public Boolean hasAffinity();
  
  /**
   * This method has been deprecated, please use method buildAlerting instead.
   * @return The buildable object.
   */
  @Deprecated
  public AlertingSpec getAlerting();
  public AlertingSpec buildAlerting();
  public A withAlerting(AlertingSpec alerting);
  public Boolean hasAlerting();
  public PrometheusSpecFluent.AlertingNested<A> withNewAlerting();
  public PrometheusSpecFluent.AlertingNested<A> withNewAlertingLike(AlertingSpec item);
  public PrometheusSpecFluent.AlertingNested<A> editAlerting();
  public PrometheusSpecFluent.AlertingNested<A> editOrNewAlerting();
  public PrometheusSpecFluent.AlertingNested<A> editOrNewAlertingLike(AlertingSpec item);
  public Boolean getAllowOverlappingBlocks();
  public A withAllowOverlappingBlocks(Boolean allowOverlappingBlocks);
  public Boolean hasAllowOverlappingBlocks();
  
  /**
   * This method has been deprecated, please use method buildApiserverConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServerConfig getApiserverConfig();
  public APIServerConfig buildApiserverConfig();
  public A withApiserverConfig(APIServerConfig apiserverConfig);
  public Boolean hasApiserverConfig();
  public PrometheusSpecFluent.ApiserverConfigNested<A> withNewApiserverConfig();
  public PrometheusSpecFluent.ApiserverConfigNested<A> withNewApiserverConfigLike(APIServerConfig item);
  public PrometheusSpecFluent.ApiserverConfigNested<A> editApiserverConfig();
  public PrometheusSpecFluent.ApiserverConfigNested<A> editOrNewApiserverConfig();
  public PrometheusSpecFluent.ApiserverConfigNested<A> editOrNewApiserverConfigLike(APIServerConfig item);
  
  /**
   * This method has been deprecated, please use method buildArbitraryFSAccessThroughSMs instead.
   * @return The buildable object.
   */
  @Deprecated
  public ArbitraryFSAccessThroughSMsConfig getArbitraryFSAccessThroughSMs();
  public ArbitraryFSAccessThroughSMsConfig buildArbitraryFSAccessThroughSMs();
  public A withArbitraryFSAccessThroughSMs(ArbitraryFSAccessThroughSMsConfig arbitraryFSAccessThroughSMs);
  public Boolean hasArbitraryFSAccessThroughSMs();
  public A withNewArbitraryFSAccessThroughSMs(Boolean deny);
  public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> withNewArbitraryFSAccessThroughSMs();
  public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> withNewArbitraryFSAccessThroughSMsLike(ArbitraryFSAccessThroughSMsConfig item);
  public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> editArbitraryFSAccessThroughSMs();
  public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> editOrNewArbitraryFSAccessThroughSMs();
  public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> editOrNewArbitraryFSAccessThroughSMsLike(ArbitraryFSAccessThroughSMsConfig item);
  public String getBaseImage();
  public A withBaseImage(String baseImage);
  public Boolean hasBaseImage();
  public A addToConfigMaps(Integer index,String item);
  public A setToConfigMaps(Integer index,String item);
  public A addToConfigMaps(java.lang.String... items);
  public A addAllToConfigMaps(Collection<String> items);
  public A removeFromConfigMaps(java.lang.String... items);
  public A removeAllFromConfigMaps(Collection<String> items);
  public List<String> getConfigMaps();
  public String getConfigMap(Integer index);
  public String getFirstConfigMap();
  public String getLastConfigMap();
  public String getMatchingConfigMap(Predicate<String> predicate);
  public Boolean hasMatchingConfigMap(Predicate<String> predicate);
  public A withConfigMaps(List<String> configMaps);
  public A withConfigMaps(java.lang.String... configMaps);
  public Boolean hasConfigMaps();
  public A addToContainers(Integer index,Container item);
  public A setToContainers(Integer index,Container item);
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToContainers(Collection<Container> items);
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromContainers(Collection<Container> items);
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getContainers();
  public List<Container> buildContainers();
  public Container buildContainer(Integer index);
  public Container buildFirstContainer();
  public Container buildLastContainer();
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate);
  public A withContainers(List<Container> containers);
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers);
  public Boolean hasContainers();
  public PrometheusSpecFluent.ContainersNested<A> addNewContainer();
  public PrometheusSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
  public PrometheusSpecFluent.ContainersNested<A> setNewContainerLike(Integer index,Container item);
  public PrometheusSpecFluent.ContainersNested<A> editContainer(Integer index);
  public PrometheusSpecFluent.ContainersNested<A> editFirstContainer();
  public PrometheusSpecFluent.ContainersNested<A> editLastContainer();
  public PrometheusSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate);
  public Boolean getDisableCompaction();
  public A withDisableCompaction(Boolean disableCompaction);
  public Boolean hasDisableCompaction();
  public Boolean getEnableAdminAPI();
  public A withEnableAdminAPI(Boolean enableAdminAPI);
  public Boolean hasEnableAdminAPI();
  public A addToEnableFeatures(Integer index,String item);
  public A setToEnableFeatures(Integer index,String item);
  public A addToEnableFeatures(java.lang.String... items);
  public A addAllToEnableFeatures(Collection<String> items);
  public A removeFromEnableFeatures(java.lang.String... items);
  public A removeAllFromEnableFeatures(Collection<String> items);
  public List<String> getEnableFeatures();
  public String getEnableFeature(Integer index);
  public String getFirstEnableFeature();
  public String getLastEnableFeature();
  public String getMatchingEnableFeature(Predicate<String> predicate);
  public Boolean hasMatchingEnableFeature(Predicate<String> predicate);
  public A withEnableFeatures(List<String> enableFeatures);
  public A withEnableFeatures(java.lang.String... enableFeatures);
  public Boolean hasEnableFeatures();
  public String getEnforcedBodySizeLimit();
  public A withEnforcedBodySizeLimit(String enforcedBodySizeLimit);
  public Boolean hasEnforcedBodySizeLimit();
  public Long getEnforcedLabelLimit();
  public A withEnforcedLabelLimit(Long enforcedLabelLimit);
  public Boolean hasEnforcedLabelLimit();
  public Long getEnforcedLabelNameLengthLimit();
  public A withEnforcedLabelNameLengthLimit(Long enforcedLabelNameLengthLimit);
  public Boolean hasEnforcedLabelNameLengthLimit();
  public Long getEnforcedLabelValueLengthLimit();
  public A withEnforcedLabelValueLengthLimit(Long enforcedLabelValueLengthLimit);
  public Boolean hasEnforcedLabelValueLengthLimit();
  public String getEnforcedNamespaceLabel();
  public A withEnforcedNamespaceLabel(String enforcedNamespaceLabel);
  public Boolean hasEnforcedNamespaceLabel();
  public Long getEnforcedSampleLimit();
  public A withEnforcedSampleLimit(Long enforcedSampleLimit);
  public Boolean hasEnforcedSampleLimit();
  public Long getEnforcedTargetLimit();
  public A withEnforcedTargetLimit(Long enforcedTargetLimit);
  public Boolean hasEnforcedTargetLimit();
  public String getEvaluationInterval();
  public A withEvaluationInterval(String evaluationInterval);
  public Boolean hasEvaluationInterval();
  public A addToExternalLabels(String key,String value);
  public A addToExternalLabels(Map<String,String> map);
  public A removeFromExternalLabels(String key);
  public A removeFromExternalLabels(Map<String,String> map);
  public Map<String,String> getExternalLabels();
  public <K,V>A withExternalLabels(Map<String,String> externalLabels);
  public Boolean hasExternalLabels();
  public String getExternalUrl();
  public A withExternalUrl(String externalUrl);
  public Boolean hasExternalUrl();
  public Boolean getIgnoreNamespaceSelectors();
  public A withIgnoreNamespaceSelectors(Boolean ignoreNamespaceSelectors);
  public Boolean hasIgnoreNamespaceSelectors();
  public String getImage();
  public A withImage(String image);
  public Boolean hasImage();
  public A addToImagePullSecrets(Integer index,LocalObjectReference item);
  public A setToImagePullSecrets(Integer index,LocalObjectReference item);
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets();
  public List<LocalObjectReference> buildImagePullSecrets();
  public LocalObjectReference buildImagePullSecret(Integer index);
  public LocalObjectReference buildFirstImagePullSecret();
  public LocalObjectReference buildLastImagePullSecret();
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets);
  public Boolean hasImagePullSecrets();
  public A addNewImagePullSecret(String name);
  public PrometheusSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
  public PrometheusSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
  public PrometheusSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(Integer index,LocalObjectReference item);
  public PrometheusSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(Integer index);
  public PrometheusSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
  public PrometheusSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
  public PrometheusSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A addToInitContainers(Integer index,Container item);
  public A setToInitContainers(Integer index,Container item);
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToInitContainers(Collection<Container> items);
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromInitContainers(Collection<Container> items);
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getInitContainers();
  public List<Container> buildInitContainers();
  public Container buildInitContainer(Integer index);
  public Container buildFirstInitContainer();
  public Container buildLastInitContainer();
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public A withInitContainers(List<Container> initContainers);
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers);
  public Boolean hasInitContainers();
  public PrometheusSpecFluent.InitContainersNested<A> addNewInitContainer();
  public PrometheusSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item);
  public PrometheusSpecFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item);
  public PrometheusSpecFluent.InitContainersNested<A> editInitContainer(Integer index);
  public PrometheusSpecFluent.InitContainersNested<A> editFirstInitContainer();
  public PrometheusSpecFluent.InitContainersNested<A> editLastInitContainer();
  public PrometheusSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public Boolean getListenLocal();
  public A withListenLocal(Boolean listenLocal);
  public Boolean hasListenLocal();
  public String getLogFormat();
  public A withLogFormat(String logFormat);
  public Boolean hasLogFormat();
  public String getLogLevel();
  public A withLogLevel(String logLevel);
  public Boolean hasLogLevel();
  public Integer getMinReadySeconds();
  public A withMinReadySeconds(Integer minReadySeconds);
  public Boolean hasMinReadySeconds();
  public A addToNodeSelector(String key,String value);
  public A addToNodeSelector(Map<String,String> map);
  public A removeFromNodeSelector(String key);
  public A removeFromNodeSelector(Map<String,String> map);
  public Map<String,String> getNodeSelector();
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector);
  public Boolean hasNodeSelector();
  public Boolean getOverrideHonorLabels();
  public A withOverrideHonorLabels(Boolean overrideHonorLabels);
  public Boolean hasOverrideHonorLabels();
  public Boolean getOverrideHonorTimestamps();
  public A withOverrideHonorTimestamps(Boolean overrideHonorTimestamps);
  public Boolean hasOverrideHonorTimestamps();
  public Boolean getPaused();
  public A withPaused(Boolean paused);
  public Boolean hasPaused();
  
  /**
   * This method has been deprecated, please use method buildPodMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public EmbeddedObjectMetadata getPodMetadata();
  public EmbeddedObjectMetadata buildPodMetadata();
  public A withPodMetadata(EmbeddedObjectMetadata podMetadata);
  public Boolean hasPodMetadata();
  public PrometheusSpecFluent.PodMetadataNested<A> withNewPodMetadata();
  public PrometheusSpecFluent.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item);
  public PrometheusSpecFluent.PodMetadataNested<A> editPodMetadata();
  public PrometheusSpecFluent.PodMetadataNested<A> editOrNewPodMetadata();
  public PrometheusSpecFluent.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item);
  
  /**
   * This method has been deprecated, please use method buildPodMonitorNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getPodMonitorNamespaceSelector();
  public LabelSelector buildPodMonitorNamespaceSelector();
  public A withPodMonitorNamespaceSelector(LabelSelector podMonitorNamespaceSelector);
  public Boolean hasPodMonitorNamespaceSelector();
  public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> withNewPodMonitorNamespaceSelector();
  public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> withNewPodMonitorNamespaceSelectorLike(LabelSelector item);
  public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> editPodMonitorNamespaceSelector();
  public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> editOrNewPodMonitorNamespaceSelector();
  public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> editOrNewPodMonitorNamespaceSelectorLike(LabelSelector item);
  
  /**
   * This method has been deprecated, please use method buildPodMonitorSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getPodMonitorSelector();
  public LabelSelector buildPodMonitorSelector();
  public A withPodMonitorSelector(LabelSelector podMonitorSelector);
  public Boolean hasPodMonitorSelector();
  public PrometheusSpecFluent.PodMonitorSelectorNested<A> withNewPodMonitorSelector();
  public PrometheusSpecFluent.PodMonitorSelectorNested<A> withNewPodMonitorSelectorLike(LabelSelector item);
  public PrometheusSpecFluent.PodMonitorSelectorNested<A> editPodMonitorSelector();
  public PrometheusSpecFluent.PodMonitorSelectorNested<A> editOrNewPodMonitorSelector();
  public PrometheusSpecFluent.PodMonitorSelectorNested<A> editOrNewPodMonitorSelectorLike(LabelSelector item);
  public String getPortName();
  public A withPortName(String portName);
  public Boolean hasPortName();
  public String getPriorityClassName();
  public A withPriorityClassName(String priorityClassName);
  public Boolean hasPriorityClassName();
  
  /**
   * This method has been deprecated, please use method buildProbeNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getProbeNamespaceSelector();
  public LabelSelector buildProbeNamespaceSelector();
  public A withProbeNamespaceSelector(LabelSelector probeNamespaceSelector);
  public Boolean hasProbeNamespaceSelector();
  public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> withNewProbeNamespaceSelector();
  public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> withNewProbeNamespaceSelectorLike(LabelSelector item);
  public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> editProbeNamespaceSelector();
  public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> editOrNewProbeNamespaceSelector();
  public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> editOrNewProbeNamespaceSelectorLike(LabelSelector item);
  
  /**
   * This method has been deprecated, please use method buildProbeSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getProbeSelector();
  public LabelSelector buildProbeSelector();
  public A withProbeSelector(LabelSelector probeSelector);
  public Boolean hasProbeSelector();
  public PrometheusSpecFluent.ProbeSelectorNested<A> withNewProbeSelector();
  public PrometheusSpecFluent.ProbeSelectorNested<A> withNewProbeSelectorLike(LabelSelector item);
  public PrometheusSpecFluent.ProbeSelectorNested<A> editProbeSelector();
  public PrometheusSpecFluent.ProbeSelectorNested<A> editOrNewProbeSelector();
  public PrometheusSpecFluent.ProbeSelectorNested<A> editOrNewProbeSelectorLike(LabelSelector item);
  public String getPrometheusExternalLabelName();
  public A withPrometheusExternalLabelName(String prometheusExternalLabelName);
  public Boolean hasPrometheusExternalLabelName();
  public A addToPrometheusRulesExcludedFromEnforce(Integer index,PrometheusRuleExcludeConfig item);
  public A setToPrometheusRulesExcludedFromEnforce(Integer index,PrometheusRuleExcludeConfig item);
  public A addToPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... items);
  public A addAllToPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items);
  public A removeFromPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... items);
  public A removeAllFromPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items);
  public A removeMatchingFromPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPrometheusRulesExcludedFromEnforce instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PrometheusRuleExcludeConfig> getPrometheusRulesExcludedFromEnforce();
  public List<PrometheusRuleExcludeConfig> buildPrometheusRulesExcludedFromEnforce();
  public PrometheusRuleExcludeConfig buildPrometheusRulesExcludedFromEnforce(Integer index);
  public PrometheusRuleExcludeConfig buildFirstPrometheusRulesExcludedFromEnforce();
  public PrometheusRuleExcludeConfig buildLastPrometheusRulesExcludedFromEnforce();
  public PrometheusRuleExcludeConfig buildMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
  public Boolean hasMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
  public A withPrometheusRulesExcludedFromEnforce(List<PrometheusRuleExcludeConfig> prometheusRulesExcludedFromEnforce);
  public A withPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... prometheusRulesExcludedFromEnforce);
  public Boolean hasPrometheusRulesExcludedFromEnforce();
  public A addNewPrometheusRulesExcludedFromEnforce(String ruleName,String ruleNamespace);
  public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforce();
  public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforceLike(PrometheusRuleExcludeConfig item);
  public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> setNewPrometheusRulesExcludedFromEnforceLike(Integer index,PrometheusRuleExcludeConfig item);
  public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editPrometheusRulesExcludedFromEnforce(Integer index);
  public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editFirstPrometheusRulesExcludedFromEnforce();
  public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editLastPrometheusRulesExcludedFromEnforce();
  public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildQuery instead.
   * @return The buildable object.
   */
  @Deprecated
  public QuerySpec getQuery();
  public QuerySpec buildQuery();
  public A withQuery(QuerySpec query);
  public Boolean hasQuery();
  public A withNewQuery(String lookbackDelta,Integer maxConcurrency,Integer maxSamples,String timeout);
  public PrometheusSpecFluent.QueryNested<A> withNewQuery();
  public PrometheusSpecFluent.QueryNested<A> withNewQueryLike(QuerySpec item);
  public PrometheusSpecFluent.QueryNested<A> editQuery();
  public PrometheusSpecFluent.QueryNested<A> editOrNewQuery();
  public PrometheusSpecFluent.QueryNested<A> editOrNewQueryLike(QuerySpec item);
  public String getQueryLogFile();
  public A withQueryLogFile(String queryLogFile);
  public Boolean hasQueryLogFile();
  public A addToRemoteRead(Integer index,RemoteReadSpec item);
  public A setToRemoteRead(Integer index,RemoteReadSpec item);
  public A addToRemoteRead(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec... items);
  public A addAllToRemoteRead(Collection<RemoteReadSpec> items);
  public A removeFromRemoteRead(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec... items);
  public A removeAllFromRemoteRead(Collection<RemoteReadSpec> items);
  public A removeMatchingFromRemoteRead(Predicate<RemoteReadSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildRemoteRead instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RemoteReadSpec> getRemoteRead();
  public List<RemoteReadSpec> buildRemoteRead();
  public RemoteReadSpec buildRemoteRead(Integer index);
  public RemoteReadSpec buildFirstRemoteRead();
  public RemoteReadSpec buildLastRemoteRead();
  public RemoteReadSpec buildMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate);
  public Boolean hasMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate);
  public A withRemoteRead(List<RemoteReadSpec> remoteRead);
  public A withRemoteRead(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec... remoteRead);
  public Boolean hasRemoteRead();
  public PrometheusSpecFluent.RemoteReadNested<A> addNewRemoteRead();
  public PrometheusSpecFluent.RemoteReadNested<A> addNewRemoteReadLike(RemoteReadSpec item);
  public PrometheusSpecFluent.RemoteReadNested<A> setNewRemoteReadLike(Integer index,RemoteReadSpec item);
  public PrometheusSpecFluent.RemoteReadNested<A> editRemoteRead(Integer index);
  public PrometheusSpecFluent.RemoteReadNested<A> editFirstRemoteRead();
  public PrometheusSpecFluent.RemoteReadNested<A> editLastRemoteRead();
  public PrometheusSpecFluent.RemoteReadNested<A> editMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate);
  public A addToRemoteWrite(Integer index,RemoteWriteSpec item);
  public A setToRemoteWrite(Integer index,RemoteWriteSpec item);
  public A addToRemoteWrite(io.fabric8.openshift.api.model.monitoring.v1.RemoteWriteSpec... items);
  public A addAllToRemoteWrite(Collection<RemoteWriteSpec> items);
  public A removeFromRemoteWrite(io.fabric8.openshift.api.model.monitoring.v1.RemoteWriteSpec... items);
  public A removeAllFromRemoteWrite(Collection<RemoteWriteSpec> items);
  public A removeMatchingFromRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildRemoteWrite instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RemoteWriteSpec> getRemoteWrite();
  public List<RemoteWriteSpec> buildRemoteWrite();
  public RemoteWriteSpec buildRemoteWrite(Integer index);
  public RemoteWriteSpec buildFirstRemoteWrite();
  public RemoteWriteSpec buildLastRemoteWrite();
  public RemoteWriteSpec buildMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate);
  public Boolean hasMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate);
  public A withRemoteWrite(List<RemoteWriteSpec> remoteWrite);
  public A withRemoteWrite(io.fabric8.openshift.api.model.monitoring.v1.RemoteWriteSpec... remoteWrite);
  public Boolean hasRemoteWrite();
  public PrometheusSpecFluent.RemoteWriteNested<A> addNewRemoteWrite();
  public PrometheusSpecFluent.RemoteWriteNested<A> addNewRemoteWriteLike(RemoteWriteSpec item);
  public PrometheusSpecFluent.RemoteWriteNested<A> setNewRemoteWriteLike(Integer index,RemoteWriteSpec item);
  public PrometheusSpecFluent.RemoteWriteNested<A> editRemoteWrite(Integer index);
  public PrometheusSpecFluent.RemoteWriteNested<A> editFirstRemoteWrite();
  public PrometheusSpecFluent.RemoteWriteNested<A> editLastRemoteWrite();
  public PrometheusSpecFluent.RemoteWriteNested<A> editMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate);
  public String getReplicaExternalLabelName();
  public A withReplicaExternalLabelName(String replicaExternalLabelName);
  public Boolean hasReplicaExternalLabelName();
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources();
  public ResourceRequirements buildResources();
  public A withResources(ResourceRequirements resources);
  public Boolean hasResources();
  public PrometheusSpecFluent.ResourcesNested<A> withNewResources();
  public PrometheusSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
  public PrometheusSpecFluent.ResourcesNested<A> editResources();
  public PrometheusSpecFluent.ResourcesNested<A> editOrNewResources();
  public PrometheusSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
  public String getRetention();
  public A withRetention(String retention);
  public Boolean hasRetention();
  public String getRetentionSize();
  public A withRetentionSize(String retentionSize);
  public Boolean hasRetentionSize();
  public String getRoutePrefix();
  public A withRoutePrefix(String routePrefix);
  public Boolean hasRoutePrefix();
  
  /**
   * This method has been deprecated, please use method buildRuleNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRuleNamespaceSelector();
  public LabelSelector buildRuleNamespaceSelector();
  public A withRuleNamespaceSelector(LabelSelector ruleNamespaceSelector);
  public Boolean hasRuleNamespaceSelector();
  public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelector();
  public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelectorLike(LabelSelector item);
  public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> editRuleNamespaceSelector();
  public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelector();
  public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelectorLike(LabelSelector item);
  
  /**
   * This method has been deprecated, please use method buildRuleSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRuleSelector();
  public LabelSelector buildRuleSelector();
  public A withRuleSelector(LabelSelector ruleSelector);
  public Boolean hasRuleSelector();
  public PrometheusSpecFluent.RuleSelectorNested<A> withNewRuleSelector();
  public PrometheusSpecFluent.RuleSelectorNested<A> withNewRuleSelectorLike(LabelSelector item);
  public PrometheusSpecFluent.RuleSelectorNested<A> editRuleSelector();
  public PrometheusSpecFluent.RuleSelectorNested<A> editOrNewRuleSelector();
  public PrometheusSpecFluent.RuleSelectorNested<A> editOrNewRuleSelectorLike(LabelSelector item);
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public Rules getRules();
  public Rules buildRules();
  public A withRules(Rules rules);
  public Boolean hasRules();
  public PrometheusSpecFluent.RulesNested<A> withNewRules();
  public PrometheusSpecFluent.RulesNested<A> withNewRulesLike(Rules item);
  public PrometheusSpecFluent.RulesNested<A> editRules();
  public PrometheusSpecFluent.RulesNested<A> editOrNewRules();
  public PrometheusSpecFluent.RulesNested<A> editOrNewRulesLike(Rules item);
  public String getScrapeInterval();
  public A withScrapeInterval(String scrapeInterval);
  public Boolean hasScrapeInterval();
  public String getScrapeTimeout();
  public A withScrapeTimeout(String scrapeTimeout);
  public Boolean hasScrapeTimeout();
  public A addToSecrets(Integer index,String item);
  public A setToSecrets(Integer index,String item);
  public A addToSecrets(java.lang.String... items);
  public A addAllToSecrets(Collection<String> items);
  public A removeFromSecrets(java.lang.String... items);
  public A removeAllFromSecrets(Collection<String> items);
  public List<String> getSecrets();
  public String getSecret(Integer index);
  public String getFirstSecret();
  public String getLastSecret();
  public String getMatchingSecret(Predicate<String> predicate);
  public Boolean hasMatchingSecret(Predicate<String> predicate);
  public A withSecrets(List<String> secrets);
  public A withSecrets(java.lang.String... secrets);
  public Boolean hasSecrets();
  public PodSecurityContext getSecurityContext();
  public A withSecurityContext(PodSecurityContext securityContext);
  public Boolean hasSecurityContext();
  public String getServiceAccountName();
  public A withServiceAccountName(String serviceAccountName);
  public Boolean hasServiceAccountName();
  
  /**
   * This method has been deprecated, please use method buildServiceMonitorNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getServiceMonitorNamespaceSelector();
  public LabelSelector buildServiceMonitorNamespaceSelector();
  public A withServiceMonitorNamespaceSelector(LabelSelector serviceMonitorNamespaceSelector);
  public Boolean hasServiceMonitorNamespaceSelector();
  public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> withNewServiceMonitorNamespaceSelector();
  public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> withNewServiceMonitorNamespaceSelectorLike(LabelSelector item);
  public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> editServiceMonitorNamespaceSelector();
  public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> editOrNewServiceMonitorNamespaceSelector();
  public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> editOrNewServiceMonitorNamespaceSelectorLike(LabelSelector item);
  
  /**
   * This method has been deprecated, please use method buildServiceMonitorSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getServiceMonitorSelector();
  public LabelSelector buildServiceMonitorSelector();
  public A withServiceMonitorSelector(LabelSelector serviceMonitorSelector);
  public Boolean hasServiceMonitorSelector();
  public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> withNewServiceMonitorSelector();
  public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> withNewServiceMonitorSelectorLike(LabelSelector item);
  public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> editServiceMonitorSelector();
  public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> editOrNewServiceMonitorSelector();
  public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> editOrNewServiceMonitorSelectorLike(LabelSelector item);
  public String getSha();
  public A withSha(String sha);
  public Boolean hasSha();
  public Integer getShards();
  public A withShards(Integer shards);
  public Boolean hasShards();
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @Deprecated
  public StorageSpec getStorage();
  public StorageSpec buildStorage();
  public A withStorage(StorageSpec storage);
  public Boolean hasStorage();
  public PrometheusSpecFluent.StorageNested<A> withNewStorage();
  public PrometheusSpecFluent.StorageNested<A> withNewStorageLike(StorageSpec item);
  public PrometheusSpecFluent.StorageNested<A> editStorage();
  public PrometheusSpecFluent.StorageNested<A> editOrNewStorage();
  public PrometheusSpecFluent.StorageNested<A> editOrNewStorageLike(StorageSpec item);
  public String getTag();
  public A withTag(String tag);
  public Boolean hasTag();
  
  /**
   * This method has been deprecated, please use method buildThanos instead.
   * @return The buildable object.
   */
  @Deprecated
  public ThanosSpec getThanos();
  public ThanosSpec buildThanos();
  public A withThanos(ThanosSpec thanos);
  public Boolean hasThanos();
  public PrometheusSpecFluent.ThanosNested<A> withNewThanos();
  public PrometheusSpecFluent.ThanosNested<A> withNewThanosLike(ThanosSpec item);
  public PrometheusSpecFluent.ThanosNested<A> editThanos();
  public PrometheusSpecFluent.ThanosNested<A> editOrNewThanos();
  public PrometheusSpecFluent.ThanosNested<A> editOrNewThanosLike(ThanosSpec item);
  public A addToTolerations(Integer index,Toleration item);
  public A setToTolerations(Integer index,Toleration item);
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A addAllToTolerations(Collection<Toleration> items);
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A removeAllFromTolerations(Collection<Toleration> items);
  public List<Toleration> getTolerations();
  public Toleration getToleration(Integer index);
  public Toleration getFirstToleration();
  public Toleration getLastToleration();
  public Toleration getMatchingToleration(Predicate<Toleration> predicate);
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate);
  public A withTolerations(List<Toleration> tolerations);
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations);
  public Boolean hasTolerations();
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
  public A addToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item);
  public A setToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item);
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public List<TopologySpreadConstraint> getTopologySpreadConstraints();
  public TopologySpreadConstraint getTopologySpreadConstraint(Integer index);
  public TopologySpreadConstraint getFirstTopologySpreadConstraint();
  public TopologySpreadConstraint getLastTopologySpreadConstraint();
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate);
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate);
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints);
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints);
  public Boolean hasTopologySpreadConstraints();
  public String getVersion();
  public A withVersion(String version);
  public Boolean hasVersion();
  public A addToVolumeMounts(Integer index,VolumeMount item);
  public A setToVolumeMounts(Integer index,VolumeMount item);
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items);
  public A addAllToVolumeMounts(Collection<VolumeMount> items);
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items);
  public A removeAllFromVolumeMounts(Collection<VolumeMount> items);
  public List<VolumeMount> getVolumeMounts();
  public VolumeMount getVolumeMount(Integer index);
  public VolumeMount getFirstVolumeMount();
  public VolumeMount getLastVolumeMount();
  public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate);
  public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate);
  public A withVolumeMounts(List<VolumeMount> volumeMounts);
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts);
  public Boolean hasVolumeMounts();
  public A addToVolumes(Integer index,Volume item);
  public A setToVolumes(Integer index,Volume item);
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A addAllToVolumes(Collection<Volume> items);
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A removeAllFromVolumes(Collection<Volume> items);
  public List<Volume> getVolumes();
  public Volume getVolume(Integer index);
  public Volume getFirstVolume();
  public Volume getLastVolume();
  public Volume getMatchingVolume(Predicate<Volume> predicate);
  public Boolean hasMatchingVolume(Predicate<Volume> predicate);
  public A withVolumes(List<Volume> volumes);
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes);
  public Boolean hasVolumes();
  public Boolean getWalCompression();
  public A withWalCompression(Boolean walCompression);
  public Boolean hasWalCompression();
  
  /**
   * This method has been deprecated, please use method buildWeb instead.
   * @return The buildable object.
   */
  @Deprecated
  public WebSpec getWeb();
  public WebSpec buildWeb();
  public A withWeb(WebSpec web);
  public Boolean hasWeb();
  public PrometheusSpecFluent.WebNested<A> withNewWeb();
  public PrometheusSpecFluent.WebNested<A> withNewWebLike(WebSpec item);
  public PrometheusSpecFluent.WebNested<A> editWeb();
  public PrometheusSpecFluent.WebNested<A> editOrNewWeb();
  public PrometheusSpecFluent.WebNested<A> editOrNewWebLike(WebSpec item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withAllowOverlappingBlocks();
  public A withDisableCompaction();
  public A withEnableAdminAPI();
  public A withIgnoreNamespaceSelectors();
  public A withListenLocal();
  public A withOverrideHonorLabels();
  public A withOverrideHonorTimestamps();
  public A withPaused();
  public A withWalCompression();
  public interface AlertingNested<N> extends Nested<N>,AlertingSpecFluent<PrometheusSpecFluent.AlertingNested<N>>{
    public N and();
    public N endAlerting();
    
  }
  public interface ApiserverConfigNested<N> extends Nested<N>,APIServerConfigFluent<PrometheusSpecFluent.ApiserverConfigNested<N>>{
    public N and();
    public N endApiserverConfig();
    
  }
  public interface ArbitraryFSAccessThroughSMsNested<N> extends Nested<N>,ArbitraryFSAccessThroughSMsConfigFluent<PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<N>>{
    public N and();
    public N endArbitraryFSAccessThroughSMs();
    
  }
  public interface ContainersNested<N> extends Nested<N>,ContainerFluent<PrometheusSpecFluent.ContainersNested<N>>{
    public N and();
    public N endContainer();
    
  }
  public interface ImagePullSecretsNested<N> extends Nested<N>,LocalObjectReferenceFluent<PrometheusSpecFluent.ImagePullSecretsNested<N>>{
    public N and();
    public N endImagePullSecret();
    
  }
  public interface InitContainersNested<N> extends Nested<N>,ContainerFluent<PrometheusSpecFluent.InitContainersNested<N>>{
    public N and();
    public N endInitContainer();
    
  }
  public interface PodMetadataNested<N> extends Nested<N>,EmbeddedObjectMetadataFluent<PrometheusSpecFluent.PodMetadataNested<N>>{
    public N and();
    public N endPodMetadata();
    
  }
  public interface PodMonitorNamespaceSelectorNested<N> extends Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<N>>{
    public N and();
    public N endPodMonitorNamespaceSelector();
    
  }
  public interface PodMonitorSelectorNested<N> extends Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.PodMonitorSelectorNested<N>>{
    public N and();
    public N endPodMonitorSelector();
    
  }
  public interface ProbeNamespaceSelectorNested<N> extends Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.ProbeNamespaceSelectorNested<N>>{
    public N and();
    public N endProbeNamespaceSelector();
    
  }
  public interface ProbeSelectorNested<N> extends Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.ProbeSelectorNested<N>>{
    public N and();
    public N endProbeSelector();
    
  }
  public interface PrometheusRulesExcludedFromEnforceNested<N> extends Nested<N>,PrometheusRuleExcludeConfigFluent<PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<N>>{
    public N and();
    public N endPrometheusRulesExcludedFromEnforce();
    
  }
  public interface QueryNested<N> extends Nested<N>,QuerySpecFluent<PrometheusSpecFluent.QueryNested<N>>{
    public N and();
    public N endQuery();
    
  }
  public interface RemoteReadNested<N> extends Nested<N>,RemoteReadSpecFluent<PrometheusSpecFluent.RemoteReadNested<N>>{
    public N and();
    public N endRemoteRead();
    
  }
  public interface RemoteWriteNested<N> extends Nested<N>,RemoteWriteSpecFluent<PrometheusSpecFluent.RemoteWriteNested<N>>{
    public N and();
    public N endRemoteWrite();
    
  }
  public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<PrometheusSpecFluent.ResourcesNested<N>>{
    public N and();
    public N endResources();
    
  }
  public interface RuleNamespaceSelectorNested<N> extends Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.RuleNamespaceSelectorNested<N>>{
    public N and();
    public N endRuleNamespaceSelector();
    
  }
  public interface RuleSelectorNested<N> extends Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.RuleSelectorNested<N>>{
    public N and();
    public N endRuleSelector();
    
  }
  public interface RulesNested<N> extends Nested<N>,RulesFluent<PrometheusSpecFluent.RulesNested<N>>{
    public N and();
    public N endRules();
    
  }
  public interface ServiceMonitorNamespaceSelectorNested<N> extends Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<N>>{
    public N and();
    public N endServiceMonitorNamespaceSelector();
    
  }
  public interface ServiceMonitorSelectorNested<N> extends Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.ServiceMonitorSelectorNested<N>>{
    public N and();
    public N endServiceMonitorSelector();
    
  }
  public interface StorageNested<N> extends Nested<N>,StorageSpecFluent<PrometheusSpecFluent.StorageNested<N>>{
    public N and();
    public N endStorage();
    
  }
  public interface ThanosNested<N> extends Nested<N>,ThanosSpecFluent<PrometheusSpecFluent.ThanosNested<N>>{
    public N and();
    public N endThanos();
    
  }
  public interface WebNested<N> extends Nested<N>,WebSpecFluent<PrometheusSpecFluent.WebNested<N>>{
    public N and();
    public N endWeb();
    
  }
  
}