package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PrometheusRuleSpecFluentImpl<A extends PrometheusRuleSpecFluent<A>> extends BaseFluent<A> implements PrometheusRuleSpecFluent<A>{
  public PrometheusRuleSpecFluentImpl() {
  }
  public PrometheusRuleSpecFluentImpl(PrometheusRuleSpec instance) {
    this.withGroups(instance.getGroups()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<RuleGroupBuilder> groups = new ArrayList<RuleGroupBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToGroups(Integer index,RuleGroup item) {
    if (this.groups == null) {this.groups = new ArrayList<RuleGroupBuilder>();}
    RuleGroupBuilder builder = new RuleGroupBuilder(item);_visitables.get("groups").add(index >= 0 ? index : _visitables.get("groups").size(), builder);this.groups.add(index >= 0 ? index : groups.size(), builder); return (A)this;
  }
  public A setToGroups(Integer index,RuleGroup item) {
    if (this.groups == null) {this.groups = new ArrayList<RuleGroupBuilder>();}
    RuleGroupBuilder builder = new RuleGroupBuilder(item);
    if (index < 0 || index >= _visitables.get("groups").size()) { _visitables.get("groups").add(builder); } else { _visitables.get("groups").set(index, builder);}
    if (index < 0 || index >= groups.size()) { groups.add(builder); } else { groups.set(index, builder);}
     return (A)this;
  }
  public A addToGroups(io.fabric8.openshift.api.model.monitoring.v1.RuleGroup... items) {
    if (this.groups == null) {this.groups = new ArrayList<RuleGroupBuilder>();}
    for (RuleGroup item : items) {RuleGroupBuilder builder = new RuleGroupBuilder(item);_visitables.get("groups").add(builder);this.groups.add(builder);} return (A)this;
  }
  public A addAllToGroups(Collection<RuleGroup> items) {
    if (this.groups == null) {this.groups = new ArrayList<RuleGroupBuilder>();}
    for (RuleGroup item : items) {RuleGroupBuilder builder = new RuleGroupBuilder(item);_visitables.get("groups").add(builder);this.groups.add(builder);} return (A)this;
  }
  public A removeFromGroups(io.fabric8.openshift.api.model.monitoring.v1.RuleGroup... items) {
    for (RuleGroup item : items) {RuleGroupBuilder builder = new RuleGroupBuilder(item);_visitables.get("groups").remove(builder);if (this.groups != null) {this.groups.remove(builder);}} return (A)this;
  }
  public A removeAllFromGroups(Collection<RuleGroup> items) {
    for (RuleGroup item : items) {RuleGroupBuilder builder = new RuleGroupBuilder(item);_visitables.get("groups").remove(builder);if (this.groups != null) {this.groups.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGroups(Predicate<RuleGroupBuilder> predicate) {
    if (groups == null) return (A) this;
    final Iterator<RuleGroupBuilder> each = groups.iterator();
    final List visitables = _visitables.get("groups");
    while (each.hasNext()) {
      RuleGroupBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildGroups instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RuleGroup> getGroups() {
    return groups != null ? build(groups) : null;
  }
  public List<RuleGroup> buildGroups() {
    return groups != null ? build(groups) : null;
  }
  public RuleGroup buildGroup(Integer index) {
    return this.groups.get(index).build();
  }
  public RuleGroup buildFirstGroup() {
    return this.groups.get(0).build();
  }
  public RuleGroup buildLastGroup() {
    return this.groups.get(groups.size() - 1).build();
  }
  public RuleGroup buildMatchingGroup(Predicate<RuleGroupBuilder> predicate) {
    for (RuleGroupBuilder item: groups) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<RuleGroupBuilder> predicate) {
    for (RuleGroupBuilder item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(List<RuleGroup> groups) {
    if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
    if (groups != null) {this.groups = new ArrayList(); for (RuleGroup item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(io.fabric8.openshift.api.model.monitoring.v1.RuleGroup... groups) {
    if (this.groups != null) {this.groups.clear();}
    if (groups != null) {for (RuleGroup item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public PrometheusRuleSpecFluent.GroupsNested<A> addNewGroup() {
    return new PrometheusRuleSpecFluentImpl.GroupsNestedImpl();
  }
  public PrometheusRuleSpecFluent.GroupsNested<A> addNewGroupLike(RuleGroup item) {
    return new PrometheusRuleSpecFluentImpl.GroupsNestedImpl(-1, item);
  }
  public PrometheusRuleSpecFluent.GroupsNested<A> setNewGroupLike(Integer index,RuleGroup item) {
    return new PrometheusRuleSpecFluentImpl.GroupsNestedImpl(index, item);
  }
  public PrometheusRuleSpecFluent.GroupsNested<A> editGroup(Integer index) {
    if (groups.size() <= index) throw new RuntimeException("Can't edit groups. Index exceeds size.");
    return setNewGroupLike(index, buildGroup(index));
  }
  public PrometheusRuleSpecFluent.GroupsNested<A> editFirstGroup() {
    if (groups.size() == 0) throw new RuntimeException("Can't edit first groups. The list is empty.");
    return setNewGroupLike(0, buildGroup(0));
  }
  public PrometheusRuleSpecFluent.GroupsNested<A> editLastGroup() {
    int index = groups.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last groups. The list is empty.");
    return setNewGroupLike(index, buildGroup(index));
  }
  public PrometheusRuleSpecFluent.GroupsNested<A> editMatchingGroup(Predicate<RuleGroupBuilder> predicate) {
    int index = -1;
    for (int i=0;i<groups.size();i++) { 
    if (predicate.test(groups.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching groups. No match found.");
    return setNewGroupLike(index, buildGroup(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PrometheusRuleSpecFluentImpl that = (PrometheusRuleSpecFluentImpl) o;
    if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(groups,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class GroupsNestedImpl<N> extends RuleGroupFluentImpl<PrometheusRuleSpecFluent.GroupsNested<N>> implements PrometheusRuleSpecFluent.GroupsNested<N>,Nested<N>{
    GroupsNestedImpl(Integer index,RuleGroup item) {
      this.index = index;
      this.builder = new RuleGroupBuilder(this, item);
    }
    GroupsNestedImpl() {
      this.index = -1;
      this.builder = new RuleGroupBuilder(this);
    }
    RuleGroupBuilder builder;
    Integer index;
    public N and() {
      return (N) PrometheusRuleSpecFluentImpl.this.setToGroups(index,builder.build());
    }
    public N endGroup() {
      return and();
    }
    
  }
  
}