package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusRuleListBuilder extends PrometheusRuleListFluentImpl<PrometheusRuleListBuilder> implements VisitableBuilder<PrometheusRuleList,PrometheusRuleListBuilder>{
  public PrometheusRuleListBuilder() {
    this(false);
  }
  public PrometheusRuleListBuilder(Boolean validationEnabled) {
    this(new PrometheusRuleList(), validationEnabled);
  }
  public PrometheusRuleListBuilder(PrometheusRuleListFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusRuleListBuilder(PrometheusRuleListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrometheusRuleList(), validationEnabled);
  }
  public PrometheusRuleListBuilder(PrometheusRuleListFluent<?> fluent,PrometheusRuleList instance) {
    this(fluent, instance, false);
  }
  public PrometheusRuleListBuilder(PrometheusRuleListFluent<?> fluent,PrometheusRuleList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PrometheusRuleListBuilder(PrometheusRuleList instance) {
    this(instance,false);
  }
  public PrometheusRuleListBuilder(PrometheusRuleList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PrometheusRuleListFluent<?> fluent;
  Boolean validationEnabled;
  public PrometheusRuleList build() {
    PrometheusRuleList buildable = new PrometheusRuleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}