package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeTLSConfigBuilder extends ProbeTLSConfigFluentImpl<ProbeTLSConfigBuilder> implements VisitableBuilder<ProbeTLSConfig,ProbeTLSConfigBuilder>{
  public ProbeTLSConfigBuilder() {
    this(false);
  }
  public ProbeTLSConfigBuilder(Boolean validationEnabled) {
    this(new ProbeTLSConfig(), validationEnabled);
  }
  public ProbeTLSConfigBuilder(ProbeTLSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeTLSConfigBuilder(ProbeTLSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProbeTLSConfig(), validationEnabled);
  }
  public ProbeTLSConfigBuilder(ProbeTLSConfigFluent<?> fluent,ProbeTLSConfig instance) {
    this(fluent, instance, false);
  }
  public ProbeTLSConfigBuilder(ProbeTLSConfigFluent<?> fluent,ProbeTLSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCa(instance.getCa()); 
    fluent.withCert(instance.getCert()); 
    fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    fluent.withKeySecret(instance.getKeySecret()); 
    fluent.withServerName(instance.getServerName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProbeTLSConfigBuilder(ProbeTLSConfig instance) {
    this(instance,false);
  }
  public ProbeTLSConfigBuilder(ProbeTLSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCa(instance.getCa()); 
    this.withCert(instance.getCert()); 
    this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    this.withKeySecret(instance.getKeySecret()); 
    this.withServerName(instance.getServerName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ProbeTLSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ProbeTLSConfig build() {
    ProbeTLSConfig buildable = new ProbeTLSConfig(fluent.getCa(),fluent.getCert(),fluent.getInsecureSkipVerify(),fluent.getKeySecret(),fluent.getServerName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}