package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluentImpl;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPConfigFluentImpl<A extends HTTPConfigFluent<A>> extends BaseFluent<A> implements HTTPConfigFluent<A>{
  public HTTPConfigFluentImpl() {
  }
  public HTTPConfigFluentImpl(HTTPConfig instance) {
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    this.withProxyURL(instance.getProxyURL()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SafeAuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private SecretKeySelector bearerTokenSecret;
  private String proxyURL;
  private SafeTLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @Deprecated
  public SafeAuthorization getAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public SafeAuthorization buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(SafeAuthorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new SafeAuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} else { this.authorization = null; _visitables.get("authorization").remove(this.authorization); } return (A) this;
  }
  public Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public HTTPConfigFluent.AuthorizationNested<A> withNewAuthorization() {
    return new HTTPConfigFluentImpl.AuthorizationNestedImpl();
  }
  public HTTPConfigFluent.AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
    return new HTTPConfigFluentImpl.AuthorizationNestedImpl(item);
  }
  public HTTPConfigFluent.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public HTTPConfigFluent.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new SafeAuthorizationBuilder().build());
  }
  public HTTPConfigFluent.AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @Deprecated
  public BasicAuth getBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public BasicAuth buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(BasicAuth basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} else { this.basicAuth = null; _visitables.get("basicAuth").remove(this.basicAuth); } return (A) this;
  }
  public Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public HTTPConfigFluent.BasicAuthNested<A> withNewBasicAuth() {
    return new HTTPConfigFluentImpl.BasicAuthNestedImpl();
  }
  public HTTPConfigFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new HTTPConfigFluentImpl.BasicAuthNestedImpl(item);
  }
  public HTTPConfigFluent.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public HTTPConfigFluent.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthBuilder().build());
  }
  public HTTPConfigFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  public SecretKeySelector getBearerTokenSecret() {
    return this.bearerTokenSecret;
  }
  public A withBearerTokenSecret(SecretKeySelector bearerTokenSecret) {
    this.bearerTokenSecret=bearerTokenSecret; return (A) this;
  }
  public Boolean hasBearerTokenSecret() {
    return this.bearerTokenSecret != null;
  }
  public A withNewBearerTokenSecret(String key,String name,Boolean optional) {
    return (A)withBearerTokenSecret(new SecretKeySelector(key, name, optional));
  }
  public String getProxyURL() {
    return this.proxyURL;
  }
  public A withProxyURL(String proxyURL) {
    this.proxyURL=proxyURL; return (A) this;
  }
  public Boolean hasProxyURL() {
    return this.proxyURL != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public SafeTLSConfig getTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public SafeTLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(SafeTLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new SafeTLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} else { this.tlsConfig = null; _visitables.get("tlsConfig").remove(this.tlsConfig); } return (A) this;
  }
  public Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public HTTPConfigFluent.TlsConfigNested<A> withNewTlsConfig() {
    return new HTTPConfigFluentImpl.TlsConfigNestedImpl();
  }
  public HTTPConfigFluent.TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
    return new HTTPConfigFluentImpl.TlsConfigNestedImpl(item);
  }
  public HTTPConfigFluent.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public HTTPConfigFluent.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new SafeTLSConfigBuilder().build());
  }
  public HTTPConfigFluent.TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPConfigFluentImpl that = (HTTPConfigFluentImpl) o;
    if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
    if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
    if (bearerTokenSecret != null ? !bearerTokenSecret.equals(that.bearerTokenSecret) :that.bearerTokenSecret != null) return false;
    if (proxyURL != null ? !proxyURL.equals(that.proxyURL) :that.proxyURL != null) return false;
    if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerTokenSecret,  proxyURL,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerTokenSecret != null) { sb.append("bearerTokenSecret:"); sb.append(bearerTokenSecret + ","); }
    if (proxyURL != null) { sb.append("proxyURL:"); sb.append(proxyURL + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorizationNestedImpl<N> extends SafeAuthorizationFluentImpl<HTTPConfigFluent.AuthorizationNested<N>> implements HTTPConfigFluent.AuthorizationNested<N>,Nested<N>{
    AuthorizationNestedImpl(SafeAuthorization item) {
      this.builder = new SafeAuthorizationBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new SafeAuthorizationBuilder(this);
    }
    SafeAuthorizationBuilder builder;
    public N and() {
      return (N) HTTPConfigFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<HTTPConfigFluent.BasicAuthNested<N>> implements HTTPConfigFluent.BasicAuthNested<N>,Nested<N>{
    BasicAuthNestedImpl(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new BasicAuthBuilder(this);
    }
    BasicAuthBuilder builder;
    public N and() {
      return (N) HTTPConfigFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  class TlsConfigNestedImpl<N> extends SafeTLSConfigFluentImpl<HTTPConfigFluent.TlsConfigNested<N>> implements HTTPConfigFluent.TlsConfigNested<N>,Nested<N>{
    TlsConfigNestedImpl(SafeTLSConfig item) {
      this.builder = new SafeTLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new SafeTLSConfigBuilder(this);
    }
    SafeTLSConfigBuilder builder;
    public N and() {
      return (N) HTTPConfigFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}