package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WebTLSConfigFluentImpl<A extends WebTLSConfigFluent<A>> extends BaseFluent<A> implements WebTLSConfigFluent<A>{
  public WebTLSConfigFluentImpl() {
  }
  public WebTLSConfigFluentImpl(WebTLSConfig instance) {
    this.withCert(instance.getCert()); 
    this.withCipherSuites(instance.getCipherSuites()); 
    this.withClientAuthType(instance.getClientAuthType()); 
    this.withClientCa(instance.getClientCa()); 
    this.withCurvePreferences(instance.getCurvePreferences()); 
    this.withKeySecret(instance.getKeySecret()); 
    this.withMaxVersion(instance.getMaxVersion()); 
    this.withMinVersion(instance.getMinVersion()); 
    this.withPreferServerCipherSuites(instance.getPreferServerCipherSuites()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SecretOrConfigMapBuilder cert;
  private List<String> cipherSuites = new ArrayList<String>();
  private String clientAuthType;
  private SecretOrConfigMapBuilder clientCa;
  private List<String> curvePreferences = new ArrayList<String>();
  private SecretKeySelector keySecret;
  private String maxVersion;
  private String minVersion;
  private Boolean preferServerCipherSuites;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCert instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretOrConfigMap getCert() {
    return this.cert!=null ?this.cert.build():null;
  }
  public SecretOrConfigMap buildCert() {
    return this.cert!=null ?this.cert.build():null;
  }
  public A withCert(SecretOrConfigMap cert) {
    _visitables.get("cert").remove(this.cert);
    if (cert!=null){ this.cert= new SecretOrConfigMapBuilder(cert); _visitables.get("cert").add(this.cert);} else { this.cert = null; _visitables.get("cert").remove(this.cert); } return (A) this;
  }
  public Boolean hasCert() {
    return this.cert != null;
  }
  public WebTLSConfigFluent.CertNested<A> withNewCert() {
    return new WebTLSConfigFluentImpl.CertNestedImpl();
  }
  public WebTLSConfigFluent.CertNested<A> withNewCertLike(SecretOrConfigMap item) {
    return new WebTLSConfigFluentImpl.CertNestedImpl(item);
  }
  public WebTLSConfigFluent.CertNested<A> editCert() {
    return withNewCertLike(getCert());
  }
  public WebTLSConfigFluent.CertNested<A> editOrNewCert() {
    return withNewCertLike(getCert() != null ? getCert(): new SecretOrConfigMapBuilder().build());
  }
  public WebTLSConfigFluent.CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
    return withNewCertLike(getCert() != null ? getCert(): item);
  }
  public A addToCipherSuites(Integer index,String item) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    this.cipherSuites.add(index, item);
    return (A)this;
  }
  public A setToCipherSuites(Integer index,String item) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    this.cipherSuites.set(index, item); return (A)this;
  }
  public A addToCipherSuites(java.lang.String... items) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    for (String item : items) {this.cipherSuites.add(item);} return (A)this;
  }
  public A addAllToCipherSuites(Collection<String> items) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    for (String item : items) {this.cipherSuites.add(item);} return (A)this;
  }
  public A removeFromCipherSuites(java.lang.String... items) {
    for (String item : items) {if (this.cipherSuites!= null){ this.cipherSuites.remove(item);}} return (A)this;
  }
  public A removeAllFromCipherSuites(Collection<String> items) {
    for (String item : items) {if (this.cipherSuites!= null){ this.cipherSuites.remove(item);}} return (A)this;
  }
  public List<String> getCipherSuites() {
    return this.cipherSuites;
  }
  public String getCipherSuite(Integer index) {
    return this.cipherSuites.get(index);
  }
  public String getFirstCipherSuite() {
    return this.cipherSuites.get(0);
  }
  public String getLastCipherSuite() {
    return this.cipherSuites.get(cipherSuites.size() - 1);
  }
  public String getMatchingCipherSuite(Predicate<String> predicate) {
    for (String item: cipherSuites) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCipherSuite(Predicate<String> predicate) {
    for (String item: cipherSuites) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCipherSuites(List<String> cipherSuites) {
    if (cipherSuites != null) {this.cipherSuites = new ArrayList(); for (String item : cipherSuites){this.addToCipherSuites(item);}} else { this.cipherSuites = null;} return (A) this;
  }
  public A withCipherSuites(java.lang.String... cipherSuites) {
    if (this.cipherSuites != null) {this.cipherSuites.clear();}
    if (cipherSuites != null) {for (String item :cipherSuites){ this.addToCipherSuites(item);}} return (A) this;
  }
  public Boolean hasCipherSuites() {
    return cipherSuites != null && !cipherSuites.isEmpty();
  }
  public String getClientAuthType() {
    return this.clientAuthType;
  }
  public A withClientAuthType(String clientAuthType) {
    this.clientAuthType=clientAuthType; return (A) this;
  }
  public Boolean hasClientAuthType() {
    return this.clientAuthType != null;
  }
  
  /**
   * This method has been deprecated, please use method buildClientCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretOrConfigMap getClientCa() {
    return this.clientCa!=null ?this.clientCa.build():null;
  }
  public SecretOrConfigMap buildClientCa() {
    return this.clientCa!=null ?this.clientCa.build():null;
  }
  public A withClientCa(SecretOrConfigMap clientCa) {
    _visitables.get("clientCa").remove(this.clientCa);
    if (clientCa!=null){ this.clientCa= new SecretOrConfigMapBuilder(clientCa); _visitables.get("clientCa").add(this.clientCa);} else { this.clientCa = null; _visitables.get("clientCa").remove(this.clientCa); } return (A) this;
  }
  public Boolean hasClientCa() {
    return this.clientCa != null;
  }
  public WebTLSConfigFluent.ClientCaNested<A> withNewClientCa() {
    return new WebTLSConfigFluentImpl.ClientCaNestedImpl();
  }
  public WebTLSConfigFluent.ClientCaNested<A> withNewClientCaLike(SecretOrConfigMap item) {
    return new WebTLSConfigFluentImpl.ClientCaNestedImpl(item);
  }
  public WebTLSConfigFluent.ClientCaNested<A> editClientCa() {
    return withNewClientCaLike(getClientCa());
  }
  public WebTLSConfigFluent.ClientCaNested<A> editOrNewClientCa() {
    return withNewClientCaLike(getClientCa() != null ? getClientCa(): new SecretOrConfigMapBuilder().build());
  }
  public WebTLSConfigFluent.ClientCaNested<A> editOrNewClientCaLike(SecretOrConfigMap item) {
    return withNewClientCaLike(getClientCa() != null ? getClientCa(): item);
  }
  public A addToCurvePreferences(Integer index,String item) {
    if (this.curvePreferences == null) {this.curvePreferences = new ArrayList<String>();}
    this.curvePreferences.add(index, item);
    return (A)this;
  }
  public A setToCurvePreferences(Integer index,String item) {
    if (this.curvePreferences == null) {this.curvePreferences = new ArrayList<String>();}
    this.curvePreferences.set(index, item); return (A)this;
  }
  public A addToCurvePreferences(java.lang.String... items) {
    if (this.curvePreferences == null) {this.curvePreferences = new ArrayList<String>();}
    for (String item : items) {this.curvePreferences.add(item);} return (A)this;
  }
  public A addAllToCurvePreferences(Collection<String> items) {
    if (this.curvePreferences == null) {this.curvePreferences = new ArrayList<String>();}
    for (String item : items) {this.curvePreferences.add(item);} return (A)this;
  }
  public A removeFromCurvePreferences(java.lang.String... items) {
    for (String item : items) {if (this.curvePreferences!= null){ this.curvePreferences.remove(item);}} return (A)this;
  }
  public A removeAllFromCurvePreferences(Collection<String> items) {
    for (String item : items) {if (this.curvePreferences!= null){ this.curvePreferences.remove(item);}} return (A)this;
  }
  public List<String> getCurvePreferences() {
    return this.curvePreferences;
  }
  public String getCurvePreference(Integer index) {
    return this.curvePreferences.get(index);
  }
  public String getFirstCurvePreference() {
    return this.curvePreferences.get(0);
  }
  public String getLastCurvePreference() {
    return this.curvePreferences.get(curvePreferences.size() - 1);
  }
  public String getMatchingCurvePreference(Predicate<String> predicate) {
    for (String item: curvePreferences) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCurvePreference(Predicate<String> predicate) {
    for (String item: curvePreferences) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCurvePreferences(List<String> curvePreferences) {
    if (curvePreferences != null) {this.curvePreferences = new ArrayList(); for (String item : curvePreferences){this.addToCurvePreferences(item);}} else { this.curvePreferences = null;} return (A) this;
  }
  public A withCurvePreferences(java.lang.String... curvePreferences) {
    if (this.curvePreferences != null) {this.curvePreferences.clear();}
    if (curvePreferences != null) {for (String item :curvePreferences){ this.addToCurvePreferences(item);}} return (A) this;
  }
  public Boolean hasCurvePreferences() {
    return curvePreferences != null && !curvePreferences.isEmpty();
  }
  public SecretKeySelector getKeySecret() {
    return this.keySecret;
  }
  public A withKeySecret(SecretKeySelector keySecret) {
    this.keySecret=keySecret; return (A) this;
  }
  public Boolean hasKeySecret() {
    return this.keySecret != null;
  }
  public A withNewKeySecret(String key,String name,Boolean optional) {
    return (A)withKeySecret(new SecretKeySelector(key, name, optional));
  }
  public String getMaxVersion() {
    return this.maxVersion;
  }
  public A withMaxVersion(String maxVersion) {
    this.maxVersion=maxVersion; return (A) this;
  }
  public Boolean hasMaxVersion() {
    return this.maxVersion != null;
  }
  public String getMinVersion() {
    return this.minVersion;
  }
  public A withMinVersion(String minVersion) {
    this.minVersion=minVersion; return (A) this;
  }
  public Boolean hasMinVersion() {
    return this.minVersion != null;
  }
  public Boolean getPreferServerCipherSuites() {
    return this.preferServerCipherSuites;
  }
  public A withPreferServerCipherSuites(Boolean preferServerCipherSuites) {
    this.preferServerCipherSuites=preferServerCipherSuites; return (A) this;
  }
  public Boolean hasPreferServerCipherSuites() {
    return this.preferServerCipherSuites != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebTLSConfigFluentImpl that = (WebTLSConfigFluentImpl) o;
    if (cert != null ? !cert.equals(that.cert) :that.cert != null) return false;
    if (cipherSuites != null ? !cipherSuites.equals(that.cipherSuites) :that.cipherSuites != null) return false;
    if (clientAuthType != null ? !clientAuthType.equals(that.clientAuthType) :that.clientAuthType != null) return false;
    if (clientCa != null ? !clientCa.equals(that.clientCa) :that.clientCa != null) return false;
    if (curvePreferences != null ? !curvePreferences.equals(that.curvePreferences) :that.curvePreferences != null) return false;
    if (keySecret != null ? !keySecret.equals(that.keySecret) :that.keySecret != null) return false;
    if (maxVersion != null ? !maxVersion.equals(that.maxVersion) :that.maxVersion != null) return false;
    if (minVersion != null ? !minVersion.equals(that.minVersion) :that.minVersion != null) return false;
    if (preferServerCipherSuites != null ? !preferServerCipherSuites.equals(that.preferServerCipherSuites) :that.preferServerCipherSuites != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cert,  cipherSuites,  clientAuthType,  clientCa,  curvePreferences,  keySecret,  maxVersion,  minVersion,  preferServerCipherSuites,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cert != null) { sb.append("cert:"); sb.append(cert + ","); }
    if (cipherSuites != null && !cipherSuites.isEmpty()) { sb.append("cipherSuites:"); sb.append(cipherSuites + ","); }
    if (clientAuthType != null) { sb.append("clientAuthType:"); sb.append(clientAuthType + ","); }
    if (clientCa != null) { sb.append("clientCa:"); sb.append(clientCa + ","); }
    if (curvePreferences != null && !curvePreferences.isEmpty()) { sb.append("curvePreferences:"); sb.append(curvePreferences + ","); }
    if (keySecret != null) { sb.append("keySecret:"); sb.append(keySecret + ","); }
    if (maxVersion != null) { sb.append("maxVersion:"); sb.append(maxVersion + ","); }
    if (minVersion != null) { sb.append("minVersion:"); sb.append(minVersion + ","); }
    if (preferServerCipherSuites != null) { sb.append("preferServerCipherSuites:"); sb.append(preferServerCipherSuites + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withPreferServerCipherSuites() {
    return withPreferServerCipherSuites(true);
  }
  class CertNestedImpl<N> extends SecretOrConfigMapFluentImpl<WebTLSConfigFluent.CertNested<N>> implements WebTLSConfigFluent.CertNested<N>,Nested<N>{
    CertNestedImpl(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    CertNestedImpl() {
      this.builder = new SecretOrConfigMapBuilder(this);
    }
    SecretOrConfigMapBuilder builder;
    public N and() {
      return (N) WebTLSConfigFluentImpl.this.withCert(builder.build());
    }
    public N endCert() {
      return and();
    }
    
  }
  class ClientCaNestedImpl<N> extends SecretOrConfigMapFluentImpl<WebTLSConfigFluent.ClientCaNested<N>> implements WebTLSConfigFluent.ClientCaNested<N>,Nested<N>{
    ClientCaNestedImpl(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    ClientCaNestedImpl() {
      this.builder = new SecretOrConfigMapBuilder(this);
    }
    SecretOrConfigMapBuilder builder;
    public N and() {
      return (N) WebTLSConfigFluentImpl.this.withClientCa(builder.build());
    }
    public N endClientCa() {
      return and();
    }
    
  }
  
}