package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceMonitorSpecBuilder extends ServiceMonitorSpecFluentImpl<ServiceMonitorSpecBuilder> implements VisitableBuilder<ServiceMonitorSpec,ServiceMonitorSpecBuilder>{
  public ServiceMonitorSpecBuilder() {
    this(false);
  }
  public ServiceMonitorSpecBuilder(Boolean validationEnabled) {
    this(new ServiceMonitorSpec(), validationEnabled);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceMonitorSpec(), validationEnabled);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,ServiceMonitorSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,ServiceMonitorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEndpoints(instance.getEndpoints()); 
    fluent.withJobLabel(instance.getJobLabel()); 
    fluent.withLabelLimit(instance.getLabelLimit()); 
    fluent.withLabelNameLengthLimit(instance.getLabelNameLengthLimit()); 
    fluent.withLabelValueLengthLimit(instance.getLabelValueLengthLimit()); 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    fluent.withPodTargetLabels(instance.getPodTargetLabels()); 
    fluent.withSampleLimit(instance.getSampleLimit()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTargetLabels(instance.getTargetLabels()); 
    fluent.withTargetLimit(instance.getTargetLimit()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance) {
    this(instance,false);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEndpoints(instance.getEndpoints()); 
    this.withJobLabel(instance.getJobLabel()); 
    this.withLabelLimit(instance.getLabelLimit()); 
    this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit()); 
    this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withPodTargetLabels(instance.getPodTargetLabels()); 
    this.withSampleLimit(instance.getSampleLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withTargetLabels(instance.getTargetLabels()); 
    this.withTargetLimit(instance.getTargetLimit()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceMonitorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceMonitorSpec build() {
    ServiceMonitorSpec buildable = new ServiceMonitorSpec(fluent.getEndpoints(),fluent.getJobLabel(),fluent.getLabelLimit(),fluent.getLabelNameLengthLimit(),fluent.getLabelValueLengthLimit(),fluent.getNamespaceSelector(),fluent.getPodTargetLabels(),fluent.getSampleLimit(),fluent.getSelector(),fluent.getTargetLabels(),fluent.getTargetLimit());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}