/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.PagerDutyConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.PagerDutyConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PagerDutyConfigFluentImpl<A extends PagerDutyConfigFluent<A>>
extends BaseFluent<A>
implements PagerDutyConfigFluent<A> {
    private String className;
    private String client;
    private String clientURL;
    private String component;
    private String description;
    private ArrayList<KeyValueBuilder> details = new ArrayList();
    private String group;
    private HTTPConfigBuilder httpConfig;
    private SecretKeySelector routingKey;
    private Boolean sendResolved;
    private SecretKeySelector serviceKey;
    private String severity;
    private String url;
    private Map<String, Object> additionalProperties;

    public PagerDutyConfigFluentImpl() {
    }

    public PagerDutyConfigFluentImpl(PagerDutyConfig instance) {
        this.withClassName(instance.getClassName());
        this.withClient(instance.getClient());
        this.withClientURL(instance.getClientURL());
        this.withComponent(instance.getComponent());
        this.withDescription(instance.getDescription());
        this.withDetails(instance.getDetails());
        this.withGroup(instance.getGroup());
        this.withHttpConfig(instance.getHttpConfig());
        this.withRoutingKey(instance.getRoutingKey());
        this.withSendResolved(instance.getSendResolved());
        this.withServiceKey(instance.getServiceKey());
        this.withSeverity(instance.getSeverity());
        this.withUrl(instance.getUrl());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public A withClassName(String className) {
        this.className = className;
        return (A)this;
    }

    @Override
    public Boolean hasClassName() {
        return this.className != null;
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public A withClient(String client) {
        this.client = client;
        return (A)this;
    }

    @Override
    public Boolean hasClient() {
        return this.client != null;
    }

    @Override
    public String getClientURL() {
        return this.clientURL;
    }

    @Override
    public A withClientURL(String clientURL) {
        this.clientURL = clientURL;
        return (A)this;
    }

    @Override
    public Boolean hasClientURL() {
        return this.clientURL != null;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public A withComponent(String component) {
        this.component = component;
        return (A)this;
    }

    @Override
    public Boolean hasComponent() {
        return this.component != null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    public A addToDetails(Integer index, KeyValue item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        this._visitables.get((Object)"details").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"details").size(), builder);
        this.details.add(index >= 0 ? index.intValue() : this.details.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDetails(Integer index, KeyValue item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"details").size()) {
            this._visitables.get((Object)"details").add(builder);
        } else {
            this._visitables.get((Object)"details").set(index, builder);
        }
        if (index < 0 || index >= this.details.size()) {
            this.details.add(builder);
        } else {
            this.details.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDetails(KeyValue ... items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDetails(Collection<KeyValue> items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDetails(KeyValue ... items) {
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").remove(builder);
            if (this.details == null) continue;
            this.details.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDetails(Collection<KeyValue> items) {
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").remove(builder);
            if (this.details == null) continue;
            this.details.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDetails(Predicate<KeyValueBuilder> predicate) {
        if (this.details == null) {
            return (A)this;
        }
        Iterator<KeyValueBuilder> each = this.details.iterator();
        List visitables = this._visitables.get((Object)"details");
        while (each.hasNext()) {
            KeyValueBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KeyValue> getDetails() {
        return this.details != null ? PagerDutyConfigFluentImpl.build(this.details) : null;
    }

    @Override
    public List<KeyValue> buildDetails() {
        return this.details != null ? PagerDutyConfigFluentImpl.build(this.details) : null;
    }

    @Override
    public KeyValue buildDetail(Integer index) {
        return this.details.get(index).build();
    }

    @Override
    public KeyValue buildFirstDetail() {
        return this.details.get(0).build();
    }

    @Override
    public KeyValue buildLastDetail() {
        return this.details.get(this.details.size() - 1).build();
    }

    @Override
    public KeyValue buildMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDetails(List<KeyValue> details) {
        if (this.details != null) {
            this._visitables.get((Object)"details").removeAll(this.details);
        }
        if (details != null) {
            this.details = new ArrayList();
            for (KeyValue item : details) {
                this.addToDetails(item);
            }
        } else {
            this.details = null;
        }
        return (A)this;
    }

    @Override
    public A withDetails(KeyValue ... details) {
        if (this.details != null) {
            this.details.clear();
        }
        if (details != null) {
            for (KeyValue item : details) {
                this.addToDetails(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    @Override
    public A addNewDetail(String key, String value) {
        return this.addToDetails(new KeyValue(key, value));
    }

    @Override
    public PagerDutyConfigFluent.DetailsNested<A> addNewDetail() {
        return new DetailsNestedImpl();
    }

    @Override
    public PagerDutyConfigFluent.DetailsNested<A> addNewDetailLike(KeyValue item) {
        return new DetailsNestedImpl(-1, item);
    }

    @Override
    public PagerDutyConfigFluent.DetailsNested<A> setNewDetailLike(Integer index, KeyValue item) {
        return new DetailsNestedImpl(index, item);
    }

    @Override
    public PagerDutyConfigFluent.DetailsNested<A> editDetail(Integer index) {
        if (this.details.size() <= index) {
            throw new RuntimeException("Can't edit details. Index exceeds size.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    @Override
    public PagerDutyConfigFluent.DetailsNested<A> editFirstDetail() {
        if (this.details.size() == 0) {
            throw new RuntimeException("Can't edit first details. The list is empty.");
        }
        return this.setNewDetailLike(0, this.buildDetail(0));
    }

    @Override
    public PagerDutyConfigFluent.DetailsNested<A> editLastDetail() {
        int index = this.details.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last details. The list is empty.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    @Override
    public PagerDutyConfigFluent.DetailsNested<A> editMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.details.size(); ++i) {
            if (!predicate.test(this.details.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching details. No match found.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    @Deprecated
    public HTTPConfig getHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    @Override
    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    @Override
    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.get((Object)"httpConfig").remove(this.httpConfig);
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get((Object)"httpConfig").add(this.httpConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    @Override
    public PagerDutyConfigFluent.HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNestedImpl();
    }

    @Override
    public PagerDutyConfigFluent.HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNestedImpl(item);
    }

    @Override
    public PagerDutyConfigFluent.HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(this.getHttpConfig());
    }

    @Override
    public PagerDutyConfigFluent.HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(this.getHttpConfig() != null ? this.getHttpConfig() : new HTTPConfigBuilder().build());
    }

    @Override
    public PagerDutyConfigFluent.HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(this.getHttpConfig() != null ? this.getHttpConfig() : item);
    }

    @Override
    public SecretKeySelector getRoutingKey() {
        return this.routingKey;
    }

    @Override
    public A withRoutingKey(SecretKeySelector routingKey) {
        this.routingKey = routingKey;
        return (A)this;
    }

    @Override
    public Boolean hasRoutingKey() {
        return this.routingKey != null;
    }

    @Override
    public A withNewRoutingKey(String key, String name, Boolean optional) {
        return this.withRoutingKey(new SecretKeySelector(key, name, optional));
    }

    @Override
    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    @Override
    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)this;
    }

    @Override
    public Boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    @Override
    public SecretKeySelector getServiceKey() {
        return this.serviceKey;
    }

    @Override
    public A withServiceKey(SecretKeySelector serviceKey) {
        this.serviceKey = serviceKey;
        return (A)this;
    }

    @Override
    public Boolean hasServiceKey() {
        return this.serviceKey != null;
    }

    @Override
    public A withNewServiceKey(String key, String name, Boolean optional) {
        return this.withServiceKey(new SecretKeySelector(key, name, optional));
    }

    @Override
    public String getSeverity() {
        return this.severity;
    }

    @Override
    public A withSeverity(String severity) {
        this.severity = severity;
        return (A)this;
    }

    @Override
    public Boolean hasSeverity() {
        return this.severity != null;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagerDutyConfigFluentImpl that = (PagerDutyConfigFluentImpl)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.client != null ? !this.client.equals(that.client) : that.client != null) {
            return false;
        }
        if (this.clientURL != null ? !this.clientURL.equals(that.clientURL) : that.clientURL != null) {
            return false;
        }
        if (this.component != null ? !this.component.equals(that.component) : that.component != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.httpConfig != null ? !this.httpConfig.equals(that.httpConfig) : that.httpConfig != null) {
            return false;
        }
        if (this.routingKey != null ? !this.routingKey.equals((Object)that.routingKey) : that.routingKey != null) {
            return false;
        }
        if (this.sendResolved != null ? !this.sendResolved.equals(that.sendResolved) : that.sendResolved != null) {
            return false;
        }
        if (this.serviceKey != null ? !this.serviceKey.equals((Object)that.serviceKey) : that.serviceKey != null) {
            return false;
        }
        if (this.severity != null ? !this.severity.equals(that.severity) : that.severity != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.client, this.clientURL, this.component, this.description, this.details, this.group, this.httpConfig, this.routingKey, this.sendResolved, this.serviceKey, this.severity, this.url, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.className != null) {
            sb.append("className:");
            sb.append(this.className + ",");
        }
        if (this.client != null) {
            sb.append("client:");
            sb.append(this.client + ",");
        }
        if (this.clientURL != null) {
            sb.append("clientURL:");
            sb.append(this.clientURL + ",");
        }
        if (this.component != null) {
            sb.append("component:");
            sb.append(this.component + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.details != null && !this.details.isEmpty()) {
            sb.append("details:");
            sb.append(this.details + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(this.httpConfig + ",");
        }
        if (this.routingKey != null) {
            sb.append("routingKey:");
            sb.append(this.routingKey + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.serviceKey != null) {
            sb.append("serviceKey:");
            sb.append(this.serviceKey + ",");
        }
        if (this.severity != null) {
            sb.append("severity:");
            sb.append(this.severity + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    class HttpConfigNestedImpl<N>
    extends HTTPConfigFluentImpl<PagerDutyConfigFluent.HttpConfigNested<N>>
    implements PagerDutyConfigFluent.HttpConfigNested<N>,
    Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNestedImpl(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        HttpConfigNestedImpl() {
            this.builder = new HTTPConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)PagerDutyConfigFluentImpl.this.withHttpConfig(this.builder.build());
        }

        @Override
        public N endHttpConfig() {
            return this.and();
        }
    }

    class DetailsNestedImpl<N>
    extends KeyValueFluentImpl<PagerDutyConfigFluent.DetailsNested<N>>
    implements PagerDutyConfigFluent.DetailsNested<N>,
    Nested<N> {
        KeyValueBuilder builder;
        Integer index;

        DetailsNestedImpl(Integer index, KeyValue item) {
            this.index = index;
            this.builder = new KeyValueBuilder(this, item);
        }

        DetailsNestedImpl() {
            this.index = -1;
            this.builder = new KeyValueBuilder(this);
        }

        @Override
        public N and() {
            return (N)PagerDutyConfigFluentImpl.this.setToDetails(this.index, this.builder.build());
        }

        @Override
        public N endDetail() {
            return this.and();
        }
    }
}

