package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebhookConfigBuilder extends WebhookConfigFluentImpl<WebhookConfigBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig,io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfigBuilder>{
  public WebhookConfigBuilder() {
    this(false);
  }
  public WebhookConfigBuilder(Boolean validationEnabled) {
    this(new WebhookConfig(), validationEnabled);
  }
  public WebhookConfigBuilder(WebhookConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public WebhookConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new WebhookConfig(), validationEnabled);
  }
  public WebhookConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig instance) {
    this(fluent, instance, false);
  }
  public WebhookConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHttpConfig(instance.getHttpConfig()); 
    fluent.withMaxAlerts(instance.getMaxAlerts()); 
    fluent.withSendResolved(instance.getSendResolved()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withUrlSecret(instance.getUrlSecret()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public WebhookConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig instance) {
    this(instance,false);
  }
  public WebhookConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHttpConfig(instance.getHttpConfig()); 
    this.withMaxAlerts(instance.getMaxAlerts()); 
    this.withSendResolved(instance.getSendResolved()); 
    this.withUrl(instance.getUrl()); 
    this.withUrlSecret(instance.getUrlSecret()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig build() {
    WebhookConfig buildable = new WebhookConfig(fluent.getHttpConfig(),fluent.getMaxAlerts(),fluent.getSendResolved(),fluent.getUrl(),fluent.getUrlSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}