package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OpsGenieConfigFluentImpl<A extends OpsGenieConfigFluent<A>> extends BaseFluent<A> implements OpsGenieConfigFluent<A>{
  public OpsGenieConfigFluentImpl() {
  }
  public OpsGenieConfigFluentImpl(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfig instance) {
    this.withApiKey(instance.getApiKey()); 
    this.withApiURL(instance.getApiURL()); 
    this.withDescription(instance.getDescription()); 
    this.withDetails(instance.getDetails()); 
    this.withHttpConfig(instance.getHttpConfig()); 
    this.withMessage(instance.getMessage()); 
    this.withNote(instance.getNote()); 
    this.withPriority(instance.getPriority()); 
    this.withResponders(instance.getResponders()); 
    this.withSendResolved(instance.getSendResolved()); 
    this.withSource(instance.getSource()); 
    this.withTags(instance.getTags()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SecretKeySelector apiKey;
  private String apiURL;
  private java.lang.String description;
  private ArrayList<KeyValueBuilder> details = new java.util.ArrayList<KeyValueBuilder>();
  private HTTPConfigBuilder httpConfig;
  private java.lang.String message;
  private java.lang.String note;
  private java.lang.String priority;
  private java.util.ArrayList<OpsGenieConfigResponderBuilder> responders = new java.util.ArrayList<OpsGenieConfigResponderBuilder>();
  private Boolean sendResolved;
  private java.lang.String source;
  private java.lang.String tags;
  private Map<java.lang.String,Object> additionalProperties;
  public io.fabric8.kubernetes.api.model.SecretKeySelector getApiKey() {
    return this.apiKey;
  }
  public A withApiKey(io.fabric8.kubernetes.api.model.SecretKeySelector apiKey) {
    this.apiKey=apiKey; return (A) this;
  }
  public java.lang.Boolean hasApiKey() {
    return this.apiKey != null;
  }
  public A withNewApiKey(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
    return (A)withApiKey(new SecretKeySelector(key, name, optional));
  }
  public java.lang.String getApiURL() {
    return this.apiURL;
  }
  public A withApiURL(java.lang.String apiURL) {
    this.apiURL=apiURL; return (A) this;
  }
  public java.lang.Boolean hasApiURL() {
    return this.apiURL != null;
  }
  public java.lang.String getDescription() {
    return this.description;
  }
  public A withDescription(java.lang.String description) {
    this.description=description; return (A) this;
  }
  public java.lang.Boolean hasDescription() {
    return this.description != null;
  }
  public A addToDetails(Integer index,io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item) {
    if (this.details == null) {this.details = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);_visitables.get("details").add(index >= 0 ? index : _visitables.get("details").size(), builder);this.details.add(index >= 0 ? index : details.size(), builder); return (A)this;
  }
  public A setToDetails(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item) {
    if (this.details == null) {this.details = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);
    if (index < 0 || index >= _visitables.get("details").size()) { _visitables.get("details").add(builder); } else { _visitables.get("details").set(index, builder);}
    if (index < 0 || index >= details.size()) { details.add(builder); } else { details.set(index, builder);}
     return (A)this;
  }
  public A addToDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    if (this.details == null) {this.details = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  public A addAllToDetails(Collection<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue> items) {
    if (this.details == null) {this.details = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  public A removeFromDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);_visitables.get("details").remove(builder);if (this.details != null) {this.details.remove(builder);}} return (A)this;
  }
  public A removeAllFromDetails(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue> items) {
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);_visitables.get("details").remove(builder);if (this.details != null) {this.details.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDetails(Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> predicate) {
    if (details == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> each = details.iterator();
    final List visitables = _visitables.get("details");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDetails instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue> getDetails() {
    return details != null ? build(details) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue> buildDetails() {
    return details != null ? build(details) : null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue buildDetail(java.lang.Integer index) {
    return this.details.get(index).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue buildFirstDetail() {
    return this.details.get(0).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue buildLastDetail() {
    return this.details.get(details.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue buildMatchingDetail(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder item: details) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingDetail(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder item: details) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDetails(java.util.List<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue> details) {
    if (this.details != null) { _visitables.get("details").removeAll(this.details);}
    if (details != null) {this.details = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item : details){this.addToDetails(item);}} else { this.details = null;} return (A) this;
  }
  public A withDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... details) {
    if (this.details != null) {this.details.clear();}
    if (details != null) {for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item :details){ this.addToDetails(item);}} return (A) this;
  }
  public java.lang.Boolean hasDetails() {
    return details != null && !details.isEmpty();
  }
  public A addNewDetail(java.lang.String key,java.lang.String value) {
    return (A)addToDetails(new KeyValue(key, value));
  }
  public OpsGenieConfigFluent.DetailsNested<A> addNewDetail() {
    return new OpsGenieConfigFluentImpl.DetailsNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.DetailsNested<A> addNewDetailLike(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item) {
    return new OpsGenieConfigFluentImpl.DetailsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.DetailsNested<A> setNewDetailLike(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item) {
    return new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluentImpl.DetailsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.DetailsNested<A> editDetail(java.lang.Integer index) {
    if (details.size() <= index) throw new RuntimeException("Can't edit details. Index exceeds size.");
    return setNewDetailLike(index, buildDetail(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.DetailsNested<A> editFirstDetail() {
    if (details.size() == 0) throw new RuntimeException("Can't edit first details. The list is empty.");
    return setNewDetailLike(0, buildDetail(0));
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.DetailsNested<A> editLastDetail() {
    int index = details.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last details. The list is empty.");
    return setNewDetailLike(index, buildDetail(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.DetailsNested<A> editMatchingDetail(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> predicate) {
    int index = -1;
    for (int i=0;i<details.size();i++) { 
    if (predicate.test(details.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching details. No match found.");
    return setNewDetailLike(index, buildDetail(index));
  }
  
  /**
   * This method has been deprecated, please use method buildHttpConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public HTTPConfig getHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig buildHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public A withHttpConfig(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig httpConfig) {
    _visitables.get("httpConfig").remove(this.httpConfig);
    if (httpConfig!=null){ this.httpConfig= new io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder(httpConfig); _visitables.get("httpConfig").add(this.httpConfig);} return (A) this;
  }
  public java.lang.Boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  public OpsGenieConfigFluent.HttpConfigNested<A> withNewHttpConfig() {
    return new OpsGenieConfigFluentImpl.HttpConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.HttpConfigNested<A> withNewHttpConfigLike(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluentImpl.HttpConfigNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig());
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): new io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.HttpConfigNested<A> editOrNewHttpConfigLike(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig item) {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): item);
  }
  public java.lang.String getMessage() {
    return this.message;
  }
  public A withMessage(java.lang.String message) {
    this.message=message; return (A) this;
  }
  public java.lang.Boolean hasMessage() {
    return this.message != null;
  }
  public java.lang.String getNote() {
    return this.note;
  }
  public A withNote(java.lang.String note) {
    this.note=note; return (A) this;
  }
  public java.lang.Boolean hasNote() {
    return this.note != null;
  }
  public java.lang.String getPriority() {
    return this.priority;
  }
  public A withPriority(java.lang.String priority) {
    this.priority=priority; return (A) this;
  }
  public java.lang.Boolean hasPriority() {
    return this.priority != null;
  }
  public A addToResponders(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder item) {
    if (this.responders == null) {this.responders = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder(item);_visitables.get("responders").add(index >= 0 ? index : _visitables.get("responders").size(), builder);this.responders.add(index >= 0 ? index : responders.size(), builder); return (A)this;
  }
  public A setToResponders(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder item) {
    if (this.responders == null) {this.responders = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder(item);
    if (index < 0 || index >= _visitables.get("responders").size()) { _visitables.get("responders").add(builder); } else { _visitables.get("responders").set(index, builder);}
    if (index < 0 || index >= responders.size()) { responders.add(builder); } else { responders.set(index, builder);}
     return (A)this;
  }
  public A addToResponders(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder... items) {
    if (this.responders == null) {this.responders = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder(item);_visitables.get("responders").add(builder);this.responders.add(builder);} return (A)this;
  }
  public A addAllToResponders(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder> items) {
    if (this.responders == null) {this.responders = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder(item);_visitables.get("responders").add(builder);this.responders.add(builder);} return (A)this;
  }
  public A removeFromResponders(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder... items) {
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder(item);_visitables.get("responders").remove(builder);if (this.responders != null) {this.responders.remove(builder);}} return (A)this;
  }
  public A removeAllFromResponders(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder> items) {
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder(item);_visitables.get("responders").remove(builder);if (this.responders != null) {this.responders.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResponders(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder> predicate) {
    if (responders == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder> each = responders.iterator();
    final List visitables = _visitables.get("responders");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResponders instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder> getResponders() {
    return responders != null ? build(responders) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder> buildResponders() {
    return responders != null ? build(responders) : null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder buildResponder(java.lang.Integer index) {
    return this.responders.get(index).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder buildFirstResponder() {
    return this.responders.get(0).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder buildLastResponder() {
    return this.responders.get(responders.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder buildMatchingResponder(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder item: responders) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingResponder(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder item: responders) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResponders(java.util.List<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder> responders) {
    if (this.responders != null) { _visitables.get("responders").removeAll(this.responders);}
    if (responders != null) {this.responders = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder item : responders){this.addToResponders(item);}} else { this.responders = null;} return (A) this;
  }
  public A withResponders(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder... responders) {
    if (this.responders != null) {this.responders.clear();}
    if (responders != null) {for (io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder item :responders){ this.addToResponders(item);}} return (A) this;
  }
  public java.lang.Boolean hasResponders() {
    return responders != null && !responders.isEmpty();
  }
  public A addNewResponder(java.lang.String id,java.lang.String name,java.lang.String type,java.lang.String username) {
    return (A)addToResponders(new OpsGenieConfigResponder(id, name, type, username));
  }
  public OpsGenieConfigFluent.RespondersNested<A> addNewResponder() {
    return new OpsGenieConfigFluentImpl.RespondersNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.RespondersNested<A> addNewResponderLike(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder item) {
    return new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluentImpl.RespondersNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.RespondersNested<A> setNewResponderLike(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder item) {
    return new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluentImpl.RespondersNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.RespondersNested<A> editResponder(java.lang.Integer index) {
    if (responders.size() <= index) throw new RuntimeException("Can't edit responders. Index exceeds size.");
    return setNewResponderLike(index, buildResponder(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.RespondersNested<A> editFirstResponder() {
    if (responders.size() == 0) throw new RuntimeException("Can't edit first responders. The list is empty.");
    return setNewResponderLike(0, buildResponder(0));
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.RespondersNested<A> editLastResponder() {
    int index = responders.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last responders. The list is empty.");
    return setNewResponderLike(index, buildResponder(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.RespondersNested<A> editMatchingResponder(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<responders.size();i++) { 
    if (predicate.test(responders.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching responders. No match found.");
    return setNewResponderLike(index, buildResponder(index));
  }
  public java.lang.Boolean getSendResolved() {
    return this.sendResolved;
  }
  public A withSendResolved(java.lang.Boolean sendResolved) {
    this.sendResolved=sendResolved; return (A) this;
  }
  public java.lang.Boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  public java.lang.String getSource() {
    return this.source;
  }
  public A withSource(java.lang.String source) {
    this.source=source; return (A) this;
  }
  public java.lang.Boolean hasSource() {
    return this.source != null;
  }
  public java.lang.String getTags() {
    return this.tags;
  }
  public A withTags(java.lang.String tags) {
    this.tags=tags; return (A) this;
  }
  public java.lang.Boolean hasTags() {
    return this.tags != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpsGenieConfigFluentImpl that = (OpsGenieConfigFluentImpl) o;
    if (apiKey != null ? !apiKey.equals(that.apiKey) :that.apiKey != null) return false;
    if (apiURL != null ? !apiURL.equals(that.apiURL) :that.apiURL != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (details != null ? !details.equals(that.details) :that.details != null) return false;
    if (httpConfig != null ? !httpConfig.equals(that.httpConfig) :that.httpConfig != null) return false;
    if (message != null ? !message.equals(that.message) :that.message != null) return false;
    if (note != null ? !note.equals(that.note) :that.note != null) return false;
    if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
    if (responders != null ? !responders.equals(that.responders) :that.responders != null) return false;
    if (sendResolved != null ? !sendResolved.equals(that.sendResolved) :that.sendResolved != null) return false;
    if (source != null ? !source.equals(that.source) :that.source != null) return false;
    if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiKey,  apiURL,  description,  details,  httpConfig,  message,  note,  priority,  responders,  sendResolved,  source,  tags,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiKey != null) { sb.append("apiKey:"); sb.append(apiKey + ","); }
    if (apiURL != null) { sb.append("apiURL:"); sb.append(apiURL + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (details != null && !details.isEmpty()) { sb.append("details:"); sb.append(details + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (note != null) { sb.append("note:"); sb.append(note + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (responders != null && !responders.isEmpty()) { sb.append("responders:"); sb.append(responders + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (tags != null) { sb.append("tags:"); sb.append(tags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withSendResolved() {
    return withSendResolved(true);
  }
  class DetailsNestedImpl<N> extends KeyValueFluentImpl<OpsGenieConfigFluent.DetailsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.DetailsNested<N>,Nested<N>{
    DetailsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item) {
      this.index = index;
      this.builder = new KeyValueBuilder(this, item);
    }
    DetailsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) OpsGenieConfigFluentImpl.this.setToDetails(index,builder.build());
    }
    public N endDetail() {
      return and();
    }
    
  }
  class HttpConfigNestedImpl<N> extends HTTPConfigFluentImpl<OpsGenieConfigFluent.HttpConfigNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.HttpConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HttpConfigNestedImpl(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HttpConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder builder;
    public N and() {
      return (N) OpsGenieConfigFluentImpl.this.withHttpConfig(builder.build());
    }
    public N endHttpConfig() {
      return and();
    }
    
  }
  class RespondersNestedImpl<N> extends OpsGenieConfigResponderFluentImpl<OpsGenieConfigFluent.RespondersNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent.RespondersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RespondersNestedImpl(java.lang.Integer index,OpsGenieConfigResponder item) {
      this.index = index;
      this.builder = new OpsGenieConfigResponderBuilder(this, item);
    }
    RespondersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) OpsGenieConfigFluentImpl.this.setToResponders(index,builder.build());
    }
    public N endResponder() {
      return and();
    }
    
  }
  
}