package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MatcherBuilder extends MatcherFluentImpl<MatcherBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher,io.fabric8.openshift.api.model.monitoring.v1alpha1.MatcherBuilder>{
  public MatcherBuilder() {
    this(false);
  }
  public MatcherBuilder(Boolean validationEnabled) {
    this(new Matcher(), validationEnabled);
  }
  public MatcherBuilder(MatcherFluent<?> fluent) {
    this(fluent, false);
  }
  public MatcherBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.MatcherFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Matcher(), validationEnabled);
  }
  public MatcherBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.MatcherFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher instance) {
    this(fluent, instance, false);
  }
  public MatcherBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.MatcherFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withRegex(instance.getRegex()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MatcherBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher instance) {
    this(instance,false);
  }
  public MatcherBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withRegex(instance.getRegex()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1alpha1.MatcherFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher build() {
    Matcher buildable = new Matcher(fluent.getName(),fluent.getRegex(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}