package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluentImpl;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPConfigFluentImpl<A extends HTTPConfigFluent<A>> extends BaseFluent<A> implements HTTPConfigFluent<A>{
  public HTTPConfigFluentImpl() {
  }
  public HTTPConfigFluentImpl(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig instance) {
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    this.withProxyURL(instance.getProxyURL()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SafeAuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private SecretKeySelector bearerTokenSecret;
  private String proxyURL;
  private SafeTLSConfigBuilder tlsConfig;
  private Map<java.lang.String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization getAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new SafeAuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} return (A) this;
  }
  public Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public HTTPConfigFluent.AuthorizationNested<A> withNewAuthorization() {
    return new HTTPConfigFluentImpl.AuthorizationNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.AuthorizationNested<A> withNewAuthorizationLike(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
    return new HTTPConfigFluentImpl.AuthorizationNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.AuthorizationNested<A> editOrNewAuthorizationLike(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public BasicAuth getBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.BasicAuth buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} return (A) this;
  }
  public java.lang.Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public HTTPConfigFluent.BasicAuthNested<A> withNewBasicAuth() {
    return new HTTPConfigFluentImpl.BasicAuthNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.BasicAuthNested<A> withNewBasicAuthLike(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
    return new io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluentImpl.BasicAuthNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.BasicAuthNested<A> editOrNewBasicAuthLike(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  public io.fabric8.kubernetes.api.model.SecretKeySelector getBearerTokenSecret() {
    return this.bearerTokenSecret;
  }
  public A withBearerTokenSecret(io.fabric8.kubernetes.api.model.SecretKeySelector bearerTokenSecret) {
    this.bearerTokenSecret=bearerTokenSecret; return (A) this;
  }
  public java.lang.Boolean hasBearerTokenSecret() {
    return this.bearerTokenSecret != null;
  }
  public A withNewBearerTokenSecret(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
    return (A)withBearerTokenSecret(new SecretKeySelector(key, name, optional));
  }
  public java.lang.String getProxyURL() {
    return this.proxyURL;
  }
  public A withProxyURL(java.lang.String proxyURL) {
    this.proxyURL=proxyURL; return (A) this;
  }
  public java.lang.Boolean hasProxyURL() {
    return this.proxyURL != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig getTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new SafeTLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
  }
  public java.lang.Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public HTTPConfigFluent.TlsConfigNested<A> withNewTlsConfig() {
    return new HTTPConfigFluentImpl.TlsConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.TlsConfigNested<A> withNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluentImpl.TlsConfigNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.TlsConfigNested<A> editOrNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPConfigFluentImpl that = (HTTPConfigFluentImpl) o;
    if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
    if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
    if (bearerTokenSecret != null ? !bearerTokenSecret.equals(that.bearerTokenSecret) :that.bearerTokenSecret != null) return false;
    if (proxyURL != null ? !proxyURL.equals(that.proxyURL) :that.proxyURL != null) return false;
    if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerTokenSecret,  proxyURL,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerTokenSecret != null) { sb.append("bearerTokenSecret:"); sb.append(bearerTokenSecret + ","); }
    if (proxyURL != null) { sb.append("proxyURL:"); sb.append(proxyURL + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorizationNestedImpl<N> extends SafeAuthorizationFluentImpl<HTTPConfigFluent.AuthorizationNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.AuthorizationNested<N>,Nested<N>{
    AuthorizationNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder builder;
    public N and() {
      return (N) HTTPConfigFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<HTTPConfigFluent.BasicAuthNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.BasicAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BasicAuthNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder builder;
    public N and() {
      return (N) HTTPConfigFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  class TlsConfigNestedImpl<N> extends SafeTLSConfigFluentImpl<HTTPConfigFluent.TlsConfigNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TlsConfigNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig item) {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder builder;
    public N and() {
      return (N) HTTPConfigFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}