package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPConfigBuilder extends HTTPConfigFluentImpl<HTTPConfigBuilder> implements VisitableBuilder<HTTPConfig,io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder>{
  public HTTPConfigBuilder() {
    this(false);
  }
  public HTTPConfigBuilder(Boolean validationEnabled) {
    this(new HTTPConfig(), validationEnabled);
  }
  public HTTPConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HTTPConfig(), validationEnabled);
  }
  public HTTPConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig instance) {
    this(fluent, instance, false);
  }
  public HTTPConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthorization(instance.getAuthorization()); 
    fluent.withBasicAuth(instance.getBasicAuth()); 
    fluent.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    fluent.withProxyURL(instance.getProxyURL()); 
    fluent.withTlsConfig(instance.getTlsConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig instance) {
    this(instance,false);
  }
  public HTTPConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    this.withProxyURL(instance.getProxyURL()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig build() {
    HTTPConfig buildable = new HTTPConfig(fluent.getAuthorization(),fluent.getBasicAuth(),fluent.getBearerTokenSecret(),fluent.getProxyURL(),fluent.getTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}