package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebTLSConfigBuilder extends WebTLSConfigFluentImpl<WebTLSConfigBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig,WebTLSConfigBuilder>{
  public WebTLSConfigBuilder() {
    this(false);
  }
  public WebTLSConfigBuilder(Boolean validationEnabled) {
    this(new WebTLSConfig(), validationEnabled);
  }
  public WebTLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public WebTLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new WebTLSConfig(), validationEnabled);
  }
  public WebTLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig instance) {
    this(fluent, instance, false);
  }
  public WebTLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCert(instance.getCert()); 
    fluent.withCipherSuites(instance.getCipherSuites()); 
    fluent.withClientAuthType(instance.getClientAuthType()); 
    fluent.withClientCa(instance.getClientCa()); 
    fluent.withCurvePreferences(instance.getCurvePreferences()); 
    fluent.withKeySecret(instance.getKeySecret()); 
    fluent.withMaxVersion(instance.getMaxVersion()); 
    fluent.withMinVersion(instance.getMinVersion()); 
    fluent.withPreferServerCipherSuites(instance.getPreferServerCipherSuites()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public WebTLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig instance) {
    this(instance,false);
  }
  public WebTLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCert(instance.getCert()); 
    this.withCipherSuites(instance.getCipherSuites()); 
    this.withClientAuthType(instance.getClientAuthType()); 
    this.withClientCa(instance.getClientCa()); 
    this.withCurvePreferences(instance.getCurvePreferences()); 
    this.withKeySecret(instance.getKeySecret()); 
    this.withMaxVersion(instance.getMaxVersion()); 
    this.withMinVersion(instance.getMinVersion()); 
    this.withPreferServerCipherSuites(instance.getPreferServerCipherSuites()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig build() {
    WebTLSConfig buildable = new WebTLSConfig(fluent.getCert(),fluent.getCipherSuites(),fluent.getClientAuthType(),fluent.getClientCa(),fluent.getCurvePreferences(),fluent.getKeySecret(),fluent.getMaxVersion(),fluent.getMinVersion(),fluent.getPreferServerCipherSuites());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}