package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebSpecBuilder extends WebSpecFluentImpl<WebSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.WebSpec,io.fabric8.openshift.api.model.monitoring.v1.WebSpecBuilder>{
  public WebSpecBuilder() {
    this(false);
  }
  public WebSpecBuilder(Boolean validationEnabled) {
    this(new WebSpec(), validationEnabled);
  }
  public WebSpecBuilder(WebSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public WebSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new WebSpec(), validationEnabled);
  }
  public WebSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.WebSpec instance) {
    this(fluent, instance, false);
  }
  public WebSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.WebSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPageTitle(instance.getPageTitle()); 
    fluent.withTlsConfig(instance.getTlsConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public WebSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebSpec instance) {
    this(instance,false);
  }
  public WebSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.WebSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPageTitle(instance.getPageTitle()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.WebSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.WebSpec build() {
    WebSpec buildable = new WebSpec(fluent.getPageTitle(),fluent.getTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}