package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ThanosRulerStatusBuilder extends ThanosRulerStatusFluentImpl<ThanosRulerStatusBuilder> implements VisitableBuilder<ThanosRulerStatus,io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusBuilder>{
  public ThanosRulerStatusBuilder() {
    this(false);
  }
  public ThanosRulerStatusBuilder(Boolean validationEnabled) {
    this(new ThanosRulerStatus(), validationEnabled);
  }
  public ThanosRulerStatusBuilder(ThanosRulerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ThanosRulerStatus(), validationEnabled);
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus instance) {
    this(fluent, instance, false);
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus instance) {
    this(instance,false);
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withPaused(instance.getPaused()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus build() {
    ThanosRulerStatus buildable = new ThanosRulerStatus(fluent.getAvailableReplicas(),fluent.getPaused(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}