package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageSpecBuilder extends StorageSpecFluentImpl<StorageSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.StorageSpec,io.fabric8.openshift.api.model.monitoring.v1.StorageSpecBuilder>{
  public StorageSpecBuilder() {
    this(false);
  }
  public StorageSpecBuilder(Boolean validationEnabled) {
    this(new StorageSpec(), validationEnabled);
  }
  public StorageSpecBuilder(StorageSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.StorageSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new StorageSpec(), validationEnabled);
  }
  public StorageSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.StorageSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.StorageSpec instance) {
    this(fluent, instance, false);
  }
  public StorageSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.StorageSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.StorageSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDisableMountSubPath(instance.getDisableMountSubPath()); 
    fluent.withEmptyDir(instance.getEmptyDir()); 
    fluent.withEphemeral(instance.getEphemeral()); 
    fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StorageSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.StorageSpec instance) {
    this(instance,false);
  }
  public StorageSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.StorageSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDisableMountSubPath(instance.getDisableMountSubPath()); 
    this.withEmptyDir(instance.getEmptyDir()); 
    this.withEphemeral(instance.getEphemeral()); 
    this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.StorageSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.StorageSpec build() {
    StorageSpec buildable = new StorageSpec(fluent.getDisableMountSubPath(),fluent.getEmptyDir(),fluent.getEphemeral(),fluent.getVolumeClaimTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}