package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceMonitorListBuilder extends ServiceMonitorListFluentImpl<ServiceMonitorListBuilder> implements VisitableBuilder<ServiceMonitorList,io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorListBuilder>{
  public ServiceMonitorListBuilder() {
    this(false);
  }
  public ServiceMonitorListBuilder(Boolean validationEnabled) {
    this(new ServiceMonitorList(), validationEnabled);
  }
  public ServiceMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceMonitorList(), validationEnabled);
  }
  public ServiceMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorListFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorList instance) {
    this(fluent, instance, false);
  }
  public ServiceMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorListFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorList instance) {
    this(instance,false);
  }
  public ServiceMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorList build() {
    ServiceMonitorList buildable = new ServiceMonitorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}