package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretOrConfigMapBuilder extends SecretOrConfigMapFluentImpl<SecretOrConfigMapBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap,io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder>{
  public SecretOrConfigMapBuilder() {
    this(false);
  }
  public SecretOrConfigMapBuilder(Boolean validationEnabled) {
    this(new SecretOrConfigMap(), validationEnabled);
  }
  public SecretOrConfigMapBuilder(SecretOrConfigMapFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretOrConfigMap(), validationEnabled);
  }
  public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap instance) {
    this(fluent, instance, false);
  }
  public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMap(instance.getConfigMap()); 
    fluent.withSecret(instance.getSecret()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap instance) {
    this(instance,false);
  }
  public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMap(instance.getConfigMap()); 
    this.withSecret(instance.getSecret()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap build() {
    SecretOrConfigMap buildable = new SecretOrConfigMap(fluent.getConfigMap(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}