package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SafeAuthorizationBuilder extends SafeAuthorizationFluentImpl<SafeAuthorizationBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization,io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder>{
  public SafeAuthorizationBuilder() {
    this(false);
  }
  public SafeAuthorizationBuilder(Boolean validationEnabled) {
    this(new SafeAuthorization(), validationEnabled);
  }
  public SafeAuthorizationBuilder(SafeAuthorizationFluent<?> fluent) {
    this(fluent, false);
  }
  public SafeAuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SafeAuthorization(), validationEnabled);
  }
  public SafeAuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization instance) {
    this(fluent, instance, false);
  }
  public SafeAuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredentials(instance.getCredentials()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SafeAuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization instance) {
    this(instance,false);
  }
  public SafeAuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredentials(instance.getCredentials()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization build() {
    SafeAuthorization buildable = new SafeAuthorization(fluent.getCredentials(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}