package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RulesBuilder extends RulesFluentImpl<RulesBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.Rules,RulesBuilder>{
  public RulesBuilder() {
    this(false);
  }
  public RulesBuilder(Boolean validationEnabled) {
    this(new Rules(), validationEnabled);
  }
  public RulesBuilder(RulesFluent<?> fluent) {
    this(fluent, false);
  }
  public RulesBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Rules(), validationEnabled);
  }
  public RulesBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Rules instance) {
    this(fluent, instance, false);
  }
  public RulesBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Rules instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAlert(instance.getAlert()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RulesBuilder(io.fabric8.openshift.api.model.monitoring.v1.Rules instance) {
    this(instance,false);
  }
  public RulesBuilder(io.fabric8.openshift.api.model.monitoring.v1.Rules instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAlert(instance.getAlert()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.RulesFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.Rules build() {
    Rules buildable = new Rules(fluent.getAlert());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}